/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cocoon.environment.commandline.AbstractCommandLineEnvironment;
import org.apache.cocoon.environment.commandline.CommandLineRequest;
import org.apache.cocoon.environment.commandline.CommandLineResponse;
import org.apache.log.Logger;

public class LinkSamplingEnvironment
extends AbstractCommandLineEnvironment {
    private boolean skip = false;

    public LinkSamplingEnvironment(String uri, File contextFile, Map attributes, Map parameters, Logger log) throws MalformedURLException, IOException {
        super(uri, "links", contextFile, new ByteArrayOutputStream(), log);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LinkSamplingEnvironment: uri = " + uri);
        }
        this.objectModel.put("request", new CommandLineRequest(this, null, uri, null, attributes, parameters));
        this.objectModel.put("response", new CommandLineResponse());
    }

    public void setContentType(String contentType) {
        if (!"application/x-cocoon-links".equals(contentType)) {
            this.skip = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getLinks() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        if (this.skip) return list;
        BufferedReader buffer = null;
        try {
            String line;
            buffer = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(((ByteArrayOutputStream)this.stream).toByteArray())));
            while ((line = buffer.readLine()) != null) {
                list.add(line);
            }
            Object var5_4 = null;
            if (buffer == null) return list;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (buffer == null) throw throwable;
            try {
                buffer.close();
                buffer = null;
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            buffer.close();
            buffer = null;
            return list;
        }
        catch (IOException ignored) {}
        return list;
    }
}

