/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ActionSetNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;

public class ActionSetNodeBuilder
extends AbstractProcessingNodeBuilder
implements ThreadSafe {
    public ProcessingNode buildNode(Configuration config2) throws Exception {
        String actionSetName = config2.getAttribute("name");
        ArrayList<String> actionTypes = new ArrayList<String>();
        ArrayList<String> actionNames = new ArrayList<String>();
        ArrayList<VariableResolver> actionSources = new ArrayList<VariableResolver>();
        ArrayList<Map> actionParameters = new ArrayList<Map>();
        Configuration[] childrenConfig = config2.getChildren();
        int i = 0;
        while (i < childrenConfig.length) {
            Configuration childConfig = childrenConfig[i];
            String name = childConfig.getName();
            if (!"act".equals(name)) {
                String msg = "Unknown element " + name + " in action-set at " + childConfig.getLocation();
                this.getLogger().error(msg);
                throw new ConfigurationException(msg);
            }
            this.checkNamespace(childConfig);
            String type = this.treeBuilder.getTypeForStatement(childConfig, "org.apache.cocoon.acting.ActionSelector");
            actionTypes.add(type);
            actionNames.add(childConfig.getAttribute("action", null));
            actionSources.add(VariableResolverFactory.getResolver(childConfig.getAttribute("src", null), this.manager));
            actionParameters.add(this.getParameters(childConfig));
            ++i;
        }
        String[] types = actionTypes.toArray(new String[actionTypes.size()]);
        String[] actions = actionNames.toArray(new String[actionNames.size()]);
        Map[] parameters = actionParameters.toArray(new Map[actionParameters.size()]);
        VariableResolver[] sources = actionSources.toArray(new VariableResolver[actionSources.size()]);
        ActionSetNode node = new ActionSetNode(actionSetName, types, actions, sources, parameters);
        this.treeBuilder.setupNode(node, config2);
        return node;
    }
}

