/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.CachedEventObject;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.components.pipeline.AbstractEventPipeline;
import org.apache.cocoon.components.pipeline.CacheableEventPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.components.saxconnector.SAXConnector;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.xml.sax.SAXException;

public class CachingEventPipeline
extends AbstractEventPipeline
implements Disposable,
CacheableEventPipeline,
Recyclable {
    private Store eventCache;
    private XMLProducer producer;
    private String generatorRole;
    private ArrayList transformerRoles = new ArrayList();
    private ArrayList notCacheableTransformers = new ArrayList();
    private Map validityObjects;
    private PipelineCacheKey pipelineCacheKey;
    private boolean setupFinished = false;
    private boolean cacheable = false;
    private int firstNotCacheableTransformerIndex;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.eventCache = (Store)this.manager.lookup("org.apache.cocoon.components.store.Store/TransientCache");
    }

    public void setGenerator(String role, String source, Parameters param) throws Exception {
        super.setGenerator(role, source, param);
        this.generatorRole = role;
    }

    public void addTransformer(String role, String source, Parameters param) throws Exception {
        super.addTransformer(role, source, param);
        this.transformerRoles.add(role);
    }

    public PipelineCacheKey generateKey(Environment environment) throws Exception {
        this.setup(environment);
        return this.cacheable ? this.pipelineCacheKey : null;
    }

    public Map generateValidity(Environment environment) throws Exception {
        if (this.cacheable) {
            return this.validityObjects;
        }
        return null;
    }

    public void setStreamPipelineCaches(boolean flag) {
        if (flag) {
            this.pipelineCacheKey = null;
        }
    }

    /*
     * Loose catch block
     */
    public boolean process(Environment environment) throws Exception {
        this.setup(environment);
        XMLSerializer xmlSerializer = null;
        try {
            if (this.pipelineCacheKey != null) {
                CachedEventObject cachedObject;
                block15: {
                    cachedObject = (CachedEventObject)this.eventCache.get(this.pipelineCacheKey);
                    if (cachedObject != null) {
                        this.getLogger().debug("Found cached content for '" + environment.getURI() + "'.");
                        Iterator validityIterator = this.validityObjects.keySet().iterator();
                        boolean valid = true;
                        while (validityIterator.hasNext() && valid) {
                            ComponentCacheKey validityKey = (ComponentCacheKey)validityIterator.next();
                            valid = cachedObject.isValid(validityKey, (CacheValidity)this.validityObjects.get(validityKey));
                            if (!this.getLogger().isDebugEnabled()) continue;
                            CacheValidity cachedValidity = cachedObject.getCacheValidity(validityKey);
                            this.getLogger().debug("Compared cached validity '" + cachedValidity + "' with new validity '" + this.validityObjects.get(validityKey) + "' : " + (valid ? "valid" : "changed"));
                        }
                        if (valid) {
                            this.getLogger().debug("Using valid cached content for '" + environment.getURI() + "'.");
                            int transformerSize = this.transformers.size();
                            while (this.firstNotCacheableTransformerIndex < transformerSize) {
                                this.notCacheableTransformers.add(this.transformers.get(this.firstNotCacheableTransformerIndex));
                                ++this.firstNotCacheableTransformerIndex;
                            }
                            XMLDeserializer deserializer = null;
                            try {
                                deserializer = (XMLDeserializer)this.manager.lookup("org.apache.cocoon.components.sax.XMLDeserializer");
                                this.producer = deserializer;
                                this.connectPipeline(environment, this.notCacheableTransformers, null);
                                deserializer.deserialize(cachedObject.getSAXFragment());
                                Object var12_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var12_11 = null;
                                this.manager.release((Component)deserializer);
                                throw throwable;
                            }
                            this.manager.release((Component)deserializer);
                            {
                                break block15;
                                catch (ProcessingException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw new ProcessingException("Failed to execute pipeline.", e);
                                }
                            }
                        }
                        this.getLogger().debug("Cached content is invalid for '" + environment.getURI() + "'.");
                        this.eventCache.remove(this.pipelineCacheKey);
                        cachedObject = null;
                    }
                }
                if (cachedObject == null) {
                    this.getLogger().debug("Caching content for further requests of '" + environment.getURI() + "'.");
                    xmlSerializer = (XMLSerializer)this.manager.lookup("org.apache.cocoon.components.sax.XMLSerializer");
                }
            }
            if (this.producer == null) {
                this.producer = this.generator;
                this.connectPipeline(environment, this.transformers, xmlSerializer);
                this.generator.generate();
                if (xmlSerializer != null) {
                    this.eventCache.store(this.pipelineCacheKey, new CachedEventObject(this.validityObjects, xmlSerializer.getSAXFragment()));
                }
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.manager.release(xmlSerializer);
            throw throwable;
        }
        this.manager.release(xmlSerializer);
        return true;
    }

    private void setup(Environment environment) throws Exception {
        if (this.setupFinished) {
            return;
        }
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        this.setupPipeline(environment);
        this.firstNotCacheableTransformerIndex = 0;
        if (this.generator instanceof Cacheable) {
            long key = ((Cacheable)((Object)this.generator)).generateKey();
            CacheValidity validity = ((Cacheable)((Object)this.generator)).generateValidity();
            if (key != 0L && validity != null) {
                ComponentCacheKey cck = new ComponentCacheKey(1, this.generatorRole, key);
                this.validityObjects = new HashMap();
                this.validityObjects.put(cck, validity);
                this.pipelineCacheKey = new PipelineCacheKey();
                this.pipelineCacheKey.addKey(cck);
                int transformerSize = this.transformers.size();
                boolean testTrans = true;
                while (this.firstNotCacheableTransformerIndex < transformerSize && testTrans) {
                    Transformer trans = (Transformer)this.transformers.get(this.firstNotCacheableTransformerIndex);
                    if (trans instanceof Cacheable) {
                        long transKey = ((Cacheable)((Object)trans)).generateKey();
                        CacheValidity transValidity = ((Cacheable)((Object)trans)).generateValidity();
                        if (transKey != 0L && transValidity != null) {
                            ComponentCacheKey transCacheKey = new ComponentCacheKey(2, (String)this.transformerRoles.get(this.firstNotCacheableTransformerIndex), transKey);
                            this.pipelineCacheKey.addKey(transCacheKey);
                            this.validityObjects.put(transCacheKey, transValidity);
                        } else {
                            testTrans = false;
                        }
                    } else {
                        testTrans = false;
                    }
                    if (!testTrans) continue;
                    ++this.firstNotCacheableTransformerIndex;
                }
                if (this.firstNotCacheableTransformerIndex == transformerSize) {
                    this.cacheable = true;
                }
            }
        }
        this.setupFinished = true;
    }

    private void connectPipeline(Environment environment, ArrayList usedTransformers, XMLSerializer xmlSerializer) throws ProcessingException {
        XMLProducer prev = this.producer;
        boolean configuredSAXConnector = this.manager.hasComponent("org.apache.cocoon.components.saxconnector.SAXConnector");
        try {
            XMLConsumer next;
            SAXConnector connect;
            int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
            Iterator itt = usedTransformers.iterator();
            while (itt.hasNext()) {
                if (configuredSAXConnector) {
                    connect = (SAXConnector)this.manager.lookup("org.apache.cocoon.components.saxconnector.SAXConnector");
                    connect.setup(environment, environment.getObjectModel(), null, null);
                    this.connectors.add(connect);
                    next = connect;
                    prev.setConsumer(next);
                    prev = connect;
                }
                next = (XMLConsumer)itt.next();
                if (xmlSerializer != null) {
                    if (cacheableTransformerCount == 0) {
                        next = new XMLTeePipe(next, xmlSerializer);
                        xmlSerializer = null;
                    } else {
                        --cacheableTransformerCount;
                    }
                }
                prev.setConsumer(next);
                prev = (XMLProducer)((Object)next);
            }
            if (configuredSAXConnector) {
                connect = (SAXConnector)this.manager.lookup("org.apache.cocoon.components.saxconnector.SAXConnector");
                connect.setup(environment, environment.getObjectModel(), null, null);
                this.connectors.add(connect);
                next = connect;
                prev.setConsumer(next);
                prev = connect;
            }
            next = this.xmlConsumer;
            if (xmlSerializer != null) {
                next = new XMLTeePipe(next, xmlSerializer);
                xmlSerializer = null;
            }
            prev.setConsumer(next);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
        catch (SAXException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
        catch (ComponentException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
    }

    public void recycle() {
        this.getLogger().debug("Recycling of CachingEventPipeline");
        super.recycle();
        this.producer = null;
        this.generatorRole = null;
        this.transformerRoles.clear();
        this.notCacheableTransformers.clear();
        this.validityObjects = null;
        this.pipelineCacheKey = null;
        this.setupFinished = false;
        this.cacheable = false;
    }

    public void dispose() {
        this.manager.release((Component)this.eventCache);
        super.dispose();
    }
}

