/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Arrays;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;

public class ExtensionFunction
extends Operation {
    private QName functionName;

    public ExtensionFunction(QName functionName, Expression[] args) {
        super(18, args);
        this.functionName = functionName;
    }

    public QName getFunctionName() {
        return this.functionName;
    }

    public boolean computeContextDependent() {
        return true;
    }

    public String opCodeToString() {
        return super.opCodeToString() + ':' + this.functionName;
    }

    public Object compute(EvalContext context) {
        return this.computeValue(context);
    }

    public Object computeValue(EvalContext context) {
        Function function;
        Object[] parameters = null;
        if (this.args != null) {
            parameters = new Object[this.args.length];
            int i = 0;
            while (i < this.args.length) {
                Object param;
                parameters[i] = param = this.args[i].compute(context);
                ++i;
            }
        }
        if ((function = context.getRootContext().getFunction(this.functionName, parameters)) == null) {
            throw new JXPathException("No such function: " + this.functionName + Arrays.asList(parameters));
        }
        return function.invoke(context, parameters);
    }
}

