/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIUtil;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;
import org.apache.commons.httpclient.methods.GetMethod;

public class PostMethod
extends GetMethod {
    private String requestBody = null;
    private HashMap parameters = new HashMap();
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.methods.PostMethod");

    public PostMethod() {
    }

    public PostMethod(String path) {
        super(path);
    }

    public PostMethod(String path, String tempDir) {
        super(path, tempDir);
    }

    public PostMethod(String path, String tempDir, String tempFile) {
        super(path, tempDir, tempFile);
    }

    public String getName() {
        return "POST";
    }

    public void recycle() {
        super.recycle();
        this.requestBody = null;
        this.parameters.clear();
    }

    public void setParameter(String parameterName, String parameterValue) {
        if (null != this.requestBody) {
            throw new IllegalStateException("Request body already generated.");
        }
        this.parameters.put(parameterName, parameterValue);
    }

    public void addParameter(String parameterName, String parameterValue) {
        if (null != this.requestBody) {
            throw new IllegalStateException("Request body already generated.");
        }
        String old = this.parameters.put(parameterName, parameterValue);
        if (null != old) {
            List<String> v = null;
            if (old instanceof String) {
                v = new ArrayList<String>();
                v.add(old);
            } else if (old instanceof List) {
                v = (List)((Object)old);
            } else {
                throw new ClassCastException("Didn't expect to find " + old.getClass().getName() + " as parameter value for \"" + parameterName + "\"");
            }
            v.add(parameterValue);
            this.parameters.put(parameterName, v);
        }
    }

    public void removeParameter(String paramName) {
        if (null != this.requestBody) {
            throw new IllegalStateException("Request body already generated.");
        }
        this.parameters.remove(paramName);
    }

    public void removeParameter(String paramName, String paramValue) {
        if (null != this.requestBody) {
            throw new IllegalStateException("Request body already generated.");
        }
        Object old = this.parameters.get(paramName);
        if (null != old) {
            List list;
            if (paramValue.equals(old)) {
                this.parameters.remove(paramName);
            } else if (old instanceof List && (list = (List)old).remove(paramValue)) {
                if (list.isEmpty()) {
                    this.parameters.remove(paramName);
                } else if (list.size() == 1) {
                    this.parameters.put(paramName, list.get(0));
                } else {
                    this.parameters.put(paramValue, list);
                }
            }
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (!this.parameters.isEmpty()) {
            this.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        }
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        log.debug("PostMethod.writeRequestBody(HttpState,HttpConnection)");
        if (null == this.requestBody) {
            this.requestBody = this.generateRequestBody(this.parameters);
        }
        conn.print(this.requestBody);
        return true;
    }

    protected int getRequestContentLength() {
        if (null == this.requestBody) {
            this.requestBody = this.generateRequestBody(this.parameters);
        }
        return this.requestBody.getBytes().length;
    }

    protected String generateRequestBody(HashMap params) {
        if (!params.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Iterator it = this.parameters.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object value = this.parameters.get(name);
                if (value instanceof List) {
                    List list = (List)value;
                    Iterator valit = list.iterator();
                    while (valit.hasNext()) {
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        sb.append(URIUtil.encode(name, URIUtil.queryStringValueSafe(), true));
                        Object val2 = valit.next();
                        if (null == val2) continue;
                        sb.append("=");
                        sb.append(URIUtil.encode(String.valueOf(val2), URIUtil.queryStringValueSafe(), true));
                    }
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(URIUtil.encode(name, URIUtil.queryStringValueSafe()));
                if (null == value) continue;
                sb.append("=");
                sb.append(URIUtil.encode(String.valueOf(value), URIUtil.queryStringValueSafe(), true));
            }
            return sb.toString();
        }
        return "";
    }
}

