/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.util.Hashtable;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

public class IPAccessHandler
extends AbstractHttpHandler {
    boolean standard = false;
    Hashtable ips = new Hashtable();

    public boolean checkIP(String ipstring) {
        Boolean ipconstrain = (Boolean)this.ips.get(ipstring);
        if (ipconstrain != null) {
            return ipconstrain;
        }
        return this.standard;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        try {
            String ip = request.getRemoteAddr();
            boolean authorized = this.checkIP(ip);
            if (!authorized) {
                response.sendError(403);
                request.setHandled(true);
                return;
            }
            return;
        }
        catch (Exception ex) {
            System.out.println(ex);
            response.sendError(500);
            request.setHandled(true);
            return;
        }
    }

    public void setAllowIP(String ipstring) {
        this.ips.put(ipstring, new Boolean(true));
    }

    public void setDenyIP(String ipstring) {
        this.ips.put(ipstring, new Boolean(false));
    }

    public void setStandard(String s) {
        this.standard = (s = s.toLowerCase()).indexOf("allow") > -1;
    }

    private static void main(String[] args) {
        IPAccessHandler ipah = new IPAccessHandler();
        ipah.setStandard("deny");
        ipah.setAllowIP("217.215.71.167");
        ipah.setDenyIP("217.215.71.149");
        System.out.println(ipah.checkIP("217.215.71.245") + " = false");
        System.out.println(ipah.checkIP("217.215.71.167") + " = true");
        System.out.println(ipah.checkIP("217.215.71.149") + " = false");
        System.out.println(ipah.checkIP("0.0.0.0") + " = false");
        IPAccessHandler ipah2 = new IPAccessHandler();
        ipah2.setStandard("allow");
        ipah2.setAllowIP("217.215.71.167");
        ipah2.setDenyIP("217.215.71.149");
        System.out.println(ipah2.checkIP("217.215.71.245") + " = true");
        System.out.println(ipah2.checkIP("217.215.71.167") + " = true");
        System.out.println(ipah2.checkIP("217.215.71.149") + " = false");
        System.out.println(ipah2.checkIP("0.0.0.0") + " = true");
    }
}

