/*
 * Decompiled with CFR 0.152.
 */
package luke;

import java.util.Hashtable;
import luke.TermInfo;
import luke.TermInfoQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class HighFreqTerms {
    public static int defaultNumTerms = 100;

    public static void main(String[] args) throws Exception {
        FSDirectory dir = FSDirectory.getDirectory((String)args[0], (boolean)false);
        TermInfo[] terms = HighFreqTerms.getHighFreqTerms((Directory)dir, null, new String[]{"body"});
        int i = 0;
        while (i < terms.length) {
            System.out.println(String.valueOf(i) + ".\t" + terms[i].term);
            ++i;
        }
    }

    public static TermInfo[] getHighFreqTerms(Directory dir, Hashtable junkWords, String[] fields) throws Exception {
        return HighFreqTerms.getHighFreqTerms(dir, junkWords, defaultNumTerms, fields);
    }

    public static TermInfo[] getHighFreqTerms(Directory dir, Hashtable junkWords, int numTerms, String[] fields) throws Exception {
        if (dir == null || fields == null) {
            return null;
        }
        IndexReader reader = IndexReader.open((Directory)dir);
        TermInfoQueue tiq = new TermInfoQueue(numTerms);
        TermEnum terms = reader.terms();
        int minFreq = 0;
        while (terms.next()) {
            String field = terms.term().field();
            if (fields != null && fields.length > 0) {
                boolean skip = true;
                int i = 0;
                while (i < fields.length) {
                    if (field.equals(fields[i])) {
                        skip = false;
                        break;
                    }
                    ++i;
                }
                if (skip) continue;
            }
            if (junkWords != null && junkWords.get(terms.term().text()) != null || terms.docFreq() <= minFreq) continue;
            tiq.put(new TermInfo(terms.term(), terms.docFreq()));
            if (tiq.size() < numTerms) continue;
            tiq.pop();
            minFreq = ((TermInfo)tiq.top()).docFreq;
        }
        TermInfo[] res = new TermInfo[tiq.size()];
        int i = 0;
        while (i < res.length) {
            res[res.length - i - 1] = (TermInfo)tiq.pop();
            ++i;
        }
        reader.close();
        return res;
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir>\n\n");
    }
}

