/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.piped;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.excalibur.altrmi.common.AltrmiConnectionException;
import org.apache.excalibur.altrmi.server.impl.AbstractServer;
import org.apache.excalibur.altrmi.server.impl.ServerStreamReadWriter;
import org.apache.excalibur.altrmi.server.impl.piped.PipedStreamServerConnection;

public abstract class AbstractPipedServer
extends AbstractServer {
    public void makeNewConnection(PipedInputStream in, PipedOutputStream out) throws AltrmiConnectionException {
        if (this.mState == 44) {
            throw new AltrmiConnectionException("Server not started yet");
        }
        if (this.mState == 11) {
            throw new AltrmiConnectionException("Server is Shutting down");
        }
        try {
            PipedInputStream pIS = new PipedInputStream();
            PipedOutputStream pOS = new PipedOutputStream();
            pIS.connect(out);
            in.connect(pOS);
            ServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
            ssrw.setStreams(pIS, pOS);
            PipedStreamServerConnection pssc = new PipedStreamServerConnection(this, pIS, pOS, ssrw);
            pssc.enableLogging(this.getLogger());
            Thread thread = new Thread((Runnable)pssc, "PipedStreamServerConnection Thread");
            thread.start();
        }
        catch (IOException pe) {
            throw new AltrmiConnectionException("Some problem setting up server : " + pe.getMessage());
        }
    }

    public void start() {
        this.mState = 22;
    }

    public void stop() {
        this.mState = 11;
        this.killAllConnections();
        this.mState = 33;
    }

    protected abstract ServerStreamReadWriter createServerStreamReadWriter();
}

