/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.DatabaseCallback;
import com.coyotegulch.jisp.DatabaseException;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectDatabaseFile;
import com.coyotegulch.jisp.ObjectIndex;
import com.coyotegulch.jisp.ObjectIndexOrdered;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class IndexedObjectDatabase
extends ObjectDatabaseFile {
    private boolean m_locked = false;
    private Vector m_indexes = new Vector();
    private DatabaseCallback m_callback = null;
    private static final DatabaseException err_locked = new DatabaseException("lock violation for database file");
    private static final DatabaseException err_no_indexes = new DatabaseException("no indexes associated with this database");
    private static final DatabaseException err_invalid_index = new DatabaseException("given index is not associated with this database");

    public IndexedObjectDatabase(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    public synchronized void attachIndex(ObjectIndex objectIndex) {
        this.m_indexes.addElement(objectIndex);
    }

    public synchronized void removeIndex(ObjectIndex objectIndex) {
        this.m_indexes.removeElement(objectIndex);
    }

    public synchronized void insert(KeyObject[] keyObjectArray, Serializable serializable) throws IOException, DatabaseException, ClassNotFoundException {
        this.validateOperation(null);
        long l = this.writeObject(serializable);
        int n = 0;
        while (n < this.m_indexes.size()) {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.insertKey(keyObjectArray[n], l);
            ++n;
        }
    }

    public synchronized void write(KeyObject[] keyObjectArray, Serializable serializable) throws IOException, DatabaseException, ClassNotFoundException {
        this.validateOperation(null);
        try {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(0);
            long l = objectIndex.findKey(keyObjectArray[0]);
            this.seek(l);
            this.delete();
        }
        catch (KeyNotFound keyNotFound) {
            // empty catch block
        }
        long l = this.writeObject(serializable);
        int n = 0;
        while (n < this.m_indexes.size()) {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.storeKey(keyObjectArray[n], l);
            ++n;
        }
    }

    public synchronized Object read(KeyObject keyObject, ObjectIndex objectIndex) throws IOException, DatabaseException, ClassNotFoundException {
        long l;
        this.validateOperation(objectIndex);
        try {
            l = objectIndex.findKey(keyObject);
        }
        catch (KeyNotFound keyNotFound) {
            return null;
        }
        this.seek(l);
        return this.readObject();
    }

    public synchronized void remove(KeyObject[] keyObjectArray) throws IOException, DatabaseException, ClassNotFoundException {
        this.validateOperation(null);
        ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(0);
        long l = objectIndex.findKey(keyObjectArray[0]);
        this.seek(l);
        this.delete();
        int n = 0;
        while (n < this.m_indexes.size()) {
            objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.removeKey(keyObjectArray[n]);
            ++n;
        }
    }

    public synchronized void inOrder(ObjectIndexOrdered objectIndexOrdered, DatabaseCallback databaseCallback) throws DatabaseException, IOException, ClassNotFoundException {
        this.validateOperation(null);
        this.m_callback = databaseCallback;
        objectIndexOrdered.inOrder(this);
    }

    public synchronized void inOrderFrom(ObjectIndexOrdered objectIndexOrdered, DatabaseCallback databaseCallback, KeyObject keyObject) throws DatabaseException, IOException, ClassNotFoundException {
        this.validateOperation(null);
        this.m_callback = databaseCallback;
        objectIndexOrdered.inOrderFrom(this, keyObject);
    }

    public synchronized void inOrderThru(ObjectIndexOrdered objectIndexOrdered, DatabaseCallback databaseCallback, KeyObject keyObject) throws DatabaseException, IOException, ClassNotFoundException {
        this.validateOperation(null);
        this.m_callback = databaseCallback;
        objectIndexOrdered.inOrderThru(this, keyObject);
    }

    public synchronized void inOrderRange(ObjectIndexOrdered objectIndexOrdered, DatabaseCallback databaseCallback, KeyObject keyObject, KeyObject keyObject2) throws DatabaseException, IOException, ClassNotFoundException {
        this.validateOperation(null);
        this.m_callback = databaseCallback;
        objectIndexOrdered.inOrderRange(this, keyObject, keyObject2);
    }

    void inOrderCallback(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        this.seek(l);
        this.m_callback.processRecord(keyObject, this.readObject());
    }

    private void validateOperation(ObjectIndex objectIndex) throws DatabaseException, IOException, ClassNotFoundException {
        if (this.m_locked) {
            throw err_locked;
        }
        if (this.m_indexes.size() <= 0) {
            throw err_no_indexes;
        }
        if (objectIndex != null && !this.m_indexes.contains(objectIndex)) {
            throw err_invalid_index;
        }
    }
}

