/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.deli;

import com.hp.hpl.deli.Profile;
import com.hp.hpl.deli.Workspace;
import java.util.Date;

class CachedProfile {
    private Profile theProfile;
    private Date dateAccquired;
    private String profileResource;

    CachedProfile() {
    }

    protected boolean set(Workspace workspace, String string) throws Exception {
        this.profileResource = string;
        this.theProfile = new Profile(workspace, this.profileResource);
        workspace.printDebug("CachedProfile: Putting profile " + this.profileResource + " in cache");
        this.dateAccquired = new Date();
        return true;
    }

    protected Profile get() throws Exception {
        Date date = new Date();
        long l = date.getTime() - this.dateAccquired.getTime();
        if (this.theProfile.workspace.refreshStaleProfiles && l >= this.theProfile.workspace.maxCachedProfileLifetime) {
            Profile profile = this.theProfile;
            this.theProfile.workspace.printDebug("CachedProfile: Updating profile");
            if (!this.set(this.theProfile.workspace, this.profileResource)) {
                this.theProfile.workspace.printDebug("CachedProfile: Profile update failed");
                this.theProfile = profile;
                this.dateAccquired = date;
            }
        }
        return this.theProfile;
    }
}

