/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.IncludeCacheValidity;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CachingCIncludeTransformer
extends AbstractTransformer
implements Composable,
Cacheable {
    public static final String CINCLUDE_NAMESPACE_URI = "http://apache.org/cocoon/include/1.0";
    public static final String CINCLUDE_INCLUDE_ELEMENT = "include";
    public static final String CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE = "src";
    public static final String CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE = "element";
    public static final String CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE = "ns";
    public static final String CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE = "prefix";
    protected SourceResolver sourceResolver;
    protected ComponentManager manager = null;
    protected IncludeCacheValidity currentCacheValidity;
    protected IncludeXMLConsumer consumer;

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.sourceResolver = resolver;
    }

    public final void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void recycle() {
        super.recycle();
        this.sourceResolver = null;
        this.currentCacheValidity = null;
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (uri != null && name != null && uri.equals(CINCLUDE_NAMESPACE_URI) && name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            this.processCIncludeElement(attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_SRC_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_ELEMENT_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_NS_ATTRIBUTE), attr.getValue("", CINCLUDE_INCLUDE_ELEMENT_PREFIX_ATTRIBUTE));
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (uri != null && name != null && uri.equals(CINCLUDE_NAMESPACE_URI) && name.equals(CINCLUDE_INCLUDE_ELEMENT)) {
            return;
        }
        super.endElement(uri, name, raw);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.currentCacheValidity != null) {
            this.currentCacheValidity.setIsNew2False();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processCIncludeElement(String src, String element, String ns, String prefix) throws SAXException {
        block19: {
            block18: {
                if (element == null) {
                    element = "";
                }
                if (ns == null) {
                    ns = "";
                }
                if (prefix == null) {
                    prefix = "";
                }
                this.getLogger().debug("Processing CInclude element: src=" + src + ", element=" + element + ", ns=" + ns + ", prefix=" + prefix);
                if (this.currentCacheValidity != null) {
                    Source temp = null;
                    try {
                        try {
                            temp = this.sourceResolver.resolve(src);
                            this.currentCacheValidity.add(src, temp.getLastModified());
                            this.getLogger().debug("currentCacheValidity: " + this.currentCacheValidity);
                        }
                        catch (Exception e) {
                            this.getLogger().error("CachingCIncludeTransformer could not resolve resource:" + src, (Throwable)e);
                            throw new SAXException("CachingCIncludeTransformer could not resolve resource", e);
                        }
                        Object var8_6 = null;
                        if (temp == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        if (temp != null) {
                            temp.recycle();
                        }
                        throw throwable;
                    }
                    temp.recycle();
                }
            }
            if (!"".equals(element)) {
                AttributesImpl attrs = new AttributesImpl();
                if (!ns.equals("")) {
                    super.startPrefixMapping(prefix, ns);
                }
                super.startElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element, attrs);
            }
            Source source = null;
            try {
                try {
                    source = this.sourceResolver.resolve(src);
                    source.toSAX(this.getConsumer());
                }
                catch (Exception e) {
                    this.getLogger().error("CachingCIncludeTransformer", (Throwable)e);
                    throw new SAXException("CachingCIncludeTransformer could not read resource", e);
                }
                Object var10_11 = null;
                if (source == null) break block19;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (source != null) {
                    source.recycle();
                }
                throw throwable;
            }
            source.recycle();
        }
        if (!"".equals(element)) {
            super.endElement(ns, element, !ns.equals("") && !prefix.equals("") ? prefix + ":" + element : element);
            if (!ns.equals("")) {
                super.endPrefixMapping(prefix);
            }
        }
    }

    public long generateKey() {
        return 1L;
    }

    public CacheValidity generateValidity() {
        this.getLogger().debug("generateValidity");
        try {
            this.currentCacheValidity = new IncludeCacheValidity(this.sourceResolver);
            return this.currentCacheValidity;
        }
        catch (RuntimeException e) {
            this.getLogger().error("CachingCIncludeTransformer: could not generateKey", (Throwable)e);
            return null;
        }
    }

    protected IncludeXMLConsumer getConsumer() {
        if (this.consumer == null) {
            this.consumer = new IncludeXMLConsumer(this);
        }
        return this.consumer;
    }
}

