/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.search.LuceneCocoonHelper;
import org.apache.cocoon.components.search.LuceneCocoonPager;
import org.apache.cocoon.components.search.LuceneCocoonSearcher;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.apache.lucene.store.Directory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SearchGenerator
extends ComposerGenerator
implements Contextualizable,
Initializable,
Disposable {
    protected static final String namespace = "http://apache.org/cocoon/search/1.0";
    protected static final String xlinkNamespace = "http://www.w3.org/1999/xlink";
    protected static final String CDATA = "CDATA";
    protected static final String RESULTS_ELEMENT = "results";
    protected static final String DATE_ATTRIBUTE = "date";
    protected static final String QUERY_STRING_ATTRIBUTE = "query-string";
    protected static final String START_INDEX_ATTRIBUTE = "start-index";
    protected static final String PAGE_LENGTH_ATTRIBUTE = "page-length";
    protected static final String HITS_ELEMENT = "hits";
    protected static final String TOTAL_COUNT_ATTRIBUTE = "total-count";
    protected static final String COUNT_OF_PAGES_ATTRIBUTE = "count-of-pages";
    protected static final String HIT_ELEMENT = "hit";
    protected static final String RANK_ATTRIBUTE = "rank";
    protected static final String SCORE_ATTRIBUTE = "score";
    protected static final String URI_ATTRIBUTE = "uri";
    protected static final String FIELD_ELEMENT = "field";
    protected static final String NAVIGATION_ELEMENT = "navigation";
    protected static final String NAVIGATION_PAGE_ELEMENT = "navigation-page";
    protected static final String HAS_NEXT_ATTRIBUTE = "has-next";
    protected static final String HAS_PREVIOUS_ATTRIBUTE = "has-previous";
    protected static final String NEXT_INDEX_ATTRIBUTE = "next-index";
    protected static final String PREVIOUS_INDEX_ATTRIBUTE = "previous-index";
    protected static final String INDEX_PARAM = "index";
    protected static final String INDEX_PARAM_DEFAULT = "index";
    protected static final String QUERY_STRING_PARAM = "query-string";
    protected static final String QUERY_STRING_PARAM_DEFAULT = "queryString";
    protected static final String START_INDEX_PARAM = "start-index";
    protected static final String START_INDEX_PARAM_DEFAULT = "startIndex";
    protected static final String START_INDEX_NEXT_PARAM = "start-next-index";
    protected static final String START_INDEX_NEXT_PARAM_DEFAULT = "startNextIndex";
    protected static final String START_INDEX_PREVIOUS_PARAM = "start-previous-index";
    protected static final String START_INDEX_PREVIOUS_PARAM_DEFAULT = "startPreviousIndex";
    protected static final int START_INDEX_DEFAULT = 0;
    protected static final String PAGE_LENGTH_PARAM = "page-length";
    protected static final String PAGE_LENGTH_PARAM_DEFAULT = "pageLength";
    protected static final int PAGE_LENGTH_DEFAULT = 10;
    private File workDir = null;
    private LuceneCocoonSearcher lcs;
    private File index = null;
    private String queryString = "";
    private final AttributesImpl atts = new AttributesImpl();
    private Integer startIndex = null;
    private Integer pageLength = null;

    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String param_name;
        super.setup(resolver, objectModel, src, par);
        Request request = ObjectModelHelper.getRequest(objectModel);
        String index_file_name = par.getParameter("index", "index");
        if (request.getParameter("index") != null) {
            index_file_name = request.getParameter("index");
        }
        this.index = new File(index_file_name);
        if (!this.index.isAbsolute()) {
            this.index = new File(this.workDir, this.index.toString());
        }
        if (request.getParameter(param_name = par.getParameter("query-string", QUERY_STRING_PARAM_DEFAULT)) != null) {
            this.queryString = request.getParameter(param_name);
        }
        this.startIndex = null;
        param_name = par.getParameter(START_INDEX_NEXT_PARAM, START_INDEX_NEXT_PARAM_DEFAULT);
        if (request.getParameter(param_name) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (this.startIndex == null && request.getParameter(param_name = par.getParameter(START_INDEX_PREVIOUS_PARAM, START_INDEX_PREVIOUS_PARAM_DEFAULT)) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (this.startIndex == null && request.getParameter(param_name = par.getParameter("start-index", START_INDEX_PARAM_DEFAULT)) != null) {
            this.startIndex = this.createInteger(request.getParameter(param_name));
        }
        if (request.getParameter(param_name = par.getParameter("page-length", PAGE_LENGTH_PARAM_DEFAULT)) != null) {
            this.pageLength = this.createInteger(request.getParameter(param_name));
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
    }

    public void initialize() throws IOException {
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        if (this.startIndex == null) {
            this.startIndex = new Integer(0);
        }
        if (this.pageLength == null) {
            this.pageLength = new Integer(10);
        }
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("search", namespace);
        this.contentHandler.startPrefixMapping("xlink", xlinkNamespace);
        this.generateResults();
        this.contentHandler.endPrefixMapping("xlink");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
    }

    private Integer createInteger(String s) {
        Integer i;
        block2: {
            i = null;
            try {
                i = new Integer(s);
            }
            catch (NumberFormatException nfe) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Cannot convert " + s + " to Integer", (Throwable)nfe);
            }
        }
        return i;
    }

    private void generateResults() throws SAXException, ProcessingException {
        LuceneCocoonPager pager = this.buildHits();
        long time = System.currentTimeMillis();
        this.atts.clear();
        this.atts.addAttribute(namespace, DATE_ATTRIBUTE, DATE_ATTRIBUTE, CDATA, String.valueOf(time));
        if (this.queryString != null && this.queryString.length() > 0) {
            this.atts.addAttribute(namespace, "query-string", "query-string", CDATA, String.valueOf(this.queryString));
        }
        this.atts.addAttribute(namespace, "start-index", "start-index", CDATA, String.valueOf(this.startIndex));
        this.atts.addAttribute(namespace, "page-length", "page-length", CDATA, String.valueOf(this.pageLength));
        this.contentHandler.startElement(namespace, RESULTS_ELEMENT, RESULTS_ELEMENT, this.atts);
        this.generateHits(pager);
        this.generateNavigation(pager);
        this.contentHandler.endElement(namespace, RESULTS_ELEMENT, RESULTS_ELEMENT);
    }

    private void generateHits(LuceneCocoonPager pager) throws SAXException {
        if (pager != null && pager.hasNext()) {
            this.atts.clear();
            this.atts.addAttribute(namespace, TOTAL_COUNT_ATTRIBUTE, TOTAL_COUNT_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfHits()));
            this.atts.addAttribute(namespace, COUNT_OF_PAGES_ATTRIBUTE, COUNT_OF_PAGES_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfPages()));
            this.contentHandler.startElement(namespace, HITS_ELEMENT, HITS_ELEMENT, this.atts);
            this.generateHit(pager);
            this.contentHandler.endElement(namespace, HITS_ELEMENT, HITS_ELEMENT);
        }
    }

    private void generateHit(LuceneCocoonPager pager) throws SAXException {
        int counter = pager.getStartIndex();
        List l = (List)pager.next();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            LuceneCocoonPager.HitWrapper hw = (LuceneCocoonPager.HitWrapper)i.next();
            Document doc = hw.getDocument();
            float score = hw.getScore();
            String uri = doc.get("url");
            this.atts.clear();
            this.atts.addAttribute(namespace, RANK_ATTRIBUTE, RANK_ATTRIBUTE, CDATA, String.valueOf(counter));
            this.atts.addAttribute(namespace, SCORE_ATTRIBUTE, SCORE_ATTRIBUTE, CDATA, String.valueOf(score));
            this.atts.addAttribute(namespace, URI_ATTRIBUTE, URI_ATTRIBUTE, CDATA, String.valueOf(uri));
            this.contentHandler.startElement(namespace, HIT_ELEMENT, HIT_ELEMENT, this.atts);
            Enumeration e = doc.fields();
            while (e.hasMoreElements()) {
                Field field = (Field)e.nextElement();
                if (!field.isStored() || "url".equals(field.name())) continue;
                this.atts.clear();
                this.atts.addAttribute(namespace, "name", "name", CDATA, field.name());
                this.contentHandler.startElement(namespace, FIELD_ELEMENT, FIELD_ELEMENT, this.atts);
                String value = field.stringValue();
                this.contentHandler.characters(value.toCharArray(), 0, value.length());
                this.contentHandler.endElement(namespace, FIELD_ELEMENT, FIELD_ELEMENT);
            }
            this.contentHandler.endElement(namespace, HIT_ELEMENT, HIT_ELEMENT);
            ++counter;
        }
    }

    private void generateNavigation(LuceneCocoonPager pager) throws SAXException {
        if (pager != null) {
            this.atts.clear();
            this.atts.addAttribute(namespace, TOTAL_COUNT_ATTRIBUTE, TOTAL_COUNT_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfHits()));
            this.atts.addAttribute(namespace, COUNT_OF_PAGES_ATTRIBUTE, COUNT_OF_PAGES_ATTRIBUTE, CDATA, String.valueOf(pager.getCountOfPages()));
            this.atts.addAttribute(namespace, HAS_NEXT_ATTRIBUTE, HAS_NEXT_ATTRIBUTE, CDATA, String.valueOf(pager.hasNext()));
            this.atts.addAttribute(namespace, HAS_PREVIOUS_ATTRIBUTE, HAS_PREVIOUS_ATTRIBUTE, CDATA, String.valueOf(pager.hasPrevious()));
            this.atts.addAttribute(namespace, NEXT_INDEX_ATTRIBUTE, NEXT_INDEX_ATTRIBUTE, CDATA, String.valueOf(pager.nextIndex()));
            this.atts.addAttribute(namespace, PREVIOUS_INDEX_ATTRIBUTE, PREVIOUS_INDEX_ATTRIBUTE, CDATA, String.valueOf(pager.previousIndex()));
            this.contentHandler.startElement(namespace, NAVIGATION_ELEMENT, NAVIGATION_ELEMENT, this.atts);
            int count_of_pages = pager.getCountOfPages();
            int i = 0;
            int page_start_index = 0;
            while (i < count_of_pages) {
                this.atts.clear();
                this.atts.addAttribute(namespace, "start-index", "start-index", CDATA, String.valueOf(page_start_index));
                this.contentHandler.startElement(namespace, NAVIGATION_PAGE_ELEMENT, NAVIGATION_PAGE_ELEMENT, this.atts);
                this.contentHandler.endElement(namespace, NAVIGATION_PAGE_ELEMENT, NAVIGATION_PAGE_ELEMENT);
                ++i;
                page_start_index += this.pageLength.intValue();
            }
            this.contentHandler.endElement(namespace, NAVIGATION_ELEMENT, NAVIGATION_ELEMENT);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LuceneCocoonPager buildHits() throws ProcessingException {
        if (this.queryString != null && this.queryString.length() != 0) {
            Hits hits;
            block11: {
                hits = null;
                try {
                    try {
                        this.lcs = (LuceneCocoonSearcher)this.manager.lookup("org.apache.cocoon.components.search.LuceneCocoonSearcher");
                        Analyzer analyzer = LuceneCocoonHelper.getAnalyzer("org.apache.lucene.analysis.standard.StandardAnalyzer");
                        this.lcs.setAnalyzer(analyzer);
                        Directory directory = LuceneCocoonHelper.getDirectory(this.index, false);
                        this.lcs.setDirectory(directory);
                        hits = this.lcs.search(this.queryString, "body");
                    }
                    catch (IOException ioe) {
                        throw new ProcessingException("IOException in search", ioe);
                    }
                    catch (ComponentException ce) {
                        throw new ProcessingException("ComponentException in search", ce);
                    }
                    Object var5_7 = null;
                    if (this.lcs == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (this.lcs != null) {
                        this.manager.release((Component)this.lcs);
                        this.lcs = null;
                    }
                    throw throwable;
                }
                this.manager.release((Component)this.lcs);
                this.lcs = null;
            }
            LuceneCocoonPager pager = new LuceneCocoonPager(hits);
            int start_index = 0;
            if (this.startIndex != null) {
                start_index = this.startIndex;
                if (start_index <= 0) {
                    start_index = 0;
                }
                pager.setStartIndex(start_index);
            }
            int page_length = 10;
            if (this.pageLength != null) {
                page_length = this.pageLength;
                if (page_length <= 0) {
                    page_length = hits.length();
                }
                pager.setCountOfHitsPerPage(page_length);
            }
            return pager;
        }
        return null;
    }

    public void recycle() {
        super.recycle();
        this.queryString = null;
        this.startIndex = null;
        this.pageLength = null;
        this.index = null;
    }

    public void dispose() {
        super.dispose();
    }
}

