/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.EnvironmentStack;
import org.apache.cocoon.components.pipeline.CacheableEventPipeline;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.source.EnvironmentChanger;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.AbstractXMLConsumer;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.log.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class SitemapSource
extends AbstractXMLConsumer
implements ModifiableSource {
    private long lastModificationDate;
    private String systemId;
    private String uri;
    private ComponentManager manager;
    private Processor processor;
    private Processor pipelineProcessor;
    private EnvironmentWrapper environment;
    private String prefix;
    private EventPipeline eventPipeline;
    private StreamPipeline pipeline;
    private Source redirectSource;
    private ProcessingException exception;
    private boolean needsRefresh;
    private Object processKey;

    public SitemapSource(ComponentManager manager, String uri, Logger logger) throws IOException, ProcessingException {
        Environment env = CocoonComponentManager.getCurrentEnvironment();
        if (env == null) {
            throw new MalformedURLException("The cocoon protocol can not be used outside an environment.");
        }
        this.manager = manager;
        this.setLogger(logger);
        boolean rawMode = false;
        int position = uri.indexOf(58) + 1;
        if (position != 0 && uri.startsWith("raw:", position)) {
            position += 4;
            rawMode = true;
        }
        if (uri.startsWith("//", position)) {
            position += 2;
            try {
                this.processor = (Processor)this.manager.lookup("org.apache.cocoon.Processor");
            }
            catch (ComponentException e) {
                throw new ProcessingException("Cannot get Processor instance", e);
            }
            this.prefix = "";
        } else if (uri.startsWith("/", position)) {
            ++position;
            this.prefix = null;
            this.processor = CocoonComponentManager.getCurrentProcessor();
        } else {
            throw new ProcessingException("Malformed cocoon URI.");
        }
        String queryString = null;
        int queryStringPos = uri.indexOf(63, position);
        if (queryStringPos != -1) {
            queryString = uri.substring(queryStringPos + 1);
            uri = uri.substring(position, queryStringPos);
        } else if (position > 0) {
            uri = uri.substring(position);
        }
        String requestURI = this.prefix == null ? env.getURIPrefix() + uri : uri;
        this.systemId = queryString == null ? "cocoon://" + requestURI : "cocoon://" + requestURI + "?" + queryString;
        this.environment = new EnvironmentWrapper(env, requestURI, queryString, logger, rawMode);
        this.uri = uri;
        this.refresh();
    }

    public long getLastModified() {
        if (this.needsRefresh) {
            this.refresh();
        }
        return this.lastModificationDate;
    }

    public long getContentLength() {
        return -1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws ProcessingException, IOException {
        ByteArrayInputStream byteArrayInputStream;
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.redirectSource != null) {
            return this.redirectSource.getInputStream();
        }
        try {
            try {
                CocoonComponentManager.enterEnvironment(this.environment, this.environment.getObjectModel(), this.pipelineProcessor);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.environment.setOutputStream(os);
                this.pipeline.process(this.environment);
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
                Object var4_5 = null;
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException("Exception during processing of " + this.systemId, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            CocoonComponentManager.leaveEnvironment();
            this.environment.setOutputStream(null);
            this.reset();
            throw throwable;
        }
        CocoonComponentManager.leaveEnvironment();
        this.environment.setOutputStream(null);
        this.reset();
        return byteArrayInputStream;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void refresh() {
        this.reset();
        try {
            this.processKey = CocoonComponentManager.startProcessing(this.environment);
            this.eventPipeline = (EventPipeline)this.manager.lookup("org.apache.cocoon.components.pipeline.EventPipeline");
            this.pipeline = (StreamPipeline)this.manager.lookup("org.apache.cocoon.components.pipeline.StreamPipeline");
            this.pipeline.setEventPipeline(this.eventPipeline);
            this.eventPipeline.setConsumer(this);
            this.environment.setURI(this.prefix, this.uri);
            this.processor.process(this.environment, this.pipeline, this.eventPipeline);
            this.pipelineProcessor = this.environment.changeToLastContext();
            String redirectURL = this.environment.getRedirectURL();
            try {
                CocoonComponentManager.enterEnvironment(this.environment, this.environment.getObjectModel(), this.pipelineProcessor);
                if (redirectURL == null) {
                    if (this.eventPipeline.getGenerator() != null && this.eventPipeline instanceof CacheableEventPipeline) {
                        CacheableEventPipeline cep = (CacheableEventPipeline)((Object)this.eventPipeline);
                        PipelineCacheKey pck = cep.generateKey(this.environment);
                        Map validity = null;
                        if (pck != null && (validity = cep.generateValidity(this.environment)) != null) {
                            String hashKey = pck.toString() + validity.toString();
                            this.lastModificationDate = HashUtil.hash(hashKey);
                        }
                    }
                } else {
                    if (redirectURL.indexOf(":") == -1) {
                        redirectURL = "cocoon:/" + redirectURL;
                    }
                    this.redirectSource = this.environment.resolve(redirectURL);
                    this.lastModificationDate = this.redirectSource.getLastModified();
                }
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                CocoonComponentManager.leaveEnvironment();
                throw throwable;
            }
            CocoonComponentManager.leaveEnvironment();
            {
            }
        }
        catch (ProcessingException e) {
            this.reset();
            this.exception = e;
        }
        catch (Exception e) {
            this.reset();
            this.exception = new ProcessingException("Could not get sitemap source " + this.systemId, e);
        }
        this.needsRefresh = false;
    }

    public InputSource getInputSource() throws ProcessingException, IOException {
        InputSource newObject = new InputSource(this.getInputStream());
        newObject.setSystemId(this.systemId);
        return newObject;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException, ProcessingException {
        if (this.needsRefresh) {
            this.refresh();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            try {
                if (this.redirectSource != null) {
                    this.redirectSource.toSAX(contentHandler);
                } else {
                    XMLConsumer consumer = contentHandler instanceof XMLConsumer ? (XMLConsumer)contentHandler : (contentHandler instanceof LexicalHandler ? new ContentHandlerWrapper(contentHandler, (LexicalHandler)((Object)contentHandler)) : new ContentHandlerWrapper(contentHandler));
                    EnvironmentStack envStack = CocoonComponentManager.getCurrentEnvironmentStack();
                    int currentOffset = envStack.getOffset();
                    try {
                        CocoonComponentManager.enterEnvironment(this.environment, this.environment.getObjectModel(), this.pipelineProcessor);
                        this.eventPipeline.setConsumer(new EnvironmentChanger(consumer, envStack));
                        this.eventPipeline.process(this.environment);
                        Object var6_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        CocoonComponentManager.leaveEnvironment();
                        envStack.resetOffset(currentOffset);
                        throw throwable;
                    }
                    CocoonComponentManager.leaveEnvironment();
                    envStack.resetOffset(currentOffset);
                    {
                    }
                }
                Object var8_11 = null;
                this.reset();
            }
            catch (ComponentException cme) {
                throw new ProcessingException("Could not lookup pipeline components", cme);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException("Exception during processing of " + this.systemId, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.reset();
            throw throwable;
        }
    }

    private void reset() {
        if (this.eventPipeline != null) {
            this.manager.release((Component)this.eventPipeline);
        }
        if (this.pipeline != null) {
            this.manager.release((Component)this.pipeline);
        }
        if (this.processKey != null) {
            CocoonComponentManager.endProcessing(this.environment, this.processKey);
            this.processKey = null;
        }
        this.eventPipeline = null;
        this.pipeline = null;
        this.lastModificationDate = 0L;
        this.environment.reset();
        if (this.redirectSource != null) {
            this.redirectSource.recycle();
        }
        this.redirectSource = null;
        this.exception = null;
        this.needsRefresh = true;
    }

    public void recycle() {
        this.reset();
    }
}

