/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming;

import java.io.File;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.language.LanguageException;
import org.apache.cocoon.components.language.generator.CompiledComponent;
import org.apache.cocoon.components.language.programming.CodeFormatter;
import org.apache.cocoon.components.language.programming.Program;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.util.ClassUtils;

public abstract class AbstractProgrammingLanguage
extends AbstractLoggable
implements ProgrammingLanguage,
Parameterizable {
    protected Class codeFormatter;
    protected String languageName;

    public void parameterize(Parameters params) throws ParameterException {
        String className = params.getParameter("code-formatter", null);
        try {
            if (className != null) {
                this.codeFormatter = ClassUtils.loadClass(className);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error with \"code-formatter\" parameter", (Throwable)e);
            throw new ParameterException("Unable to load code formatter: " + className, (Throwable)e);
        }
    }

    public CodeFormatter getCodeFormatter() {
        if (this.codeFormatter != null) {
            try {
                CodeFormatter formatter = (CodeFormatter)this.codeFormatter.newInstance();
                if (formatter instanceof Loggable) {
                    ((Loggable)formatter).setLogger(this.getLogger());
                }
                return formatter;
            }
            catch (Exception e) {
                this.getLogger().error("Error instantiating CodeFormatter", (Throwable)e);
            }
        }
        return null;
    }

    protected abstract void doUnload(Object var1, String var2, File var3) throws LanguageException;

    public final void unload(Object program, String filename, File baseDirectory) throws LanguageException {
        File file = new File(baseDirectory, filename + "." + this.getSourceExtension());
        file.delete();
        this.doUnload(program, filename, baseDirectory);
    }

    public final void setLanguageName(String name) {
        this.languageName = name;
    }

    public final String getLanguageName() {
        return this.languageName;
    }

    public CompiledComponent instantiate(Program program) throws LanguageException {
        try {
            return program.newInstance();
        }
        catch (Exception e) {
            this.getLogger().warn("Could not instantiate program instance", (Throwable)e);
            throw new LanguageException("Could not instantiate program instance due to a " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public abstract String quoteString(String var1);

    public abstract Program load(String var1, File var2, String var3) throws LanguageException;

    public abstract Program preload(String var1, File var2, String var3) throws LanguageException;

    public abstract String getSourceExtension();
}

