/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Cell;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.CellType;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Sheet;
import org.apache.poi.hssf.usermodel.HSSFRow;

class Row {
    private HSSFRow _row;
    private Sheet _sheet;

    Row(HSSFRow row, Sheet sheet) {
        this._row = row;
        this._sheet = sheet;
    }

    void setHeight(double points) throws IOException {
        if (!this.isValid(points)) {
            throw new IOException("points " + points + " is out of range");
        }
        this._row.setHeight((short)(points * 20.0));
    }

    short getHeight() {
        return this._row.getHeight();
    }

    Cell createCell(int column, int cellType) throws IOException {
        if (column < 0 || column > Short.MAX_VALUE) {
            throw new IOException("Illegal column value: " + column);
        }
        Cell retval = new Cell(this._row.createCell((short)column, CellType.convertCellType(cellType)), cellType);
        retval.setStyle(this._sheet.getCellStyleForRegion(this._row.getRowNum(), (short)column));
        return retval;
    }

    private boolean isValid(double points) {
        return points >= 0.0 && points <= 1638.35;
    }
}

