/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.monitor.Monitor;
import org.apache.avalon.excalibur.monitor.Resource;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;

public final class ActiveMonitor
extends AbstractLogEnabled
implements Monitor,
Startable,
ThreadSafe,
Configurable,
Runnable {
    private static final Class[] m_constructorParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActiveMonitor.class$("java.lang.String")) : class$java$lang$String};
    private static final Resource[] m_arrayType = new Resource[0];
    private final Thread m_monitorThread = new Thread(this);
    private long m_frequency;
    private int m_priority;
    private Map m_resources = new HashMap();
    private boolean m_keepRunning = true;
    static /* synthetic */ Class class$java$lang$String;

    public final void configure(Configuration conf) throws ConfigurationException {
        this.m_frequency = conf.getChild("thread").getAttributeAsLong("frequency", 60000L);
        this.m_priority = conf.getChild("thread").getAttributeAsInteger("priority", 1);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Configuration[] initialResources = conf.getChild("init-resources").getChildren("resource");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Active monitor will sample all resources every " + this.m_frequency + " milliseconds with a thread priority of " + this.m_priority + "(Minimum = " + 1 + ", Normal = " + 5 + ", Maximum = " + 10 + ").");
        }
        int i = 0;
        while (i < initialResources.length) {
            block5: {
                String key = initialResources[i].getAttribute("key", "*** KEY NOT SPECIFIED ***");
                String className = initialResources[i].getAttribute("class", "*** CLASSNAME NOT SPECIFIED ***");
                try {
                    Class<?> clazz = loader.loadClass(className);
                    Constructor<?> initializer = clazz.getConstructor(m_constructorParams);
                    this.addResource((Resource)initializer.newInstance(key));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Initial Resource: \"" + key + "\" Initialized.");
                    }
                }
                catch (Exception e) {
                    if (!this.getLogger().isWarnEnabled()) break block5;
                    this.getLogger().warn("Initial Resource: \"" + key + "\" Failed (" + className + ").", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public final void start() throws Exception {
        this.m_monitorThread.setDaemon(true);
        this.m_monitorThread.setPriority(1);
        this.m_monitorThread.start();
    }

    public final void stop() throws Exception {
        this.m_keepRunning = false;
        this.m_monitorThread.join();
    }

    public final void addResource(Resource resource) {
        Map map = this.m_resources;
        synchronized (map) {
            if (this.m_resources.containsKey(resource.getResourceKey())) {
                Resource original = (Resource)this.m_resources.get(resource.getResourceKey());
                original.addPropertyChangeListenersFrom(resource);
            } else {
                this.m_resources.put(resource.getResourceKey(), resource);
            }
        }
    }

    public final Resource getResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            Resource resource = (Resource)this.m_resources.get(key);
            return resource;
        }
    }

    public final void removeResource(String key) {
        Map map = this.m_resources;
        synchronized (map) {
            Resource resource = (Resource)this.m_resources.remove(key);
            resource.removeAllPropertyChangeListeners();
        }
    }

    public final void removeResource(Resource resource) {
        this.removeResource(resource.getResourceKey());
    }

    public final void run() {
        while (this.m_keepRunning) {
            Resource[] resources;
            long currentTestTime = System.currentTimeMillis();
            long sleepTillTime = currentTestTime + this.m_frequency;
            while ((currentTestTime = System.currentTimeMillis()) < sleepTillTime) {
                try {
                    Thread.sleep(sleepTillTime - currentTestTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Map map = this.m_resources;
            synchronized (map) {
                resources = this.m_resources.values().toArray(m_arrayType);
            }
            int i = 0;
            while (i < resources.length) {
                resources[i].testModifiedAfter(currentTestTime);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

