/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.avalon.framework.logger.Logger;

class TraxErrorHandler
implements ErrorListener {
    private Logger m_logger;

    TraxErrorHandler(Logger logger) {
        if (null == logger) {
            throw new NullPointerException("logger");
        }
        this.m_logger = logger;
    }

    public void warning(TransformerException te) throws TransformerException {
        String message = this.getMessage(te);
        if (null != this.m_logger) {
            this.m_logger.warn(message, (Throwable)te);
        } else {
            System.out.println("WARNING: " + message);
        }
    }

    public void error(TransformerException te) throws TransformerException {
        String message = this.getMessage(te);
        if (null != this.m_logger) {
            this.m_logger.error(message, (Throwable)te);
        } else {
            System.out.println("ERROR: " + message);
        }
    }

    public void fatalError(TransformerException te) throws TransformerException {
        String message = this.getMessage(te);
        if (null != this.m_logger) {
            this.m_logger.fatalError(message, (Throwable)te);
        } else {
            System.out.println("FATAL-ERROR: " + message);
        }
        throw te;
    }

    private String getMessage(TransformerException te) {
        SourceLocator locator = te.getLocator();
        if (null != locator) {
            String id = locator.getPublicId() != locator.getPublicId() ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : "SystemId Unknown");
            return "Error in TraxTransformer: " + id + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; ";
        }
        return "Error in TraxTransformer: " + te;
    }
}

