/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.CSEHolder;
import org.mozilla.javascript.optimizer.DataFlowBitSet;
import org.mozilla.javascript.optimizer.FatBlock;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

public class Block {
    private IRFactory itsIRFactory;
    private Block[] itsSuccessors;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private int itsEndNodeIndex;
    private Node[] itsStatementNodes;
    private int itsBlockID;
    private DataFlowBitSet itsLiveOnEntrySet;
    private DataFlowBitSet itsLiveOnExitSet;
    private DataFlowBitSet itsUseBeforeDefSet;
    private DataFlowBitSet itsNotDefSet;

    public Block(int n, int n2, Node[] nodeArray) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
        this.itsStatementNodes = nodeArray;
    }

    public void setBlockID(int n) {
        this.itsBlockID = n;
    }

    public int getBlockID() {
        return this.itsBlockID;
    }

    public Node getStartNode() {
        return this.itsStatementNodes[this.itsStartNodeIndex];
    }

    public Node getEndNode() {
        return this.itsStatementNodes[this.itsEndNodeIndex];
    }

    public Block[] getPredecessorList() {
        return this.itsPredecessors;
    }

    public Block[] getSuccessorList() {
        return this.itsSuccessors;
    }

    public static Block[] buildBlocks(Node[] nodeArray) {
        Object object;
        FatBlock fatBlock;
        Hashtable<Node, FatBlock> hashtable = new Hashtable<Node, FatBlock>();
        Vector<FatBlock> vector = new Vector<FatBlock>();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeArray.length) {
            switch (nodeArray[n2].getType()) {
                case 137: {
                    if (n2 == n) break;
                    fatBlock = new FatBlock(n, n2 - 1, nodeArray);
                    if (nodeArray[n].getType() == 137) {
                        hashtable.put(nodeArray[n], fatBlock);
                    }
                    vector.addElement(fatBlock);
                    n = n2;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    fatBlock = new FatBlock(n, n2, nodeArray);
                    if (nodeArray[n].getType() == 137) {
                        hashtable.put(nodeArray[n], fatBlock);
                    }
                    vector.addElement(fatBlock);
                    n = n2 + 1;
                }
            }
            ++n2;
        }
        if (n != nodeArray.length) {
            fatBlock = new FatBlock(n, nodeArray.length - 1, nodeArray);
            if (nodeArray[n].getType() == 137) {
                hashtable.put(nodeArray[n], fatBlock);
            }
            vector.addElement(fatBlock);
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            Object object2;
            object = (FatBlock)vector.elementAt(n3);
            Node node = ((FatBlock)object).getEndNode();
            int n4 = node.getType();
            if (n4 != 6 && n3 < vector.size() - 1) {
                object2 = (FatBlock)vector.elementAt(n3 + 1);
                ((FatBlock)object).addSuccessor((FatBlock)object2);
                ((FatBlock)object2).addPredecessor((FatBlock)object);
            }
            if (n4 == 8 || n4 == 7 || n4 == 6) {
                object2 = (Node)node.getProp(1);
                FatBlock fatBlock2 = (FatBlock)hashtable.get(object2);
                ((Node)object2).putProp(23, fatBlock2.getSlimmerSelf());
                ((FatBlock)object).addSuccessor(fatBlock2);
                fatBlock2.addPredecessor((FatBlock)object);
            }
            ++n3;
        }
        object = new Block[vector.size()];
        int n5 = 0;
        while (n5 < vector.size()) {
            FatBlock fatBlock3 = (FatBlock)vector.elementAt(n5);
            object[n5] = fatBlock3.diet();
            ((Block)object[n5]).setBlockID(n5);
            ++n5;
        }
        return object;
    }

    public static String toString(Block[] blockArray, Node[] nodeArray) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(blockArray.length + " Blocks");
        int n = 0;
        while (n < blockArray.length) {
            int n2;
            Block block = blockArray[n];
            printWriter.println("#" + block.itsBlockID);
            printWriter.println("from " + block.itsStartNodeIndex + " " + nodeArray[block.itsStartNodeIndex].toString());
            printWriter.println("thru " + block.itsEndNodeIndex + " " + nodeArray[block.itsEndNodeIndex].toString());
            printWriter.print("Predecessors ");
            if (block.itsPredecessors != null) {
                n2 = 0;
                while (n2 < block.itsPredecessors.length) {
                    printWriter.print(block.itsPredecessors[n2].getBlockID() + " ");
                    ++n2;
                }
                printWriter.println();
            } else {
                printWriter.println("none");
            }
            printWriter.print("Successors ");
            if (block.itsSuccessors != null) {
                n2 = 0;
                while (n2 < block.itsSuccessors.length) {
                    printWriter.print(block.itsSuccessors[n2].getBlockID() + " ");
                    ++n2;
                }
                printWriter.println();
            } else {
                printWriter.println("none");
            }
            ++n;
        }
        return stringWriter.toString();
    }

    void lookForVariablesAndCalls(Node node, boolean[] blArray, VariableTable variableTable) {
        switch (node.getType()) {
            case 73: {
                Node node2 = node.getFirstChild();
                Node node3 = node2.getNextSibling();
                this.lookForVariablesAndCalls(node3, blArray, variableTable);
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                blArray[n] = true;
                break;
            }
            case 43: {
                Node node4 = node.getFirstChild();
                while (node4 != null) {
                    this.lookForVariablesAndCalls(node4, blArray, variableTable);
                    node4 = node4.getNextSibling();
                }
                int n = 0;
                while (n < blArray.length) {
                    if (blArray[n]) {
                        ((OptLocalVariable)variableTable.getVariable(n)).markLiveAcrossCall();
                    }
                    ++n;
                }
                break;
            }
            case 72: {
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (node.getProp(25) == null || this.itsLiveOnExitSet.test(n)) break;
                blArray[n] = false;
                break;
            }
            default: {
                Node node5 = node.getFirstChild();
                while (node5 != null) {
                    this.lookForVariablesAndCalls(node5, blArray, variableTable);
                    node5 = node5.getNextSibling();
                }
                break block0;
            }
        }
    }

    void markAnyTypeVariables(VariableTable variableTable) {
        int n = 0;
        while (n < variableTable.size()) {
            if (this.itsLiveOnEntrySet.test(n)) {
                ((OptLocalVariable)variableTable.getVariable(n)).assignType(3);
            }
            ++n;
        }
    }

    void markVolatileVariables(VariableTable variableTable) {
        boolean[] blArray = new boolean[variableTable.size()];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = this.itsLiveOnEntrySet.test(n);
            ++n;
        }
        int n2 = this.itsStartNodeIndex;
        while (n2 <= this.itsEndNodeIndex) {
            Node node = this.itsStatementNodes[n2];
            this.lookForVariablesAndCalls(node, blArray, variableTable);
            ++n2;
        }
    }

    void lookForVariableAccess(Node node, Node[] nodeArray) {
        switch (node.getType()) {
            case 106: 
            case 107: {
                Object object;
                Node node2 = node.getFirstChild();
                if (node2.getType() != 72 || (object = node2.getProp(24)) == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                this.itsNotDefSet.set(n);
                break;
            }
            case 73: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNextSibling();
                this.lookForVariableAccess(node4, nodeArray);
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                this.itsNotDefSet.set(n);
                if (nodeArray[n] == null) break;
                nodeArray[n].putProp(25, object);
                break;
            }
            case 72: {
                Object object = node.getProp(24);
                if (object == null) break;
                int n = ((OptLocalVariable)object).getIndex();
                if (!this.itsNotDefSet.test(n)) {
                    this.itsUseBeforeDefSet.set(n);
                }
                nodeArray[n] = node;
                break;
            }
            default: {
                Node node5 = node.getFirstChild();
                while (node5 != null) {
                    this.lookForVariableAccess(node5, nodeArray);
                    node5 = node5.getNextSibling();
                }
                break block0;
            }
        }
    }

    public void initLiveOnEntrySets(VariableTable variableTable) {
        int n = variableTable.size();
        Node[] nodeArray = new Node[n];
        this.itsUseBeforeDefSet = new DataFlowBitSet(n);
        this.itsNotDefSet = new DataFlowBitSet(n);
        this.itsLiveOnEntrySet = new DataFlowBitSet(n);
        this.itsLiveOnExitSet = new DataFlowBitSet(n);
        int n2 = this.itsStartNodeIndex;
        while (n2 <= this.itsEndNodeIndex) {
            Node node = this.itsStatementNodes[n2];
            this.lookForVariableAccess(node, nodeArray);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (nodeArray[n3] != null) {
                nodeArray[n3].putProp(25, this);
            }
            ++n3;
        }
        this.itsNotDefSet.not();
    }

    boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            int n = 0;
            while (n < this.itsSuccessors.length) {
                this.itsLiveOnExitSet.or(this.itsSuccessors[n].itsLiveOnEntrySet);
                ++n;
            }
        }
        return this.itsLiveOnEntrySet.df2(this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    int findExpressionType(Node node) {
        switch (node.getType()) {
            case 45: {
                return 1;
            }
            case 30: 
            case 43: {
                return 0;
            }
            case 41: {
                return 3;
            }
            case 72: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (optLocalVariable != null) {
                    return optLocalVariable.getTypeUnion();
                }
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 106: 
            case 107: {
                return 1;
            }
            case 23: {
                Node node2 = node.getFirstChild();
                int n = this.findExpressionType(node2);
                int n2 = this.findExpressionType(node2.getNextSibling());
                return n | n2;
            }
        }
        Node node3 = node.getFirstChild();
        if (node3 == null) {
            return 3;
        }
        int n = 0;
        while (node3 != null) {
            n |= this.findExpressionType(node3);
            node3 = node3.getNextSibling();
        }
        return n;
    }

    boolean findDefPoints(Node node) {
        boolean bl = false;
        switch (node.getType()) {
            default: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    bl |= this.findDefPoints(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 106: 
            case 107: {
                Node node3 = node.getFirstChild();
                OptLocalVariable optLocalVariable = (OptLocalVariable)node3.getProp(24);
                if (optLocalVariable == null) break;
                bl |= optLocalVariable.assignType(1);
                break;
            }
            case 40: {
                Node node4 = node.getFirstChild();
                Node node5 = node4.getNextSibling();
                Node node6 = node5.getNextSibling();
                if (node4 != null) {
                    OptLocalVariable optLocalVariable;
                    if (node4.getType() == 72 && (optLocalVariable = (OptLocalVariable)node4.getProp(24)) != null) {
                        optLocalVariable.assignType(3);
                    }
                    bl |= this.findDefPoints(node4);
                }
                if (node5 != null) {
                    bl |= this.findDefPoints(node5);
                }
                if (node6 == null) break;
                bl |= this.findDefPoints(node6);
                break;
            }
            case 73: {
                Node node7 = node.getFirstChild();
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                if (optLocalVariable == null) break;
                Node node8 = node7.getNextSibling();
                int n = this.findExpressionType(node8);
                bl |= optLocalVariable.assignType(n);
            }
        }
        return bl;
    }

    void localCSE(Node node, Node node2, Hashtable hashtable, OptFunctionNode optFunctionNode) {
        switch (node2.getType()) {
            default: {
                Node node3 = node2.getFirstChild();
                while (node3 != null) {
                    this.localCSE(node2, node3, hashtable, optFunctionNode);
                    node3 = node3.getNextSibling();
                }
                break;
            }
            case 106: 
            case 107: {
                Node node4 = node2.getFirstChild();
                if (node4.getType() == 39) {
                    Node node5 = node4.getFirstChild().getNextSibling();
                    if (node5.getType() == 46) {
                        hashtable.remove(node5.getString());
                        break;
                    }
                    hashtable.clear();
                    break;
                }
                if (node4.getType() == 72) break;
                hashtable.clear();
                break;
            }
            case 40: {
                Node node6 = node2.getFirstChild();
                Node node7 = node6.getNextSibling();
                Node node8 = node7.getNextSibling();
                if (node6 != null) {
                    this.localCSE(node2, node6, hashtable, optFunctionNode);
                }
                if (node7 != null) {
                    this.localCSE(node2, node7, hashtable, optFunctionNode);
                }
                if (node8 != null) {
                    this.localCSE(node2, node8, hashtable, optFunctionNode);
                }
                if (node7.getType() == 46) {
                    hashtable.remove(node7.getString());
                    break;
                }
                hashtable.clear();
                break;
            }
            case 39: {
                Node node9;
                Node node10;
                Object object;
                Node node11;
                Node node12 = node2.getFirstChild();
                if (node12 != null) {
                    this.localCSE(node2, node12, hashtable, optFunctionNode);
                }
                if (node12.getType() != 109 || node12.getInt() != 50 || (node11 = node12.getNextSibling()).getType() != 46) break;
                String string = node11.getString();
                Object v = hashtable.get(string);
                if (v == null) {
                    hashtable.put(string, new CSEHolder(node, node2));
                    break;
                }
                if (node == null) break;
                if (v instanceof CSEHolder) {
                    object = (CSEHolder)v;
                    node10 = ((CSEHolder)object).getPropChild.getNextSibling();
                    ((CSEHolder)object).getPropParent.removeChild(((CSEHolder)object).getPropChild);
                    node9 = this.itsIRFactory.createNewLocal(((CSEHolder)object).getPropChild);
                    optFunctionNode.incrementLocalCount();
                    if (node10 == null) {
                        ((CSEHolder)object).getPropParent.addChildToBack(node9);
                    } else {
                        ((CSEHolder)object).getPropParent.addChildBefore(node9, node10);
                    }
                    hashtable.put(string, node9);
                } else {
                    node9 = (Node)v;
                }
                object = node2.getNextSibling();
                node.removeChild(node2);
                node10 = this.itsIRFactory.createUseLocal(node9);
                if (object == null) {
                    node.addChildToBack(node10);
                    break;
                }
                node.addChildBefore(node10, (Node)object);
                break;
            }
            case 42: {
                Node node13 = node2.getFirstChild();
                Node node14 = node13.getNextSibling();
                Node node15 = node14.getNextSibling();
                if (node13 != null) {
                    this.localCSE(node2, node13, hashtable, optFunctionNode);
                }
                if (node14 != null) {
                    this.localCSE(node2, node14, hashtable, optFunctionNode);
                }
                if (node15 != null) {
                    this.localCSE(node2, node15, hashtable, optFunctionNode);
                }
                hashtable.clear();
                break;
            }
            case 43: {
                Node node16 = node2.getFirstChild();
                while (node16 != null) {
                    this.localCSE(node2, node16, hashtable, optFunctionNode);
                    node16 = node16.getNextSibling();
                }
                hashtable.clear();
            }
        }
    }

    Hashtable localCSE(Hashtable hashtable, OptFunctionNode optFunctionNode) {
        this.itsIRFactory = new IRFactory(null, null);
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        int n = this.itsStartNodeIndex;
        while (n <= this.itsEndNodeIndex) {
            Node node = this.itsStatementNodes[n];
            if (node != null) {
                this.localCSE(null, node, hashtable, optFunctionNode);
            }
            ++n;
        }
        return hashtable;
    }

    void findDefs() {
        int n = this.itsStartNodeIndex;
        while (n <= this.itsEndNodeIndex) {
            Node node = this.itsStatementNodes[n];
            if (node != null) {
                this.findDefPoints(node);
            }
            ++n;
        }
    }

    public boolean doTypeFlow() {
        boolean bl = false;
        int n = this.itsStartNodeIndex;
        while (n <= this.itsEndNodeIndex) {
            Node node = this.itsStatementNodes[n];
            if (node != null) {
                bl |= this.findDefPoints(node);
            }
            ++n;
        }
        return bl;
    }

    public boolean isLiveOnEntry(int n) {
        return this.itsLiveOnEntrySet != null && this.itsLiveOnEntrySet.test(n);
    }

    public void printLiveOnEntrySet(PrintWriter printWriter, VariableTable variableTable) {
        int n = 0;
        while (n < variableTable.size()) {
            if (this.itsUseBeforeDefSet.test(n)) {
                printWriter.println(variableTable.getVariable(n).getName() + " is used before def'd");
            }
            if (this.itsNotDefSet.test(n)) {
                printWriter.println(variableTable.getVariable(n).getName() + " is not def'd");
            }
            if (this.itsLiveOnEntrySet.test(n)) {
                printWriter.println(variableTable.getVariable(n).getName() + " is live on entry");
            }
            if (this.itsLiveOnExitSet.test(n)) {
                printWriter.println(variableTable.getVariable(n).getName() + " is live on exit");
            }
            ++n;
        }
    }

    public void setSuccessorList(Block[] blockArray) {
        this.itsSuccessors = blockArray;
    }

    public void setPredecessorList(Block[] blockArray) {
        this.itsPredecessors = blockArray;
    }
}

