/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class IdFunction
extends BaseFunction {
    public static final int FUNCTION_ONLY = 0;
    public static final int CONSTRUCTOR_ONLY = 1;
    public static final int FUNCTION_AND_CONSTRUCTOR = 2;
    protected IdFunctionMaster master;
    protected int methodId;
    protected int functionType = 0;

    public IdFunction(IdFunctionMaster idFunctionMaster, String string, int n) {
        this.functionName = string;
        this.master = idFunctionMaster;
        this.methodId = n;
    }

    public final int functionType() {
        return this.functionType;
    }

    public void setFunctionType(int n) {
        this.functionType = n;
    }

    public Scriptable getPrototype() {
        Scriptable scriptable = super.getPrototype();
        if (scriptable == null) {
            scriptable = ScriptableObject.getFunctionPrototype(this.getParentScope());
            this.setPrototype(scriptable);
        }
        return scriptable;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.functionType != 1) {
            return this.master.execMethod(this.methodId, this, context, scriptable, scriptable2, objectArray);
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        if (this.functionType != 0) {
            Scriptable scriptable2 = (Scriptable)this.master.execMethod(this.methodId, this, context, scriptable, null, objectArray);
            this.postConstruction(scriptable2);
            return scriptable2;
        }
        return Undefined.instance;
    }

    public String decompile(Context context, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() { ");
        }
        stringBuffer.append("[native code for ");
        if (this.master instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)((Object)this.master);
            stringBuffer.append(scriptable.getClassName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append(", arity=");
        stringBuffer.append(this.getArity());
        stringBuffer.append(bl ? "]\n" : "] }\n");
        return stringBuffer.toString();
    }

    public int getArity() {
        int n = this.master.methodArity(this.methodId);
        if (n < 0) {
            throw IdFunction.onBadMethodId(this.master, this.methodId);
        }
        return n;
    }

    public int getLength() {
        return this.getArity();
    }

    public void initAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        this.setFunctionType(2);
        this.setParentScope(scriptable);
        this.setImmunePrototypeProperty(scriptable2);
    }

    static RuntimeException onBadMethodId(IdFunctionMaster idFunctionMaster, int n) {
        return new RuntimeException("BAD FUNCTION ID=" + n + " MASTER=" + idFunctionMaster);
    }

    private void postConstruction(Scriptable scriptable) {
        Scriptable scriptable2;
        if (scriptable.getPrototype() == null) {
            scriptable.setPrototype(this.getClassPrototype());
        }
        if (scriptable.getParentScope() == null && scriptable != (scriptable2 = this.getParentScope())) {
            scriptable.setParentScope(scriptable2);
        }
    }
}

