/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.JDBCDatabase;
import fr.gouv.culture.sdx.utils.save.SaveParameters;

public class MSSQLDatabase
extends JDBCDatabase {
    protected final String FIELD_ID = "id";
    protected final String FIELD_PROPERTY_NAME = "propertyName";
    protected final String FIELD_PROPERTY_VALUE = "propertyValue";
    protected final String FIELD_KEY = "sdx_key";

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "sdx_key" + " INT IDENTITY(1,1), " + "PRIMARY KEY (" + "sdx_key" + "))";
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("Database_Type", "MSSQLDatabase");
        this._xmlizable_objects.put("JDBC_Table_Name", this.tableName);
        this._xmlizable_objects.put("Data_Source_Identifier", this.dsi);
        return true;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "MSSQL");
        }
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM ( SELECT TOP " + String.valueOf(number) + " " + "id" + ", " + "propertyName" + ", " + "propertyValue" + ", " + "sdx_key";
        query = query + "FROM (SELECT TOP " + String.valueOf(offset + number) + " " + "id" + ", " + "propertyName" + ", " + "propertyValue" + ", " + "sdx_key";
        query = query + "FROM " + this.getTableName() + " ORDER BY " + "sdx_key" + " asc) AS tbl1 ORDER BY " + "sdx_key" + " desc) AS tbl2 ORDER BY " + "sdx_key" + " asc;";
        return query;
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

