/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.configuration;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ConfigurationUtils {
    public static IDGenerator configureIDGenerator(Logger logger, Configuration configuration) throws ConfigurationException {
        IDGenerator idGen = new DefaultIDGenerator();
        Configuration idGenConf = configuration.getChild("idGenerator", false);
        if (idGenConf != null) {
            try {
                String idGenClassName = idGenConf.getAttribute("class", "fr.gouv.culture.sdx.documentbase.DefaultIDGenerator");
                Object l_obj = Utilities.getObjectForClassName(logger, idGenClassName, "fr.gouv.culture.sdx.documentbase.", idGenClassName, "IDGenerator");
                Class<?> l_objClass = l_obj.getClass();
                if (!(l_obj instanceof IDGenerator)) {
                    String[] args = new String[3];
                    args[0] = "IDGenerator";
                    if (l_objClass != null) {
                        args[1] = l_objClass.getName();
                    }
                    args[2] = idGenClassName;
                    throw new SDXException(logger, 10, args, null);
                }
                idGen = (IDGenerator)l_obj;
                idGen.configure(idGenConf);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        return idGen;
    }

    public static FieldList configureFieldList(Logger logger, ServiceManager manager, Context context, String id, Configuration configuration) throws ConfigurationException {
        FieldList fieldList = null;
        try {
            Configuration fieldListConf = null;
            fieldListConf = configuration.getName().equals("fieldList") ? configuration : configuration.getChild("fieldList", false);
            if (fieldListConf == null) {
                String[] args = new String[]{configuration.getLocation()};
                SDXException sdxE = new SDXException(logger, 14, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            fieldList = new FieldList();
            Utilities.setUpSdxObject(fieldList, logger, context, manager);
            if (Utilities.checkString(id)) {
                fieldList.setId(id);
            }
            fieldList.configure(fieldListConf);
            return fieldList;
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public static FieldList configureLuceneFieldList(Logger logger, Context context, FieldList fieldList) throws ConfigurationException {
        if (context != null) {
            try {
                Configuration sdxConf = (Configuration)context.get((Object)"sdx.framework.confFile");
                if (sdxConf == null) {
                    String[] args = new String[]{"sdx.xconf", Utilities.getStringFromContext("sdx.framework.confPath", context)};
                    SDXException sdxE = new SDXException(logger, 1, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
                }
                Configuration iFConf = sdxConf.getChild("luceneSDXInternalFields", false);
                if (iFConf == null) {
                    String[] args = new String[]{sdxConf.getLocation()};
                    SDXException sdxE = new SDXException(logger, 15, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
                }
                fieldList.addInternalFields(iFConf);
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        return fieldList;
    }

    public static Repository createRepository(Logger logger, Context context, ServiceManager manager, Configuration repoConf) throws SDXException, ConfigurationException {
        Repository repo = null;
        String repoType = repoConf.getAttribute("type");
        ConfigurationUtils.checkConfAttributeValue("type", repoType, repoConf.getLocation());
        Object l_obj = Utilities.getObjectForClassName(logger, repoType, "fr.gouv.culture.sdx.repository.", repoType, "Repository");
        Class<?> l_objClass = l_obj.getClass();
        if (!(l_obj instanceof Repository)) {
            String[] args = new String[3];
            args[0] = "Repository";
            if (l_objClass != null) {
                args[1] = l_objClass.getName();
            }
            args[2] = repoType;
            throw new SDXException(logger, 10, args, null);
        }
        repo = (Repository)l_obj;
        repo = (Repository)Utilities.setUpSdxObject(repo, logger, Utilities.createNewReadOnlyContext(context), manager);
        repo.configure(repoConf);
        repo.init();
        return repo;
    }

    public static void checkConfAttributeValue(String attName, String attValue, String attLocation) throws ConfigurationException {
        if (!Utilities.checkString(attValue)) {
            String[] args = new String[]{attName, attLocation};
            SDXException sdxE = new SDXException(19, args);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
    }

    public static void checkConfiguration(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            SDXException sdxE = new SDXException(null, 109, null, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
    }

    public static void checkLogger(Logger log) throws ConfigurationException {
        if (log == null) {
            throw new ConfigurationException("A Logger object was null or was not provided");
        }
    }

    public static void checkServiceManager(ServiceManager serviceManager) throws ServiceException {
        if (serviceManager == null) {
            SDXException sdxE = new SDXException(null, 221, null, null);
            throw new ServiceException("", sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
    }

    public static void checkContext(Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("A ContextKeys object was null or was not provided");
        }
    }
}

