/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.thesaurus.Concept;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.lucene.LuceneTools;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.TermQuery;

public class LuceneQueryExpander
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "QueryExpander";
    private SDXThesaurus lThesaurus = null;
    private SearchLocations searchLocations = null;

    public void setUp(SDXThesaurus lt) {
        this.lThesaurus = lt;
    }

    public org.apache.lucene.search.Query expandQuery(Query query, int[] relations, int depth, String[] langs) throws SDXException {
        return this.expandQuery(query, null, relations, depth, langs);
    }

    public org.apache.lucene.search.Query expandQuery(Query query, String fieldName, int[] relations, int depth, String[] langs) throws SDXException {
        org.apache.lucene.search.Query newLQ = null;
        if (query == null) {
            return newLQ;
        }
        this.searchLocations = query.getSearchLocations();
        org.apache.lucene.search.Query origLQ = query.getLuceneQuery();
        if (origLQ != null) {
            newLQ = this.rebuildQuery(origLQ, fieldName, relations, depth, langs);
        }
        return newLQ;
    }

    protected org.apache.lucene.search.Query rebuildQuery(org.apache.lucene.search.Query origQuery, String field, int[] relations, int depth, String[] langs) throws SDXException {
        BooleanQuery newLQ = null;
        if (!(origQuery instanceof BooleanQuery)) {
            newLQ = Utilities.newBooleanQuery();
            newLQ.add(origQuery, BooleanClause.Occur.SHOULD);
        } else {
            newLQ = (BooleanQuery)origQuery;
        }
        BooleanClause[] queryClauses = newLQ.getClauses();
        Hashtable newLQTerms = new Hashtable();
        for (int i = 0; i < queryClauses.length; ++i) {
            try {
                LuceneTools.getTerms((org.apache.lucene.search.Query)newLQ, newLQTerms, false);
            }
            catch (IOException e) {
                throw new SDXException(super.getLog(), 111, null, e);
            }
            BooleanClause clause = queryClauses[i];
            BooleanQuery expandedQuery = Utilities.newBooleanQuery();
            org.apache.lucene.search.Query clauseQuery = clause.getQuery();
            if (clauseQuery instanceof BooleanQuery) {
                this.rebuildQuery(clauseQuery, field, relations, depth, langs);
                continue;
            }
            Hashtable clauseTerms = new Hashtable();
            try {
                LuceneTools.getTerms(clause.getQuery(), clauseTerms, false);
            }
            catch (IOException e) {
                throw new SDXException(super.getLog(), 111, null, e);
            }
            Enumeration keys = clauseTerms.keys();
            if (keys != null) {
                Hashtable expandedQueryTerms = new Hashtable();
                while (keys.hasMoreElements()) {
                    try {
                        LuceneTools.getTerms((org.apache.lucene.search.Query)expandedQuery, expandedQueryTerms, false);
                    }
                    catch (IOException e) {
                        throw new SDXException(super.getLog(), 111, null, e);
                    }
                    String key = (String)keys.nextElement();
                    String searchTerm = (String)clauseTerms.get(key);
                    String fieldName = LuceneTools.getFieldNameFromKey(key);
                    Concept[] matches = null;
                    if (!(fieldName == null || fieldName.startsWith("sdx") || Utilities.checkString(field) && !fieldName.equals(field))) {
                        matches = this.lThesaurus.search(searchTerm);
                    }
                    Concept[] relatedConcepts = null;
                    if (matches != null) {
                        relatedConcepts = this.lThesaurus.getRelations(searchTerm, matches, relations, depth);
                    }
                    if ((relatedConcepts = this.lThesaurus.filterByLangs(relatedConcepts, langs)) == null) continue;
                    for (int k = 0; k < relatedConcepts.length; ++k) {
                        String relatedTerm;
                        if (relatedConcepts[k] == null || searchTerm.equalsIgnoreCase(relatedTerm = relatedConcepts[k].getValue())) continue;
                        Field searchTermField = null;
                        int searchTermFieldType = -1;
                        TokenStream tokenStream = null;
                        Analyzer searchTermFieldAnalyzer = null;
                        if (this.searchLocations != null) {
                            searchTermField = this.searchLocations.getField(fieldName);
                        }
                        if (searchTermField != null) {
                            searchTermFieldType = searchTermField.getFieldType();
                            searchTermFieldAnalyzer = searchTermField.getAnalyzer();
                            if (searchTermFieldType == 0) {
                                tokenStream = searchTermFieldAnalyzer.tokenStream(fieldName, new StringReader(relatedTerm));
                            }
                        }
                        if (tokenStream != null) {
                            Token token = null;
                            try {
                                while ((token = tokenStream.next()) != null) {
                                    String tokenText = token.termText();
                                    String possibleTermKey = fieldName + "_" + tokenText;
                                    if (newLQTerms.containsKey(possibleTermKey) || clauseTerms.containsKey(possibleTermKey) || expandedQueryTerms.containsKey(possibleTermKey)) continue;
                                    Term newTerm = new Term(fieldName, tokenText);
                                    TermQuery tq = new TermQuery(newTerm);
                                    expandedQuery.add((org.apache.lucene.search.Query)tq, BooleanClause.Occur.SHOULD);
                                    LuceneTools.getTerms((org.apache.lucene.search.Query)expandedQuery, expandedQueryTerms, false);
                                }
                                tokenStream.close();
                            }
                            catch (IOException e) {
                                new SDXException(super.getLog(), 219, null, e);
                            }
                            continue;
                        }
                        String possibleTermKey = fieldName + "_" + relatedTerm;
                        if (expandedQueryTerms.containsKey(possibleTermKey)) continue;
                        Term newTerm = new Term(fieldName, relatedTerm);
                        TermQuery tq = new TermQuery(newTerm);
                        expandedQuery.add((org.apache.lucene.search.Query)tq, BooleanClause.Occur.SHOULD);
                    }
                }
            }
            if (expandedQuery == null || expandedQuery.getClauses().length <= 0) continue;
            expandedQuery.add(clauseQuery, BooleanClause.Occur.SHOULD);
            clause.setQuery((org.apache.lucene.search.Query)expandedQuery);
        }
        if (newLQ.getClauses().length == 1) {
            return newLQ.getClauses()[0].getQuery();
        }
        return newLQ;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

