/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis.tokenizer;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public final class ChineseTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 1024;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[1024];
    private int length;
    private int start;

    public ChineseTokenizer(Reader in) {
        this.input = in;
    }

    private final void push(char c) {
        if (this.length == 0) {
            this.start = this.offset - 1;
        }
        this.buffer[this.length++] = Character.toLowerCase(c);
    }

    private final Token flush() {
        if (this.length > 0) {
            return new Token(new String(this.buffer, 0, this.length), this.start, this.start + this.length);
        }
        return null;
    }

    public final Token next() throws IOException {
        this.length = 0;
        this.start = this.offset;
        block4: while (true) {
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                return this.flush();
            }
            char c = this.ioBuffer[this.bufferIndex++];
            switch (Character.getType(c)) {
                case 1: 
                case 2: 
                case 9: {
                    this.push(c);
                    if (this.length != 255) continue block4;
                    return this.flush();
                }
                case 5: {
                    if (this.length > 0) {
                        --this.bufferIndex;
                        return this.flush();
                    }
                    this.push(c);
                    return this.flush();
                }
            }
            if (this.length > 0) break;
        }
        return this.flush();
    }
}

