/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class ChineseFilter
extends TokenFilter {
    public static final String[] STOP_WORDS = new String[]{"and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private Set stopTable;

    public ChineseFilter(TokenStream in) {
        super(in);
        this.stopTable = new HashSet(STOP_WORDS.length);
        for (int i = 0; i < STOP_WORDS.length; ++i) {
            this.stopTable.add(STOP_WORDS[i]);
        }
    }

    public ChineseFilter(TokenStream in, Set stopWords) {
        super(in);
        this.stopTable = stopWords;
        if (this.stopTable == null) {
            this.stopTable = new HashSet();
        }
    }

    public ChineseFilter(TokenStream in, Hashtable stopWords) {
        super(in);
        this.stopTable = stopWords.keySet();
        if (this.stopTable == null) {
            this.stopTable = new HashSet();
        }
    }

    public final Token next() throws IOException {
        String text = null;
        Token token = this.input.next();
        while (token != null) {
            text = token.termText();
            if (!this.stopTable.contains(text)) {
                switch (Character.getType(text.charAt(0))) {
                    case 1: 
                    case 2: {
                        if (text.length() <= 1) break;
                        return token;
                    }
                    case 5: {
                        return token;
                    }
                }
            }
            token = this.input.next();
        }
        return null;
    }
}

