/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis.filter;

import fr.gouv.culture.sdx.search.lucene.analysis.stemmer.BrazilianStemmer;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class BrazilianStemFilter
extends TokenFilter {
    private Token token = null;
    private BrazilianStemmer stemmer = new BrazilianStemmer();
    private Set exclusions = null;

    public BrazilianStemFilter(TokenStream in) {
        super(in);
    }

    public BrazilianStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (s != null && !s.equals(this.token.termText())) {
            return new Token(s, 0, s.length(), this.token.type());
        }
        return this.token;
    }
}

