# Sets up backup configuration

# Convert directory link in the real directory
function ConvDirLink(){
    local InFile ActFile ConvFile

    InFile=$1
    InFile=${InFile// |/|}
    InFile=${InFile//| /|}

    OutFile=""
    IFS=\|
    for ActFile in $InFile
    do
	ConvFile=`readlink -f $ActFile`
	if [ $? != "0" ]; then
	    ConvFile=$ActFile
	fi

	if [ "$OutFile" ]; then
	    OutFile=$OutFile" | "$ConvFile
	else
	    OutFile=$ConvFile
	fi

    done
    IFS=$OLDIFS
}

# Set file list from excluded directory
function ExcFileDir(){
    local InFile IncFile ActFile

    InFile=$1
    IncFile=$2

    ConvDirLink "$InFile"
    InFile=$OutFile

    while read ActFile; do
	if [ "$c_BackUpNoFile" ]; then
	    c_BackUpNoFile=$c_BackUpNoFile" | "$ActFile
	else
	    c_BackUpNoFile=$ActFile
	fi
    done < <(find $InFile\/ -maxdepth 1 -mindepth 1 | grep -Ev $IncFile)
}


OLDIFS=$IFS
OutFile=""

# Convert directory link in the real directory
ConvDirLink "$c_BackUpFile"
c_BackUpFile=$OutFile

ConvDirLink "$c_BackUpNoFile"
c_BackUpNoFile=$OutFile

# Include only several directory and exclude also future new files added in to excluded directory
if [ "$c_MyExcFile1" ]; then
    ExcFileDir $c_MyExcFile1 $c_MyIncFile1 
fi

# Set one backup for every week of mounth
if [ $BackUpName == "BACKUP" ]; then
    BackUpNum=$(($((`date +%-d` - 1)) / 7 + 1))
    c_BackUpDev=$c_BackUpDev"-"$BackUpNum
fi

# Set the backup device name extension 
if [ "$c_BackUpComp" == "gzip" ]; then
   c_BackUpDev=$c_BackUpDev".tgz"
elif [ "$x_BackUpComp" == "bzip" ]; then
   c_BackUpDev=$c_BackUpDev".tar.bz2"
else
   c_BackUpDev=$c_BackUpDev".tar"
fi
