#!/bin/sh
#     Copyright (C) 2005 Stewart Adam
#    This file is part of NewInstall.

#    FWBackups is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWBackups is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWBackups; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

echo 'Fedora Core 4 initial setup script by [S|G], Firewing1 & contributors (see CHANGELOG)'

gethelp()
{
echo -e '\nNEW! Please check out our handy how-to'\''s and tips! \nThey include how to manually do everything that is done, here, in this script, and more such as CD ripping, microphones, and video codecs! \nWould you like to view them now? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 if [ "$(which firefox &> /dev/null; echo $?)" = "0" ]; then
  firefox files/web/index.html

 elif [ "$(which mozilla &> /dev/null; echo $?)" = "0" ]; then
  mozilla files/web/index.html

 elif [ "$(which konqueror &> /dev/null; echo $?)" = "0" ]; then
  konqueror files/web/index.html

 else
  echo -e 'Could not automatically find a web browser on your system. Please type the command name of your web browser:\nexamples: firefox, mozilla, opera, konqueror, etc.';echo -n "Browser:   "
  read browser
  `$browser files/web/index.html`
 fi
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else gethelp
fi
clear
}
#gethelp       NOT COMPLETE *YET*

######## GUI #########
askquit()
{
if [ "$(zenity --question --title 'Quit?' --text 'Are you sure you want to quit?';echo $?)" == "0" ]
then
kill 0
fi
}
gui()
{
ROOT_UID=0   # Root has $UID 0.
# Checks to see if user is running as root
toinstall=""
if [ "$UID" -eq "$ROOT_UID" ]
then
echo '..........................................................'
echo 'Configuring YUM - Livna'
rm -f /etc/yum.conf
wget --directory-prefix=/etc/ http://www.fedorafaq.org/samples/yum.conf
rpm -Uvh http://www.fedorafaq.org/yum --replacefiles
if [ "echo $?" == "0" ]
then
 echo 'Success. Starting GUI.'
else
 echo 'Failed. Starting GUI Anyways.'
fi
other()
{
toinstall="$toinstall $(zenity --list --title "Other Tools" --checklist --column "" --column "Keyword" --column "Description"  --separator " " \
"" "java" "Install Sun Java JRE" \
"" "mstt" "Install MS TrueType fonts" \
"" "FWSuite" "Install FWBackups (An automated backup solution)" \
--height=400 --width=500)"
if [ "$(echo $?)" != "0" ]
then
askquit
fi
}
other

net()
{
toinstall="$toinstall $(zenity --list --title "Internet Tools" --checklist --column "" --column "Keyword" --column "Description"  --separator " " \
"" "amule" "Install AMule/EMule P2P client" \
"" "bt" "Install Bittorrent P2P Download Client" \
"" "flash" "Install Macromedia Flash Player Plugin for Mozilla/Firefox" \
"" "skype" "Install Skype P2P VoIP Client" \
--height=400 --width=500)"
if [ "$(echo $?)" != "0" ]
then
askquit
fi
}
net

media()
{
toinstall="$toinstall $(zenity --list --title "Multimedia Tools" --checklist --column "" --column "Keyword" --column "Description"  --separator " " \
"" "mp3" "Install MP3 codecs" \
"" "wmv" "Install WMV/WMA codecs" \
"" "mplayer" "Install MPlayer Audio/Video player" \
"" "amams" "Install XMMS and Amarok audio player" \
--height=400 --width=500)"
if [ "$(echo $?)" != "0" ]
then
askquit
fi
}
media

sys()
{
toinstall="$toinstall $(zenity --list --title "System Tools" --checklist --column "" --column "Keyword" --column "Description"  --separator " " \
"" "ntfs" "Install NTFS support" \
"" "yumex" "Install YumEx, a graphical interface to yum" \
"" "ati" "Install ATi accelerated drivers" \
"" "nvidia" "Install NVIDIA accelerated drivers" \
--height=400 --width=500)"
if [ "$(echo $?)" != "0" ]
then
askquit
fi
}
sys

lamp()
{
toinstall="$toinstall $(zenity --list --title "Server Tools" --checklist --column "" --column "Keyword" --column "Description"  --separator " " \
"" "httpd" "Install httpd (Apache web server)" \
"" "php" "Install PHP Web / System scripting language" \
"" "mysql" "Install MySQL database server" \
"" "phpmysql" "Install php-mysql plugin (REQUIRED TO USE MYSQL IN PHP)" \
--height=400 --width=500)"
lamp=
if [ "$(echo $?)" != "0" ]
then
askquit
fi
}
lamp


########## FUNCTIONS ##########


#This will install MS truetype fonts from corefonts rpm packages
mstt()
{
 wget http://www.geocities.com/diegolimabr/msttcorefonts-1.3-4.noarch.rpm
 rpm -ivh msttcorefonts-1.3-4.noarch.rpm
 rm -f msttcorefonts-1.3-4.noarch.rpm
}

amule()
{
amule="amule"
yum="1"
}

bt()
{
bittorrent="bittorrent bittorrent-gui"
yum="1"
#this will open ports 6881 through 6999 in the firewall. Bittorrent commonly uses these ports.
/sbin/iptables -I INPUT -p tcp --destination-port 6881:6999 -j ACCEPT
/sbin/iptables-save > /etc/sysconfig/iptables #saving the modifications to iptables
/sbin/iptables -L #reload iptables in order to load new configuration
}

#Flash plugin for web browsers. Tested on firefox and mozilla only so far! (Meaning: I dont know if others are supported by this plugin)
flash()
{
yum -y --enablerepo=flash install flash-plugin --disablerepo=livna
}

#This will install Skype 1.2.0.18 FC3 build from skype website.
skype()
{
wget http://download.skype.com/linux/skype-1.2.0.18-fc3.i586.rpm
rpm -ivh skype-1.2.0.18-fc3.i586.rpm
rm -f skype-1.2.0.18-fc3.i586.rpm
}
mp3()
{
codec="w32codec gstreamer-plugins-mp3 xmms-mp3 k3b-mp3 kdemultimedia-extras"
yum2="1"
}
wmv()
{
codec2="gstreamer-plugins gstreamer-plugins-audio gstreamer-plugins-extra-audio gstreamer-plugins-video gstreamer-plugins-extra-video"
yum2="1"
}

#Mplayer, GUI and plugin for web browsers (at least for firefox...)
mplayer()
{ 
yum2="1" 
mplayer="mplayer-skins mplayer mplayer-fonts mplayerplug-in"
}

amams()
{
amams="amarok xmms xmms-skins xmms-mp3"
yum="1"
}

#Yumex support. Yumex is a GUI frontend for YUM.
yumex()
{
yumex="yumex"
}

# Java install
java()
{
wget http://jdl.sun.com/webapps/download/AutoDL?BundleId=10336 -O jre-1.5.0_06-linux-i586.bin
mv jre-1.5.0_06-linux-i586.bin /usr/java;chmod +x /usr/java/jre-1.5.0_06-linux-i586.bin
dir=$(pwd)
cd /usr/java
./jre-1.5.0_06-linux-i586.bin
ln -s /usr/java/jre1.5.0_06/plugin/i386/ns7/libjavaplugin_oji.so /usr/lib/mozilla/plugins/libjavaplugin_oji.so
export J2RE_HOME=/usr/java/jre1.5.0_06
export PATH=$J2RE_HOME/bin:$PATH
zenity --warning --text "Please turn your attention to the terminal; User input is needed." --title 'Warning!'
/usr/sbin/alternatives --install /usr/bin/java java /usr/java/jre1.5.0_06/bin/java 2
clear
echo 'On the following menu, please choose number 2 ( /usr/java/jre1.5.0_06/bin/java ). Press any key to continue...'
read -n 1 nothing
/usr/sbin/alternatives --config java
echo 'Java installation complete. Returning to GUI.'
sleep 2
cd "$pwd"
}

#NTFS support
ntfs()
{
ntfs="kernel-module-ntfs-$(uname -r)"
yum="1"
}

#ATI Radeon support. I never tried this, but should work.
ati()
{
ati="ati-fglrx kernel-module-fglrx-$(uname -r)"
yum="1"
}

#Same as above, but for NVidia-based cards.
nvidia()
{
nvidia="nvidia-glx kernel-module-nvidia-$(uname -r)"
yum="1"
}

php()
{
lamp="$lamp php"
yum="1"
zenity --warning --text "Don't forget to secure your initial MySQL root account! \n Please see http://dev.mysql.com/doc/refman/4.1/en/default-privileges.html" --title 'Warning!'
}

httpd()
{
lamp="$lamp httpd"
yum="1"
}

mysql()
{
lamp="$lamp mysql mysql-server mysql-bench"
yum="1"
zenity --warning --text "Don't forget to secure your initial MySQL root account! \n Please see http://dev.mysql.com/doc/refman/4.1/en/default-privileges.html" --title 'Warning!'
}
phpmysql()
{
lamp="$lamp php-mysql"
yum="1"
}

FWSuite()
{
rpm -Uhv files/FWBackups-1.3-5.noarch.rpm
}

serverconf()
{
 echo 'Configure HTTPD (web server) with common options?'
 echo '(This will save your /etc/httpd/conf/httpd.conf as httpd.conf.old)'
 echo '(it should work out of the box, though)'
 echo 'y for yes, n for no, c to cancel/exit'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then
  mv /etc/httpd/conf/httpd.conf /etc/httpd/conf/httpd.conf.old
  cp files/etc/httpd/conf/httpd.conf /etc/httpd/conf/
  echo 'What is the name of the home folder of your default user? (This is usually your login name)'
  echo 'Example: /home/foo (login: foo), /home/fedora (login: fedora), /home/user (login: user)'
  read tmp
  mkdir "$tmp"/public_html
  echo "A '$tmp'\public_html has been created. Please place your html pages here. "
  echo 'Please review /etc/httpd/conf/httpd.conf and set the values to your preferences.'
  echo 'It should work out of the box, though.'
  echo 'Press any enter to continue...'
  read tmp
 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else serverconf
 fi
}

#yum will only run at this point if anything was set for installing
parse_all()
{
for arg in $toinstall;do
$arg
done
}
parse_all

install_all()
{
if [ "$yum" = "1" ]
then
 yum -y install $amams $ntfs $kde $ati $nvidia $rbox $lamp $devel $amule $bittorrent
fi
#installs stuff that need atrpms if any was chosen
if [ "$yum2" = "1" ]
then
 yum -y --enablerepo=atrpms install $codec $mplayer
fi
clear
}
install_all
#Update the system
update()
{
pi="0"
echo 'ATTENTION! At this point we will update your entire system. This may take quite a while!'
echo 'Press Y to continue with the update (recommended) or any other key to skip this step.'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
	echo 'Updating your system... This may take a LOT of time, depeending on how outdated your system software is. Grab some cofee and watch some TV.'
	yum -y update
	clear
	#echo 'Please note that you may have to reinstall your Graphics driver and the NTFS driver if your kernel was updated.'
	#echo 'You can easily do that by running this script again after rebooting and choosing to install the modules again.'
	#echo 'If you just installed those modules, you dont have to worry as they will be automatically updated as well.'
	#echo 'Press enter to continue.'
	read -n 1 tmp
#If we chose to install nvidia drivers, we'll also install them for any newer kernell installed with the update at this point
        if [ "$nvd" = "y" ]
	then
	 nvd2="kernel-module-nvidia-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
         pi="1"
	fi
#If we chose to install NTFS kernel module, we'll also install it for any newer kernel installed with the update at this point
	if [ "$ntf" = "y" ]
	then
	 ntfs2="kernel-module-ntfs-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
	 pi="1" 
	fi
#If we chose to install ATI drivers, we'll also install them for any newer kernell installed with the update at this point
	if [ "$ati" = "y" ] 
	then
	 ati2="ati-fglrx kernel-module-fglrx-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
	 pi="1"
	fi
	clear
elif [ "$tmp" != "y" ]; then
echo -e '\nSkipped.'
else update
fi
}
update
#At this point we will install kernel module updates
if [ "$pi" = "1" ]
then
 yum -y install $nvd2 $ntfs2 $ati2
fi
echo "You may need to reboot to complete setup."
else
  echo "You need root privileges to run this script!"
  echo 'This script needs to be run as root. To become root, type "su" then re-run this script.'
fi
}

#################################################################################
#################################################################################
#################################################################################
######## END GUI, START TEXT ################################################### #################################################################################
#################################################################################
#################################################################################






text()
{
ROOT_UID=0   # Root has $UID 0.

# Checks to see if user is running as root
if [ "$UID" -eq "$ROOT_UID" ]
then

echo '..........................................................'
echo 'Configuring YUM - Livna'
rm -f /etc/yum.conf
wget --directory-prefix=/etc/ http://www.fedorafaq.org/samples/yum.conf
rpm -Uvh http://www.fedorafaq.org/yum
clear

#This will install MS truetype fonts from corefonts rpm packages
fonts_install()
{
echo 'Install True Type fonts? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 wget http://www.geocities.com/diegolimabr/msttcorefonts-1.3-4.noarch.rpm
 rpm -ivh msttcorefonts-1.3-4.noarch.rpm
 rm msttcorefonts-1.3-4.noarch.rpm
 clear
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else fonts_install
fi
}
fonts_install

nettools()
{
 echo 'Would you like to install any one of the following internet tools?'
 echo '-AMule E2k Client (Edonkey/Emule)'
 echo '-Bittorrent P2P Download Software'
 echo '-Macromedia Flash Player Plugin for Mozilla/Firefox'
 echo '-Skype P2P VoIP Software'
 echo '(y for yes, n for no, c to cancel/exit)'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then

#Amule e2k client
install_amule()
{
echo 'Install AMule E2k client (Emule network compatible)? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 amule="amule"
 yum="1"
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else install_amule
fi
}
install_amule

install_bittorrent()
{
echo 'Install Bittorrent client? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 bittorrent="bittorrent bittorrent-gui"
 yum="1"
 #this will open ports 6881 through 6999 in the firewall. Bittorrent commonly uses these ports.
 /sbin/iptables -I INPUT -p tcp --destination-port 6881:6999 -j ACCEPT
 /sbin/iptables-save > /etc/sysconfig/iptables #saving the modifications to iptables
 /sbin/iptables -L #reload iptables in order to load new configuration
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else install_bittorrent
fi
}
install_bittorrent

#Flash plugin for web browsers. Tested on firefox and mozilla only so far! (Meaning: I dont know if others are supported by this plugin)
install_flash()
{
echo 'Install flash? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 yum -y --enablerepo=flash install flash-plugin
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else install_flash
fi
}
install_flash


#This will install Skype 1.2.0.18 FC3 build from skype website.
install_skype()
{
echo 'Install Skype (P2P VoIP) software? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 wget http://download.skype.com/linux/skype-1.2.0.18-fc3.i586.rpm
 rpm -ivh skype-1.2.0.18-fc3.i586.rpm
 rm skype-1.2.0.18-fc3.i586.rpm
 clear
elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else install_skype
fi
}
install_skype

 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else nettools
 fi
}
nettools

#asks user wether to install multimedia support
mmedia_question()
{
echo 'Install multimedia players and codecs? (y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then

  #install some packages related to mp3 playing and video codecs - used to be only w32codecs, but changed to include all mp3 codecs
  mp3()
  {
  echo 'Install mp3 and other Codecs? (y for yes, n for no, c to cancel/exit)'
  read -n 1 tmp
  if [ "$tmp" = "y" ]; then
   codec="w32codec gstreamer-plugins-mp3 xmms-mp3 kdemultimedia-extras"
   yum2="1" 
  elif [ "$tmp" = "n" ]; then
   clear
  elif [ "$tmp" = "c" ]; then
   kill 0
  else mp3
  fi
  }
  mp3

  #Mplayer, GUI and plugin for web browsers (at least for firefox...)
  mplayeri()
  { 
  echo 'Install mplayer? (y for yes, n for no, c to cancel/exit)'
  read -n 1 tmp
  if [ "$tmp" = "y" ]; then
   yum2="1" 
   mplayer="mplayer-skins mplayer mplayer-fonts mplayerplug-in"
  elif [ "$tmp" = "n" ]; then
   clear
  elif [ "$tmp" = "c" ]; then
   kill 0
  else mplayer
  fi
  }
  mplayeri

  #Nice media player that looks like winamp 2.x, extra skins and mp3 plugins
  xmmsi()
  {
  echo 'Install xmms? (y for yes, n for no, c to cancel/exit)'
  read -n 1 tmp
  if [ "$tmp" = "y" ]; then
   xmms="xmms xmms-skins xmms-mp3"
   yum="1"
  elif [ "$tmp" = "n" ]; then
   clear
  elif [ "$tmp" = "c" ]; then
   kill 0
  else xmms
  fi
   }
  xmmsi

  #Amarok player along with xmms mp3 plugins in case xmms wasnt chosen
  amaroi()
  {
  echo 'Install AmaroK music player? (y for yes, n for no, c to cancel/exit)'
  read -n 1 tmp
  if [ "$tmp" = "y" ]; then
   amarok="amarok xmms-mp3"
   yum="1"
  elif [ "$tmp" = "n" ]; then
   clear
  elif [ "$tmp" = "c" ]; then
   kill 0
  else amaroi
  fi
  }
  amaroi

elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else mmedia_question
fi
}
mmedia_question

#Extra system utilities
system()
{
echo 'Would you like to install any one of the following extra tools?'
echo '- NTFS drivers'
echo '- Nvidia/GeForce drivers'
echo '- ATi drivers'
echo '- YumExtender aka yumex'
echo '- Java Runtime Environment (Required to display java applets)'
echo '(y for yes, n for no, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then

#Yumex support. Yumex is a GUI frontend for YUM.
 yumexi()
 {
 echo 'Install Yumex? Yumex is a GUI frontend for Yum. (y for yes, n for no, c to cancel/exit)'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then
  yumex="yumex"
 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else yumexi
 fi
 }
 yumexi

clear
# Java install
java_install()
{
echo 'Install Java Runtime Enviromnent? (y for yes, n for no, c to cancel/exit)'
read -n 1 java
if [ $java = "y" ]; then
 wget http://jdl.sun.com/webapps/download/AutoDL?BundleId=10336 -O jre-1.5.0_06-linux-i586.bin
 mv jre-1.5.0_06-linux-i586.bin /usr/java;chmod +x /usr/java/jre-1.5.0_06-linux-i586.bin
 dir=$(pwd)
 cd /usr/java
 ./jre-1.5.0_06-linux-i586.bin
  ln -s /opt/jre1.5.0_06/plugin/i386/ns7/libjavaplugin_oji.so /usr/lib/mozilla/plugins/libjavaplugin_oji.so
  export J2RE_HOME=/opt/jre1.5.0_06
  export PATH=$J2RE_HOME/bin:$PATH
  /usr/sbin/alternatives --install /usr/bin/java java /usr/java/jre1.5.0_06/bin/java 2
  clear
  echo 'On the following menu, please choose number 2 ( /usr/java/jre1.5.0_06/bin/java ). Press any key to continue...'
  read -n 1 nothing
  /usr/sbin/alternatives --config java
  echo 'Java installation complete.'  
 cd "$pwd"
 clear
elif [ $java = "n" ]; then
 clear
elif [ $java = "c" ]; then
 kill 0
else java_install
fi
}
java_install

#NTFS support
 ntfsi()
 {
 echo 'Install kernel NTFS module? (y for yes, n for no, c to cancel/exit)'
 read -n 1 ntf
 if [ $ntf = "y" ]; then
  ntfs="kernel-module-ntfs-$(uname -r)"
  yum="1"
 elif [ $ntf = "n" ]; then
  clear
 elif [ $ntf = "c" ]; then
  kill 0
 else ntfsi
 fi
 }
 ntfsi

#ATI Radeon support. I never tried this, but should work.
 atii()
 {
 echo 'Install ATI Radeon video card drivers? (y for yes, n for no, c to cancel/exit)'
 read -n 1 ati
 if [ $ati = "y" ]; then
  ati="ati-fglrx kernel-module-fglrx-$(uname -r)"
  yum="1"
 elif [ $ati = "n" ]; then
  clear
 elif [ $ati = "c" ]; then
  kill 0
 else atii
 fi
 }
 atii

#Same as above, but for NVidia-based cards. This is the one I personally use
 nvidiai()
 {
 echo 'Install NVidia video card drivers? (y for yes, n for no, c to cancel/exit)'
 read -n 1 nvd
 if [ $nvd = "y" ] 
 then
  nvidia="nvidia-glx kernel-module-nvidia-$(uname -r)"
  yum="1"
 elif [ $nvd = "n" ]; then
  clear
 elif [ $nvd = "c" ]; then
  kill 0
 else nvidiai
 fi
}
nvidiai


elif [ "$tmp" = "n" ]; then
 clear
elif [ "$tmp" = "c" ]; then
 kill 0
else system
fi
}
system

LAMP()
{
 echo 'Install a LAMP server?'
 echo 'MySQL server (mysqld)'
 echo 'Apache Web Server (httpd)'
 echo 'PHP CLI and CGI'
echo '(y for yes, n for no, c to cancel/exit)'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then
 lamp="php httpd mysql mysql-server mysql-bench php-mysql"
 yum="1"
 echo "Don't forget to secure your initial MySQL root account!"
 echo "Please see http://dev.mysql.com/doc/refman/4.1/en/default-privileges.html"
 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else LAMP
 fi
}
LAMP

FWSuite()
{
 echo 'Install FWBackups v1.3-4, an automated backup solution?'
echo '(y for yes, n for no, c to cancel/exit)'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then
   rpm -Uhv files/FWBackups-1.3-4.noarch.rpm
 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else FWSuite
 fi
}
FWSuite

serverconf()
{
 echo 'Configure HTTPD (web server) with common options?'
 echo '(This will save your /etc/httpd/conf/httpd.conf as httpd.conf.old)'
 echo '(it should work out of the box, though)'
 echo 'y for yes, n for no, c to cancel/exit'
 read -n 1 tmp
 if [ "$tmp" = "y" ]; then
  mv /etc/httpd/conf/httpd.conf /etc/httpd/conf/httpd.conf.old
  cp files/etc/httpd/conf/httpd.conf /etc/httpd/conf/
  echo 'What is the name of the home folder of your default user? (This is usually your login name)'
  echo 'Example: /home/foo (login: foo), /home/fedora (login: fedora), /home/user (login: user)'
  read tmp
  mkdir "$tmp"/public_html
  echo "A '$tmp'\public_html has been created. Please place your html pages here. "
  echo 'Please review /etc/httpd/conf/httpd.conf and set the values to your preferences.'
  echo 'It should work out of the box, though.'
  echo 'Press any enter to continue...'
  read tmp
 elif [ "$tmp" = "n" ]; then
  clear
 elif [ "$tmp" = "c" ]; then
  kill 0
 else serverconf
 fi
}
serverconf

#yum will only run at this point if anything was set for installing
if [ $yum = "1" ]
then
 yum -y install $xmms $ntfs $kde $ati $nvidia $rbox $amarok $lamp $devel $amule $bittorrent
fi
#installs stuff that need atrpms if any was chosen
if [ $yum2 = "1" ]
then
 yum -y --enablerepo=atrpms install $codec $mplayer $codec2
fi
clear

#Update the system
update()
{
pi="0"
echo 'ATTENTION! At this point we will update your entire system. This may take quite a while!'
echo 'Press Y to continue with the update (recommended) or any other key to skip this step.'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
	echo 'Updating your system... This may take a LOT of time, depending on how many packages must be installed. Grab some cofee and watch some TV.'
	yum -y update
	clear
	#echo 'Please note that you may have to reinstall your Graphics driver and the NTFS driver if your kernel was updated.'
	#echo 'You can easily do that by running this script again after rebooting and choosing to install the modules again.'
	#echo 'If you just installed those modules, you dont have to worry as they will be automatically updated as well.'
	#echo 'Press enter to continue.'
	read -n 1 tmp
#If we chose to install nvidia drivers, we'll also install them for any newer kernell installed with the update at this point
        if [ $nvd = "y" ]
	then
	 nvd2="kernel-module-nvidia-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
         pi="1"
	fi
#If we chose to install NTFS kernel module, we'll also install it for any newer kernel installed with the update at this point
	if [ $ntf = "y" ]
	then
	 ntfs2="kernel-module-ntfs-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
	 pi="1" 
	fi
#If we chose to install ATI drivers, we'll also install them for any newer kernell installed with the update at this point
	if [ $ati = "y" ] 
	then
	 ati2="ati-fglrx kernel-module-fglrx-$(rpm -q --queryformat="%{version}-%{release}\n" kernel | tail -n 1)"
	 pi="1"
	fi
	clear
elif [ "$tmp" != "n" ]; then
 echo -e '\nSkipped.'
else update
fi
}
update

#At this point we will install kernel module updates
if [ "$pi" = "1" ]
then
 yum -y install $nvd2 $ntfs2 $ati2
fi
echo "You may need to reboot to complete setup."
else
  echo "You need root privileges to run this script!"
  echo 'This script needs to be run as root. To become root, type "su" then re-run this script.'
fi
}
####################### RUN THE SCRIPT ################
ask_mode()
{
echo 'Run in GUI mode? (y for yes, n for text mode, c to cancel/exit)'
read -n 1 tmp
if [ "$tmp" = "y" ]; then
 if [ "$(rpm -q --qf '%{NAME}' gnome-utils)" == "gnome-utils" ]; then
  echo -e '\n'
  gui
  else
  echo -e "Please install Zenity. You can do to with:\n user@host:#$ su -c 'rpm -e zenity;yum install gnome-utils'"
 fi
elif [ "$tmp" = "n" ]; then
  echo -e '\n'
 text
elif [ "$tmp" = "c" ]; then
 kill 0
else ask_mode
fi
}
ask_mode


exit 0
