#!/bin/bash
#     Copyright (C) 2005, 2006 Stewart Adam
#    This file is part of audio-convert-mod.

#    audio-convert-mod is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    FWaudio-convert-mod is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with FWaudio-convert-mod; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# The system install script for audio-convert-mod
# v3.42

ROOT_UID=0   # Root has $UID 0.

# Run this script as root if not already. Jim's fix:
chk_root () {
	if [ ! $( id -u ) -eq 0 ]; then
		wd="$(pwd)"
		echo "Please enter root's password."
		exec su - -c "cd '$wd';${0} ${CMDLN_ARGS}" # Call this prog as root
		exit ${?}  # since we're 'execing' above, we wont reach this exit
		# unless something goes wrong.
	  fi
}
# Call this function early on - now or before your script's main loop starts.  
chk_root

if [ "$UID" -eq "$ROOT_UID" ];then
	mkdir -p /etc/skel/.gnome2/nautilus-scripts
	cp -r ./audio-convert-mod "/etc/skel/.gnome2/nautilus-scripts"
	cp "/etc/skel/.gnome2/nautilus-scripts/audio-convert-mod/Convert Files (v3.42)" "/usr/local/bin/audio-convert-mod"
	cp "/etc/skel/.gnome2/nautilus-scripts/audio-convert-mod/Remove .converted from files or folder contents" "/usr/local/bin/remove-converted-endings"
	cp ./bin-usr-instl.sh "/usr/local/bin/audio-convert-mod-userinstall"
	chown root.root "/etc/skel/.gnome2/nautilus-scripts/audio-convert-mod" -R
	chmod 755 "/etc/skel/.gnome2/nautilus-scripts/audio-convert-mod" -R
	chmod +x "/usr/local/bin/audio-convert-mod-userinstall"
	chmod +x "/usr/local/bin/audio-convert-mod"
	chmod +x "/usr/local/bin/remove-converted-endings"
	echo "System install complete."
else
	echo "This script needs to be run as root."
fi
