#!/usr/bin/env ruby
#
# Samizdat front page
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

request do |session|
    t = session.template
    skip, skip_focus = session.params %w[skip skip_focus]
    skip = skip.to_i
    skip_focus = skip_focus.to_i

    table = rdf.select_all( %{
SELECT ?focus, count(?resource)
WHERE (rdf::predicate ?stmt dc::relation)
      (rdf::subject ?stmt ?resource)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
LITERAL ?rating > 0
GROUP BY ?focus
ORDER BY count(?resource) DESC
USING PRESET NS}, limit_page, limit_page * skip_focus
    ).collect {|focus, usage| [ Resource.new(session, focus).render, usage ] }

    page = [ [ _('Main Focuses') +
            (skip_focus > 0? sprintf(_(', page %s'), skip_focus + 1) : ''),
        t.table([[_('Focus'), _('Related Resources')]] + table,
            t.nav(skip_focus + 1, 'index.rb?', 'skip_focus')) ] ]

    messages = rdf.select_all( %{
SELECT ?msg
WHERE (dc::date ?msg ?date)
      (s::inReplyTo ?msg ?parent)
      (dct::isVersionOf ?msg ?current)
LITERAL ?parent IS NULL AND ?current IS NULL
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render }

    page << [ _('Recent Updates') +
            (skip > 0? sprintf(_(', page %s'), skip + 1) : ''),
        t.list(messages, t.nav(skip + 1)) ]

    t.page(_('Front Page'), page)   # todo: language_box for new users
end
