; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(lambda (GTYPE algorithms 
	       VTYPE vertex-properties ETYPE edge-properties
	       directed? bidirectional?)
  (define (pad . args)
    (string->symbol
      (apply string-append
        (map (lambda (a)
               (cond
                 [(string? a) a]
                 [(symbol? a) (symbol->string a)]
                 [else "UNKNOWN_PAD_SYMBOL"]))
          args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (define (when-bi-or-dir . in-args)
    (if (or bidirectional? directed?) in-args '()))
  (let* (
         [NVP (length vertex-properties)]
         [NEP (length edge-properties)]
         [rec GTYPE]
         [rec? (gensym)]
         [make-rec (gensym)]
         [rec-vl (gensym)]
         [set-rec-vl! (gensym)]
         [rec-pgetters (gensym)]
         [rec-psetters (gensym)]

         [streamed? (cond-expand (srfi-40 #t) (else #f))]
         [vertex-set? (pad GTYPE "-vertex-set?")]
         [edge-set? (pad GTYPE "-edge-set?")]
         [constructor (pad "make-" GTYPE)]
         [add-edge! (pad GTYPE "-add-edge!")]
         [remove-edge! (pad GTYPE "-remove-edge!")]
         [remove-edge2! (pad GTYPE "-remove-edge2!")]
         [add-directed-edge! (pad "##carp#" GTYPE "-add-directed-edge!")]
         [remove-directed-edge! (pad "##carp#" GTYPE "-remove-directed-edge!")]
         [out-edges (pad GTYPE "-out-edges")]
         [out-edges* (pad GTYPE "-out-edges*")]
         [out-degree (pad GTYPE "-out-degree")]
         [in-edges (pad GTYPE "-in-edges")]
         [in-edges* (pad GTYPE "-in-edges*")]
         [in-degree (pad GTYPE "-in-degree")]
         [neighbours (pad GTYPE "-neighbours")]
         [neighbours* (pad GTYPE "-neighbours*")]

         ;; imports
         [import-vertex-list (pad "define-" (car VTYPE))]
         [import-edge-list (pad "define-" (car ETYPE))]
         [vl-constructor (pad "##carp#make-" GTYPE "-vl")]
         [source (pad GTYPE "-source")]
         [target (pad GTYPE "-target")]
         [out-edge-list (pad "##carp#" GTYPE "-out-edge-list")]
         [in-edge-list (pad "##carp#" GTYPE "-in-edge-list")]
         [edges (pad "##carp#" GTYPE "-edges")]
         [edges* (pad "##carp#" GTYPE "-edges*")]
         [degree (pad "##carp#" GTYPE "-degree")]
         )
    `(begin
       (define-record-type ,rec
         (,make-rec vl pgetters psetters)
         ,rec?
         (vl ,rec-vl ,set-rec-vl!)
         (pgetters ,rec-pgetters)
         (psetters ,rec-psetters))
       (,import-edge-list ,GTYPE ,(cdr ETYPE) ,streamed? ,bidirectional? ,edge-properties)
       (,import-vertex-list ,GTYPE ,(cdr VTYPE) ,streamed? ,bidirectional? ,vertex-properties ,rec-vl)
       (define-record-printer ,rec
         (lambda (x p)
           (fprintf p "Adjacency List~%")
           (fprintf p "num-vertex-props\t~S~%" ,NVP)
           (fprintf p "num-edge-props\t~S" ,NEP)))
       (define ,constructor
         (lambda ()
           (let* (
                  [pgetters (make-hash-table eq? ,(+ NVP NEP))]
                  [psetters (make-hash-table eq? ,(+ NVP NEP))]
                  [rec (,make-rec #f pgetters psetters)]
                  )
             (,set-rec-vl! rec (,vl-constructor rec))
             ,@(map
                 (lambda (prop)
                   (define getter (pad GTYPE "-" prop))
                   (define setter (pad "set-" GTYPE "-" prop "!"))
                   `(begin
                      (hash-table-set! pgetters (quote ,prop) ,getter)
                      (hash-table-set! psetters (quote ,prop) ,setter)))
                 (append vertex-properties edge-properties))
             rec)))
       (define ,add-edge!
         (lambda (g u v)
           (let ([ret (,add-directed-edge! g u (,out-edge-list g u) v)])
             ,@(when-bi
                 `(,add-directed-edge! g v (,in-edge-list g v) u))
             (unless ,directed?
               (,add-directed-edge! g v (,out-edge-list g v) u)
               ,@(when-bi
                   `(,add-directed-edge! g u (,in-edge-list g u) v)))
             ret)))
       (define ,remove-edge!
         (lambda (g e)
           (,remove-edge2! g (,source g e) (,target g e))))
       (define ,remove-edge2!
         (lambda (g u v)
           (let ([ret (,remove-directed-edge! g u (,out-edge-list g u) v)])
             ,@(when-bi
                 `(,remove-directed-edge! g v (,in-edge-list g v) u))
             (unless ,directed?
               (,remove-directed-edge! g v (,out-edge-list g v) u)
               ,@(when-bi
                   `(,remove-directed-edge! g u (,in-edge-list g u) v)))
             ret)))
       
       (define ,out-edges
         (lambda (g u)
           (,edges g u (,out-edge-list g u) #t)))
       (define ,out-edges*
         (lambda (g u)
           (,edges* g u (,out-edge-list g u) #t)))
       (define ,out-degree
         (lambda (g u)
           (,degree g u (,out-edge-list g u))))
       ,@(when-bi
           `(define ,in-edges
              (lambda (g u)
                (,edges g u (,in-edge-list g u) #f)))
           `(define ,in-edges*
              (lambda (g u)
                (,edges* g u (,in-edge-list g u) #f)))
           `(define ,in-degree
              (lambda (g u)
                (,degree g u (,in-edge-list g u)))))
       ,@(when-bi-or-dir
	  `(define ,neighbours
	     (lambda (g u)
	       (append 
		(map
		 (lambda (e) (cons (,target g e) e))
		 (,out-edges g u))
		(map
		 (lambda (e) (cons (,source g e) e))
		 (,in-edges g u)))))
	  `(define ,neighbours*
	     (lambda (g u)
	       (stream-append 
		(stream-map
		 (lambda (e) (cons (,target g e) e))
		 (,out-edges* g u))
		(stream-map
		 (lambda (e) (cons (,source g e) e))
		 (,in-edges* g u))))))
       ,@(map
	  (lambda (algorithm)
	    `(,(pad "import-" algorithm) ,GTYPE ,streamed?
              (,vertex-set?) (,edge-set?)
	      ,directed? ,bidirectional?))
	  algorithms)
       )))