;; Not only does this file expand all the (include "xxx") forms, it
;; also strips the comments for faster syntax loading

;; same as map, but uses append instead of cons (so that proc must
;; return a list)
(define (map-append proc l)
  (let iter ([pnode l])
    (cond
      [(null? pnode) '()]
      [(list? pnode)
        (append
          (proc (car pnode))
          (iter (cdr pnode)))]
      (else pnode))))

(define (include-file filename)
  (with-input-from-file filename
    (lambda ()
      ;; read transform loop
      (let rtl ()
        (let ([obj (read)])
          (cond
            [(eof-object? obj) '()]
            (else
              (cons obj (rtl)))))))))

;; a tree is a sequence of sub-trees
(define (expand-includes tree)
  (map-append
    (lambda (sub-tree)
      (cond
        [(and (pair? sub-tree)              
              (pair? (cdr sub-tree)) ;; has length == 2
              (eq? 'include (car sub-tree)))
         ;; found an (include "xxx") form
         (expand-includes (include-file (cadr sub-tree)))
         ]
        [(and (pair? sub-tree))         
         (list (expand-includes sub-tree))]
        (else (list sub-tree))))
    tree))

(unless (= (length (command-line-arguments)) 1)
  (error "usage: csi -script merge.scm SCHEME-FILE"))

(for-each
  (lambda (tree)
    (pretty-print tree))
  (expand-includes (include-file (car (command-line-arguments)))))
