(define rgraph-doc-copyright-rgraph #t)
(define rgraph-doc-copyright-boost #t)
(define rgraph-doc-usage-imports #t)
(define rgraph-doc-usage-debugging #t)
(cond-expand
  (rgraph-nodebug
    (define-macro rgraph-debug (lambda (body) '())))
  ((or rgraph-debug csi)
   (define-macro rgraph-debug (lambda (body) body)))
  (else (define-macro rgraph-debug (lambda (body) '()))))
(define rgraph-doc-adjacency-list #t)
(define-macro
  define-adjacency-list
  (lambda (GTYPE
           algorithms
           VTYPE
           vertex-properties
           ETYPE
           edge-properties
           directed?
           bidirectional?)
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (define (when-bi . in-args)
      (if bidirectional? in-args '()))
    (define (when-bi-or-dir . in-args)
      (if (or bidirectional? directed?) in-args '()))
    (let* ((NVP (length vertex-properties))
           (NEP (length edge-properties))
           (rec GTYPE)
           (rec? (gensym))
           (make-rec (gensym))
           (rec-vl (gensym))
           (set-rec-vl! (gensym))
           (rec-pgetters (gensym))
           (rec-psetters (gensym))
           (streamed? (cond-expand (srfi-40 #t) (else #f)))
           (vertex-set? (pad GTYPE "-vertex-set?"))
           (edge-set? (pad GTYPE "-edge-set?"))
           (constructor (pad "make-" GTYPE))
           (add-edge! (pad GTYPE "-add-edge!"))
           (remove-edge! (pad GTYPE "-remove-edge!"))
           (remove-edge2! (pad GTYPE "-remove-edge2!"))
           (add-directed-edge!
             (pad "##carp#" GTYPE "-add-directed-edge!"))
           (remove-directed-edge!
             (pad "##carp#" GTYPE "-remove-directed-edge!"))
           (out-edges (pad GTYPE "-out-edges"))
           (out-edges* (pad GTYPE "-out-edges*"))
           (out-degree (pad GTYPE "-out-degree"))
           (in-edges (pad GTYPE "-in-edges"))
           (in-edges* (pad GTYPE "-in-edges*"))
           (in-degree (pad GTYPE "-in-degree"))
           (neighbours (pad GTYPE "-neighbours"))
           (neighbours* (pad GTYPE "-neighbours*"))
           (import-vertex-list (pad "define-" (car VTYPE)))
           (import-edge-list (pad "define-" (car ETYPE)))
           (vl-constructor (pad "##carp#make-" GTYPE "-vl"))
           (source (pad GTYPE "-source"))
           (target (pad GTYPE "-target"))
           (out-edge-list
             (pad "##carp#" GTYPE "-out-edge-list"))
           (in-edge-list
             (pad "##carp#" GTYPE "-in-edge-list"))
           (edges (pad "##carp#" GTYPE "-edges"))
           (edges* (pad "##carp#" GTYPE "-edges*"))
           (degree (pad "##carp#" GTYPE "-degree")))
      `(begin
         (define-record-type
           ,rec
           (,make-rec vl pgetters psetters)
           ,rec?
           (vl ,rec-vl ,set-rec-vl!)
           (pgetters ,rec-pgetters)
           (psetters ,rec-psetters))
         (,import-edge-list
          ,GTYPE
          ,(cdr ETYPE)
          ,streamed?
          ,bidirectional?
          ,edge-properties)
         (,import-vertex-list
          ,GTYPE
          ,(cdr VTYPE)
          ,streamed?
          ,bidirectional?
          ,vertex-properties
          ,rec-vl)
         (define-record-printer
           ,rec
           (lambda (x p)
             (fprintf p "Adjacency List~%")
             (fprintf p "num-vertex-props	~S~%" ,NVP)
             (fprintf p "num-edge-props	~S" ,NEP)))
         (define ,constructor
           (lambda ()
             (let* ((pgetters (make-hash-table eq? ,(+ NVP NEP)))
                    (psetters (make-hash-table eq? ,(+ NVP NEP)))
                    (rec (,make-rec #f pgetters psetters)))
               (,set-rec-vl! rec (,vl-constructor rec))
               ,@(map (lambda (prop)
                        (define getter (pad GTYPE "-" prop))
                        (define setter (pad "set-" GTYPE "-" prop "!"))
                        `(begin
                           (hash-table-set! pgetters ',prop ,getter)
                           (hash-table-set! psetters ',prop ,setter)))
                      (append vertex-properties edge-properties))
               rec)))
         (define ,add-edge!
           (lambda (g u v)
             (let ((ret (,add-directed-edge! g u (,out-edge-list g u) v)))
               ,@(when-bi
                   `(,add-directed-edge! g v (,in-edge-list g v) u))
               (unless
                 ,directed?
                 (,add-directed-edge! g v (,out-edge-list g v) u)
                 ,@(when-bi
                     `(,add-directed-edge! g u (,in-edge-list g u) v)))
               ret)))
         (define ,remove-edge!
           (lambda (g e)
             (,remove-edge2! g (,source g e) (,target g e))))
         (define ,remove-edge2!
           (lambda (g u v)
             (let ((ret (,remove-directed-edge!
                         g
                         u
                         (,out-edge-list g u)
                         v)))
               ,@(when-bi
                   `(,remove-directed-edge!
                     g
                     v
                     (,in-edge-list g v)
                     u))
               (unless
                 ,directed?
                 (,remove-directed-edge!
                  g
                  v
                  (,out-edge-list g v)
                  u)
                 ,@(when-bi
                     `(,remove-directed-edge!
                       g
                       u
                       (,in-edge-list g u)
                       v)))
               ret)))
         (define ,out-edges
           (lambda (g u)
             (,edges g u (,out-edge-list g u) #t)))
         (define ,out-edges*
           (lambda (g u)
             (,edges* g u (,out-edge-list g u) #t)))
         (define ,out-degree
           (lambda (g u) (,degree g u (,out-edge-list g u))))
         ,@(when-bi
             `(define ,in-edges
                (lambda (g u)
                  (,edges g u (,in-edge-list g u) #f)))
             `(define ,in-edges*
                (lambda (g u)
                  (,edges* g u (,in-edge-list g u) #f)))
             `(define ,in-degree
                (lambda (g u) (,degree g u (,in-edge-list g u)))))
         ,@(when-bi-or-dir
             `(define ,neighbours
                (lambda (g u)
                  (append
                    (map (lambda (e) (cons (,target g e) e))
                         (,out-edges g u))
                    (map (lambda (e) (cons (,source g e) e))
                         (,in-edges g u)))))
             `(define ,neighbours*
                (lambda (g u)
                  (stream-append
                    (stream-map
                      (lambda (e) (cons (,target g e) e))
                      (,out-edges* g u))
                    (stream-map
                      (lambda (e) (cons (,source g e) e))
                      (,in-edges* g u))))))
         ,@(map (lambda (algorithm)
                  `(,(pad "import-" algorithm)
                    ,GTYPE
                    ,streamed?
                    (,vertex-set?)
                    (,edge-set?)
                    ,directed?
                    ,bidirectional?))
                algorithms)))))
(define rgraph-doc-vl-vector #t)
(define-macro
  define-vl-vector
  (lambda (GTYPE
           VARGS
           streamed?
           bidirectional?
           vertex-properties
           get-vl)
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (define plus (if streamed? "*" ""))
    (define prefix-plus (if streamed? "stream-" ""))
    (define (when-bi . in-args)
      (if bidirectional? in-args '()))
    (define (unless-bi . in-args)
      (if bidirectional? '() in-args))
    (let* ((for-each+ (pad prefix-plus "for-each"))
           (map+ (pad prefix-plus "map"))
           (NP (length vertex-properties))
           (vl (pad GTYPE "-vertex-list"))
           (vl? (gensym))
           (make-vl (gensym))
           (vl-num (gensym))
           (set-vl-num! (gensym))
           (vl-vec (gensym))
           (set-vl-vec! (gensym))
           (rec (pad GTYPE "-vertex"))
           (rec? (gensym))
           (make-rec (gensym))
           (rec-out-edge-l (gensym))
           (set-rec-out-edge-l! (gensym))
           (rec-in-edge-l (gensym))
           (set-rec-in-edge-l! (gensym))
           (rec-props (gensym))
           (set-rec-props! (gensym))
           (vertex-set? (pad GTYPE "-vertex-set?"))
           (constructor (pad "##carp#make-" GTYPE "-vl"))
           (check-valid (gensym))
           (vertex-index (pad GTYPE "-vertex-index"))
           (add-vertex! (pad GTYPE "-add-vertex!"))
           (remove-vertex! (pad GTYPE "-remove-vertex!"))
           (vertex (pad GTYPE "-vertex"))
           (vertex-eq? (pad GTYPE "-vertex-eq?"))
           (out-edge-list
             (pad "##carp#" GTYPE "-out-edge-list"))
           (in-edge-list
             (pad "##carp#" GTYPE "-in-edge-list"))
           (num-vertices (pad GTYPE "-num-vertices"))
           (vertices (pad GTYPE "-vertices"))
           (vertices* (pad GTYPE "-vertices*"))
           (clear! (pad GTYPE "-clear!"))
           (el-constructor (pad "##carp#make-" GTYPE "-el"))
           (edge (pad GTYPE "-edge"))
           (in-edges+ (pad GTYPE "-in-edges" plus))
           (out-edges+ (pad GTYPE "-out-edges" plus))
           (remove-edge! (pad GTYPE "-remove-edge!"))
           (transform-vertices!
             (pad "##carp#" GTYPE "-transform-vertices!")))
      `(begin
         (define-macro ,vertex-set? (lambda () `#f))
         (define-record-type
           ,vl
           (,make-vl num vec)
           ,vl?
           (num ,vl-num ,set-vl-num!)
           (vec ,vl-vec ,set-vl-vec!))
         (define-record-printer
           ,vl
           (lambda (x p)
             (fprintf p "Vertex List vl-vector~%")
             (fprintf p "size	~S" (,vl-num x))))
         (define-record-type
           ,rec
           (,make-rec
            out-edge-l
            ,@(when-bi 'in-edge-l)
            props)
           ,rec?
           (out-edge-l ,rec-out-edge-l ,set-rec-out-edge-l!)
           ,@(when-bi
               `(in-edge-l ,rec-in-edge-l ,set-rec-in-edge-l!))
           (props ,rec-props ,set-rec-props!))
         (define-record-printer
           ,rec
           (lambda (x p) (fprintf p "Vertex ~S" x)))
         (define ,constructor
           (lambda (g) (,make-vl 0 (make-vector 0))))
         (define-macro
           ,check-valid
           (lambda (u num)
             `(rgraph-debug
                (when (or (not (integer? ,u)) (< ,u 0) (>= ,u ,num))
                      (error "Invalid vl-vector vertex descriptor")))))
         (define ,vertex-index
           (lambda (g v)
             (,check-valid v (,vl-num (,get-vl g)))
             v))
         ,@(let ((index -1))
             (map (lambda (prop)
                    (let ((getter (pad GTYPE "-" prop))
                          (setter! (pad "set-" GTYPE "-" prop "!"))
                          (pmap (pad GTYPE "-" prop "-map")))
                      (set! index (add1 index))
                      `(begin
                         (define ,getter
                           (lambda (g v)
                             (,check-valid v (,vl-num (,get-vl g)))
                             (vector-ref
                               (,rec-props
                                (vector-ref (,vl-vec (,get-vl g)) v))
                               ,index)))
                         (define ,setter!
                           (lambda (g v p)
                             (,check-valid v (,vl-num (,get-vl g)))
                             (vector-set!
                               (,rec-props
                                (vector-ref (,vl-vec (,get-vl g)) v))
                               ,index
                               p)))
                         (define ,pmap (cons ,getter ,setter!)))))
                  vertex-properties))
         (define ,add-vertex!
           (lambda (g . ignored)
             (let* ((vl (,get-vl g))
                    (num (,vl-num vl))
                    (vec (,vl-vec vl))
                    (length (vector-length vec))
                    (rec (,make-rec
                          (,el-constructor g)
                          ,@(when-bi `(,el-constructor g))
                          (make-vector ,NP #f))))
               (cond ((< num length))
                     ((zero? length) (set! vec (make-vector 1 #f)))
                     (else
                      (set! vec
                        (vector-resize
                          vec
                          (max 2 (quotient (* 17 length) 10))
                          #f))))
               (vector-set! vec num rec)
               (,set-vl-vec! vl vec)
               (,set-vl-num! vl (add1 num))
               num)))
         (define ,remove-vertex!
           (lambda (g u)
             (let* ((vl (,get-vl g))
                    (num (,vl-num vl))
                    (num-- (sub1 num))
                    (vec (,vl-vec vl))
                    (length (vector-length vec))
                    (down (quotient (* 10 length) 17)))
               (,check-valid u num)
               (,for-each+
                (lambda (u^v) (,remove-edge! g u^v))
                (,out-edges+ g u))
               ,@(when-bi
                   `(,for-each+
                     (lambda (v^u) (,remove-edge! g v^u))
                     (,in-edges+ g u)))
               ,@(unless-bi
                   `(do ((v 0 (add1 v)))
                        ((>= v num))
                      (let ((v^u (,edge g v u)))
                        (when v^u (,remove-edge! g v^u)))))
               (cond ((< num down)
                      (set! vec (vector-resize vec down))
                      (,set-vl-vec! vl vec)))
               (let loop ((n u))
                 (cond ((> n num--))
                       ((= n num--) (vector-set! vec n #f))
                       (else
                        (vector-set! vec n (vector-ref vec (add1 n)))
                        (loop (add1 n)))))
               (,set-vl-num! vl (sub1 num))
               (do ((i 0 (add1 i)))
                   ((>= i num--))
                 (,transform-vertices!
                  (lambda (v) (if (> v u) (sub1 v) v))
                  g
                  i)))))
         (define ,vertex
           (lambda (g n)
             (let* ((vl (,get-vl g)) (num (,vl-num vl)))
               (,check-valid n num)
               n)))
         (define ,vertex-eq?
           (lambda (g u v)
             (,check-valid u (,vl-num (,get-vl g)))
             (,check-valid v (,vl-num (,get-vl g)))
             (= u v)))
         (define ,out-edge-list
           (lambda (g u)
             (let* ((vl (,get-vl g))
                    (num (,vl-num vl))
                    (vec (,vl-vec vl)))
               (,check-valid u num)
               (,rec-out-edge-l (vector-ref vec u)))))
         ,@(when-bi
             `(define ,in-edge-list
                (lambda (g u)
                  (let* ((vl (,get-vl g))
                         (num (,vl-num vl))
                         (vec (,vl-vec vl)))
                    (,check-valid u num)
                    (,rec-in-edge-l (vector-ref vec u))))))
         (define ,vertices
           (lambda (g)
             (let* ((vl (,get-vl g)) (num (,vl-num vl)))
               (let iter ((i 0))
                 (cond ((= i num) '())
                       (else (cons i (iter (add1 i)))))))))
         (define ,vertices*
           (lambda (g)
             (let* ((vl (,get-vl g)) (num (,vl-num vl)))
               (let iter ((i 0))
                 (stream-delay
                   (cond ((= i num) stream-null)
                         (else (stream-cons i (iter (add1 i))))))))))
         (define ,num-vertices
           (lambda (g)
             (let* ((vl (,get-vl g)) (num (,vl-num vl))) num)))
         (define ,clear!
           (lambda (g)
             (let ((vl (,get-vl g)))
               (,set-vl-num! vl 0)
               (,set-vl-vec! vl (make-vector 0)))))))))
(define rgraph-doc-vl-hash #t)
(define-macro
  define-vl-hash
  (lambda (GTYPE
           VARGS
           streamed?
           bidirectional?
           vertex-properties
           get-vl)
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (define plus (if streamed? "*" ""))
    (define prefix-plus (if streamed? "stream-" ""))
    (define (when-bi . in-args)
      (if bidirectional? in-args '()))
    (define (unless-bi . in-args)
      (if bidirectional? '() in-args))
    (let* ((for-each+ (pad prefix-plus "for-each"))
           (map+ (pad prefix-plus "map"))
           (NP (length vertex-properties))
           (vl (pad GTYPE "-vertex-list"))
           (vl? (gensym))
           (make-vl (gensym))
           (vl-table (gensym))
           (set-vl-table! (gensym))
           (vl-max-index (gensym))
           (set-vl-max-index! (gensym))
           (rec (pad GTYPE "-vertex"))
           (rec? (gensym))
           (make-rec (gensym))
           (rec-index (gensym))
           (set-rec-index! (gensym))
           (rec-out-edge-l (gensym))
           (set-rec-out-edge-l! (gensym))
           (rec-in-edge-l (gensym))
           (set-rec-in-edge-l! (gensym))
           (rec-props (gensym))
           (set-rec-props! (gensym))
           (vertex-set? (pad GTYPE "-vertex-set?"))
           (constructor (pad "##carp#make-" GTYPE "-vl"))
           (check-valid (gensym))
           (vertex-index (pad GTYPE "-vertex-index"))
           (add-vertex! (pad GTYPE "-add-vertex!"))
           (remove-vertex! (pad GTYPE "-remove-vertex!"))
           (vertex (pad GTYPE "-vertex"))
           (vertex-eq? (pad GTYPE "-vertex-eq?"))
           (out-edge-list
             (pad "##carp#" GTYPE "-out-edge-list"))
           (in-edge-list
             (pad "##carp#" GTYPE "-in-edge-list"))
           (num-vertices (pad GTYPE "-num-vertices"))
           (vertices (pad GTYPE "-vertices"))
           (vertices* (pad GTYPE "-vertices*"))
           (clear! (pad GTYPE "-clear!"))
           (el-constructor (pad "##carp#make-" GTYPE "-el"))
           (edge (pad GTYPE "-edge"))
           (in-edges+ (pad GTYPE "-in-edges" plus))
           (out-edges+ (pad GTYPE "-out-edges" plus))
           (remove-edge! (pad GTYPE "-remove-edge!"))
           (transform-vertices!
             (pad "##carp#" GTYPE "-transform-vertices!")))
      `(begin
         (define-macro ,vertex-set? (lambda () `#t))
         (define-record-type
           ,vl
           (,make-vl table max-index)
           ,vl?
           (table ,vl-table ,set-vl-table!)
           (max-index ,vl-max-index ,set-vl-max-index!))
         (define-record-printer
           ,vl
           (lambda (x p)
             (fprintf p "Vertex List vl-hash~%")
             (fprintf
               p
               "size	~S"
               (hash-table-count (,vl-table x)))))
         (define-record-type
           ,rec
           (,make-rec
            index
            out-edge-l
            ,@(when-bi 'in-edge-l)
            props)
           ,rec?
           (index ,rec-index ,set-rec-index!)
           (out-edge-l ,rec-out-edge-l ,set-rec-out-edge-l!)
           ,@(when-bi
               `(in-edge-l ,rec-in-edge-l ,set-rec-in-edge-l!))
           (props ,rec-props ,set-rec-props!))
         (define-record-printer
           ,rec
           (lambda (x p) (fprintf p "Vertex ~S" x)))
         (define ,constructor
           (lambda (g)
             (,make-vl (make-hash-table ,@VARGS) 0)))
         (define-macro ,check-valid (lambda (u) #t))
         (define ,vertex-index
           (lambda (g v)
             (let* ((vl (,get-vl g))
                    (table (,vl-table vl))
                    (rec (hash-table-ref table v)))
               (,rec-index rec))
             v))
         ,@(let ((index -1))
             (map (lambda (prop)
                    (let ((getter (pad GTYPE "-" prop))
                          (setter! (pad "set-" GTYPE "-" prop "!"))
                          (pmap (pad GTYPE "-" prop "-map")))
                      (set! index (add1 index))
                      `(begin
                         (define ,getter
                           (lambda (g v)
                             (,check-valid v)
                             (vector-ref
                               (,rec-props
                                (hash-table-ref (,vl-table (,get-vl g)) v))
                               ,index)))
                         (define ,setter!
                           (lambda (g v p)
                             (,check-valid v)
                             (vector-set!
                               (,rec-props
                                (hash-table-ref (,vl-table (,get-vl g)) v))
                               ,index
                               p)))
                         (define ,pmap (cons ,getter ,setter!)))))
                  vertex-properties))
         (define ,add-vertex!
           (lambda (g key . ignored)
             (let* ((vl (,get-vl g))
                    (table (,vl-table vl))
                    (rec (hash-table-ref table key)))
               (unless
                 rec
                 (let ((index (,vl-max-index vl)))
                   (hash-table-set!
                     table
                     key
                     (,make-rec
                      index
                      (,el-constructor g)
                      ,@(when-bi `(,el-constructor g))
                      (make-vector ,NP #f)))
                   (,set-vl-max-index! vl (add1 index))))
               key)))
         (define ,remove-vertex!
           (lambda (g u)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (,check-valid u)
               (,for-each+
                (lambda (u^v) (,remove-edge! g u^v))
                (,out-edges+ g u))
               ,@(when-bi
                   `(,for-each+
                     (lambda (v^u) (,remove-edge! g v^u))
                     (,in-edges+ g u)))
               ,@(unless-bi
                   `(do ((v 0 (add1 v)))
                        ((>= v num))
                      (let ((v^u (,edge g v u)))
                        (when v^u (,remove-edge! g v^u)))))
               (hash-table-remove! table u))))
         (define ,vertex-eq?
           (lambda (g u v)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (,check-valid u)
               (,check-valid v)
               (,(if (pair? VARGS) (car VARGS) 'eq?) u v))))
         (define ,out-edge-list
           (lambda (g u)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (,check-valid u)
               (,rec-out-edge-l (hash-table-ref table u)))))
         ,@(when-bi
             `(define ,in-edge-list
                (lambda (g u)
                  (let* ((vl (,get-vl g)) (table (,vl-table vl)))
                    (,check-valid u)
                    (,rec-in-edge-l (hash-table-ref table u))))))
         (define ,vertices
           (lambda (g)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (hash-table-map (lambda (k v) k) table))))
         (define ,vertices*
           (lambda (g)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (stream-map
                 (lambda (kv) (car kv))
                 (hash-table->stream table)))))
         (define ,num-vertices
           (lambda (g)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (hash-table-count table))))
         (define ,clear!
           (lambda (g)
             (let* ((vl (,get-vl g)) (table (,vl-table vl)))
               (clear-hash-table! table))))))))
(define rgraph-doc-el-slist #t)
(define-macro
  define-el-slist
  (lambda (GTYPE
           VARGS
           streamed?
           bidirectional?
           edge-properties)
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (define (when-bi . in-args)
      (if bidirectional? in-args '()))
    (let* ((NP (length edge-properties))
           (el (pad GTYPE "-edge-list"))
           (el? (gensym))
           (make-el (gensym))
           (el-tlist (gensym))
           (set-el-tlist! (gensym))
           (el-tnum (gensym))
           (set-el-tnum! (gensym))
           (rec (pad GTYPE "-edge"))
           (rec? (gensym))
           (make-rec (gensym))
           (rec-target (gensym))
           (set-rec-target! (gensym))
           (rec-props (gensym))
           (set-rec-props! (gensym))
           (edge-set? (pad GTYPE "-edge-set?"))
           (constructor (pad "##carp#make-" GTYPE "-el"))
           (add-directed-edge!
             (pad "##carp#" GTYPE "-add-directed-edge!"))
           (remove-directed-edge!
             (pad "##carp#" GTYPE "-remove-directed-edge!"))
           (edge (pad GTYPE "-edge"))
           (source (pad GTYPE "-source"))
           (target (pad GTYPE "-target"))
           (edges (pad "##carp#" GTYPE "-edges"))
           (edges* (pad "##carp#" GTYPE "-edges*"))
           (edge-at (pad GTYPE "-edge-at"))
           (degree (pad "##carp#" GTYPE "-degree"))
           (transform-vertices!
             (pad "##carp#" GTYPE "-transform-vertices!"))
           (out-edge-list
             (pad "##carp#" GTYPE "-out-edge-list"))
           (in-edge-list
             (pad "##carp#" GTYPE "-in-edge-list"))
           (vertex-eq? (pad GTYPE "-vertex-eq?")))
      `(begin
         (define-macro ,edge-set? (lambda () `#f))
         (define-record-type
           ,el
           (,make-el tlist tnum)
           ,el?
           (tlist ,el-tlist ,set-el-tlist!)
           (tnum ,el-tnum ,set-el-tnum!))
         (define-record-printer
           ,el
           (lambda (x p)
             (fprintf p "Edge List el-slist~%")
             (fprintf p "degree	~S" (,el-tnum x))))
         (define-record-type
           ,rec
           (,make-rec target props)
           ,rec?
           (target ,rec-target ,set-rec-target!)
           (props ,rec-props ,set-rec-props!))
         (define-record-printer
           ,rec
           (lambda (x p)
             (fprintf
               p
               "Edge | target vertex	~S"
               (,rec-target x))))
         (define ,constructor
           (lambda (g) (,make-el '() 0)))
         ,@(let ((index -1))
             (map (lambda (prop)
                    (let ((getter (pad GTYPE "-" prop))
                          (setter! (pad "set-" GTYPE "-" prop "!"))
                          (pmap (pad GTYPE "-" prop "-map")))
                      (set! index (add1 index))
                      `(begin
                         (define ,getter
                           (lambda (g e)
                             (vector-ref (,rec-props (cdr e)) ,index)))
                         (define ,setter!
                           (lambda (g e p)
                             (vector-set! (,rec-props (cdr e)) ,index p)))
                         (define ,pmap (cons ,getter ,setter!)))))
                  edge-properties))
         (define ,add-directed-edge!
           (lambda (g u u-el v)
             (let* ((u-tlist (,el-tlist u-el))
                    (v-rec (,make-rec v (make-vector ,NP #f))))
               (set! u-tlist (cons v-rec u-tlist))
               (,set-el-tlist! u-el u-tlist)
               (,set-el-tnum! u-el (add1 (,el-tnum u-el)))
               (cons u v-rec))))
         (define ,remove-directed-edge!
           (lambda (g u u-el v)
             (let* ((u-tlist (,el-tlist u-el)))
               (let find ((tlist u-tlist) (predecessor #f))
                 (cond ((null? tlist)
                        (error "Could not remove directed edge"
                               g
                               u
                               u-el
                               v))
                       ((,vertex-eq? g v (,rec-target (car tlist)))
                        (cond (predecessor (set-cdr! predecessor (cdr tlist)))
                              (else (,set-el-tlist! u-el (cdr tlist))))
                        (,set-el-tnum! u-el (sub1 (,el-tnum u-el)))
                        #t)
                       (else (find (cdr tlist) tlist)))))))
         (define ,edge
           (lambda (g u v)
             (let* ((u-el (,out-edge-list g u))
                    (u-tlist (,el-tlist u-el)))
               (let find ((tlist u-tlist))
                 (cond ((null? tlist) #f)
                       ((,vertex-eq? g v (,rec-target (car tlist)))
                        (cons u (car tlist)))
                       (else (find (cdr tlist))))))))
         (define ,source (lambda (g e) (car e)))
         (define ,target
           (lambda (g e) (,rec-target (cdr e))))
         (define ,edges
           (lambda (g u u-el out?)
             (map (lambda (v-rec)
                    (if out?
                      (cons u v-rec)
                      (,edge g (,rec-target v-rec) u)))
                  (,el-tlist u-el))))
         (define ,edges*
           (lambda (g u u-el out?)
             (stream-map
               (lambda (v-rec)
                 (if out?
                   (cons u v-rec)
                   (,edge g (,rec-target v-rec) u)))
               (list->stream (,el-tlist u-el)))))
         (define ,edge-at
           (lambda (g u n)
             (let* ((u-el (,out-edge-list g u))
                    (u-tlist (,el-tlist u-el))
                    (u-tnum (,el-tnum u-el))
                    (where (- u-tnum n 1)))
               (when (< where)
                     (error "Invalid el-slist edge index"))
               (cons u (list-ref u-tlist where)))))
         (define ,degree
           (lambda (g u u-el) (,el-tnum u-el)))
         (define ,transform-vertices!
           (lambda (proc g u)
             (define (x v-rec)
               (,set-rec-target!
                v-rec
                (proc (,rec-target v-rec))))
             (for-each x (,el-tlist (,out-edge-list g u)))
             ,@(when-bi
                 `(for-each x (,el-tlist (,in-edge-list g u))))))))))
(define rgraph-doc-el-hash #t)
(define-macro
  define-el-hash
  (lambda (GTYPE
           VARGS
           streamed?
           bidirectional?
           edge-properties)
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (define (when-bi . in-args)
      (if bidirectional? in-args '()))
    (let* ((NP (length edge-properties))
           (el (pad GTYPE "-edge-list"))
           (el? (gensym))
           (make-el (gensym))
           (el-thash (gensym))
           (set-el-thash! (gensym))
           (rec (pad GTYPE "-edge"))
           (rec? (gensym))
           (make-rec (gensym))
           (rec-target (gensym))
           (set-rec-target! (gensym))
           (rec-props (gensym))
           (set-rec-props! (gensym))
           (pre-constructor
             (pad "##carp#make-" GTYPE "-pre-el"))
           (edge-set? (pad GTYPE "-edge-set?"))
           (constructor (pad "##carp#make-" GTYPE "-el"))
           (add-directed-edge!
             (pad "##carp#" GTYPE "-add-directed-edge!"))
           (remove-directed-edge!
             (pad "##carp#" GTYPE "-remove-directed-edge!"))
           (edge (pad GTYPE "-edge"))
           (source (pad GTYPE "-source"))
           (target (pad GTYPE "-target"))
           (edges (pad "##carp#" GTYPE "-edges"))
           (edges* (pad "##carp#" GTYPE "-edges*"))
           (degree (pad "##carp#" GTYPE "-degree"))
           (transform-vertices!
             (pad "##carp#" GTYPE "-transform-vertices!"))
           (out-edge-list
             (pad "##carp#" GTYPE "-out-edge-list"))
           (in-edge-list
             (pad "##carp#" GTYPE "-in-edge-list"))
           (vertex-eq? (pad GTYPE "-vertex-eq?")))
      `(begin
         (define-macro ,edge-set? (lambda () `#t))
         (define-record-type
           ,el
           (,make-el thash)
           ,el?
           (thash ,el-thash ,set-el-thash!))
         (define-record-printer
           ,el
           (lambda (x p)
             (fprintf p "Edge List el-hash~%")
             (fprintf
               p
               "degree	~S"
               (hash-table-count (,el-thash x)))))
         (define-record-type
           ,rec
           (,make-rec target props)
           ,rec?
           (target ,rec-target ,set-rec-target!)
           (props ,rec-props ,set-rec-props!))
         (define-record-printer
           ,rec
           (lambda (x p)
             (fprintf
               p
               "Edge | target vertex	~S"
               (,rec-target x))))
         (define ,pre-constructor
           (lambda (g)
             (make-hash-table
               (lambda (a b) (,vertex-eq? g a b)))))
         (define ,constructor
           (lambda (g) (,make-el (,pre-constructor g))))
         ,@(let ((index -1))
             (map (lambda (prop)
                    (let ((getter (pad GTYPE "-" prop))
                          (setter! (pad "set-" GTYPE "-" prop "!"))
                          (pmap (pad GTYPE "-" prop "-map")))
                      (set! index (add1 index))
                      `(begin
                         (define ,getter
                           (lambda (g e)
                             (vector-ref (,rec-props (cdr e)) ,index)))
                         (define ,setter!
                           (lambda (g e p)
                             (vector-set! (,rec-props (cdr e)) ,index p)))
                         (define ,pmap (cons ,getter ,setter!)))))
                  edge-properties))
         (define ,add-directed-edge!
           (lambda (g u u-el v)
             (let* ((u-thash (,el-thash u-el))
                    (v-rec (hash-table-ref u-thash v)))
               (unless
                 v-rec
                 (set! v-rec (,make-rec v (make-vector ,NP #f)))
                 (hash-table-set! u-thash v v-rec))
               (cons u v-rec))))
         (define ,remove-directed-edge!
           (lambda (g u u-el v)
             (let* ((u-thash (,el-thash u-el)))
               (unless
                 (hash-table-remove! u-thash v)
                 (error "Could not remove directed edge"
                        g
                        u
                        u-el
                        v)))))
         (define ,edge
           (lambda (g u v)
             (let* ((u-el (,out-edge-list g u))
                    (u-thash (,el-thash u-el))
                    (v-rec (hash-table-ref u-thash v)))
               (and v-rec (cons u v-rec)))))
         (define ,source (lambda (g e) (car e)))
         (define ,target
           (lambda (g e) (,rec-target (cdr e))))
         (define ,edges
           (lambda (g u u-el out?)
             (hash-table-map
               (lambda (v v-rec)
                 (if out? (cons u v-rec) (,edge g v u)))
               (,el-thash u-el))))
         (define ,edges*
           (lambda (g u u-el out?)
             (stream-map
               (lambda (v.v-rec)
                 (if out?
                   (cons u (cdr v.v-rec))
                   (,edge g (car v.v-rec) u)))
               (hash-table->stream (,el-thash u-el)))))
         (define ,degree
           (lambda (g u u-el)
             (hash-table-count (,el-thash u-el))))
         (define ,transform-vertices!
           (lambda (proc g u)
             (define new-out-thash (,pre-constructor g))
             ,@(when-bi
                 `(define new-in-thash (,pre-constructor g)))
             (define (x! new-thash v v-rec)
               (,set-rec-target!
                v-rec
                (proc (,rec-target v-rec)))
               (hash-table-set! new-thash (proc v) v-rec))
             (hash-table-for-each
               (lambda (v v-rec) (x! new-out-thash v v-rec))
               (,el-thash (,out-edge-list g u)))
             (,set-el-thash!
              (,out-edge-list g u)
              new-out-thash)
             ,@(when-bi
                 `(hash-table-for-each
                    (lambda (v v-rec) (x! new-in-thash v v-rec))
                    (,el-thash (,in-edge-list g u)))
                 `(,set-el-thash! (,in-edge-list g u) new-in-thash))))))))
(define rgraph-doc-visitors #t)
(define rgraph-doc-properties #t)
(define rgraph-doc-let-rgraph #t)
(define-macro
  let-rgraph
  (lambda (GTYPE . rest)
    (define plus
      (cond-expand (srfi-40 "*") (else "")))
    (define prefix-plus
      (cond-expand (srfi-40 "stream-") (else "")))
    (define (pad . args)
      (string->symbol
        (apply string-append
               (map (lambda (a)
                      (cond ((string? a) a)
                            ((symbol? a) (symbol->string a))
                            (else "UNKNOWN_PAD_SYMBOL")))
                    args))))
    (let ((for-each+ (pad prefix-plus "for-each"))
          (map+ (pad prefix-plus "map"))
          (make-graph (pad "make-" GTYPE))
          (add-edge! (pad GTYPE "-add-edge!"))
          (remove-edge! (pad GTYPE "-remove-edge!"))
          (remove-edge2! (pad GTYPE "-remove-edge2!"))
          (out-edges (pad GTYPE "-out-edges"))
          (out-edges* (pad GTYPE "-out-edges*"))
          (out-edges+ (pad GTYPE "-out-edges" plus))
          (out-degree (pad GTYPE "-out-degree"))
          (in-edges (pad GTYPE "-in-edges"))
          (in-edges* (pad GTYPE "-in-edges*"))
          (in-edges+ (pad GTYPE "-in-edges" plus))
          (in-degree (pad GTYPE "-in-degree"))
          (vertex-index (pad GTYPE "-vertex-index"))
          (add-vertex! (pad GTYPE "-add-vertex!"))
          (remove-vertex! (pad GTYPE "-remove-vertex!"))
          (vertex (pad GTYPE "-vertex"))
          (vertex-eq? (pad GTYPE "-vertex-eq?"))
          (num-vertices (pad GTYPE "-num-vertices"))
          (vertices (pad GTYPE "-vertices"))
          (vertices* (pad GTYPE "-vertices*"))
          (vertices+ (pad GTYPE "-vertices" plus))
          (clear! (pad GTYPE "-clear!"))
          (edge (pad GTYPE "-edge"))
          (source (pad GTYPE "-source"))
          (target (pad GTYPE "-target"))
          (edge-at (pad GTYPE "-edge-at")))
      `(let ((for-each+ ,for-each+)
             (map+ ,map+)
             (make-graph ,make-graph)
             (add-edge! ,add-edge!)
             (remove-edge! ,remove-edge!)
             (remove-edge2! ,remove-edge2!)
             (out-edges ,out-edges)
             (out-edges* ,out-edges*)
             (out-edges+ ,out-edges+)
             (out-degree ,out-degree)
             (in-edges ,in-edges)
             (in-edges* ,in-edges*)
             (in-edges+ ,in-edges+)
             (in-degree ,in-degree)
             (vertex-index ,vertex-index)
             (add-vertex! ,add-vertex!)
             (remove-vertex! ,remove-vertex!)
             (vertex ,vertex)
             (vertex-eq? ,vertex-eq?)
             (num-vertices ,num-vertices)
             (vertices ,vertices)
             (vertices* ,vertices*)
             (vertices+ ,vertices+)
             (clear! ,clear!)
             (edge ,edge)
             (source ,source)
             (target ,target)
             (edge-at ,edge-at))
         ,@rest))))
(define rgraph-doc-fill-graph! #t)
(define-macro
  (import-fill-graph!
    GTYPE
    streamed?
    vertex-set?
    edge-set?
    directed?
    bidirectional?)
  (define (pad . args)
    (string->symbol
      (apply string-append
             (map (lambda (a)
                    (cond ((string? a) a)
                          ((symbol? a) (symbol->string a))
                          (else "UNKNOWN_PAD_SYMBOL")))
                  args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (let ((algorithm (pad GTYPE "-fill-graph!"))
        (vertex-eq? (pad GTYPE "-vertex-eq?"))
        (add-vertex! (pad GTYPE "-add-vertex!"))
        (add-edge! (pad GTYPE "-add-edge!")))
    `(define ,algorithm
       (lambda (g edges set-vertex-name!)
         (define h (make-hash-table))
         (for-each
           (lambda (edge)
             (let* ((v1 (car edge))
                    (v2 (cdr edge))
                    (vertex1 (hash-table-ref h v1))
                    (vertex2 (hash-table-ref h v2)))
               (cond ((not vertex1)
                      (set! vertex1 (,add-vertex! g v1))
                      (when set-vertex-name!
                            (set-vertex-name! g vertex1 v1))
                      (hash-table-set! h v1 vertex1)))
               (cond ((not vertex2)
                      (set! vertex2 (,add-vertex! g v2))
                      (when set-vertex-name!
                            (set-vertex-name! g vertex2 v2))
                      (hash-table-set! h v2 vertex2)))
               (,add-edge! g vertex1 vertex2)))
           edges)
         g))))
(define rgraph-doc-dfs #t)
(define rgraph-doc-dfs #t)
(define-macro
  (import-depth-first-search
    GTYPE
    streamed?
    vertex-set?
    edge-set?
    directed?
    bidirectional?)
  (define (pad . args)
    (string->symbol
      (apply string-append
             (map (lambda (a)
                    (cond ((string? a) a)
                          ((symbol? a) (symbol->string a))
                          (else "UNKNOWN_PAD_SYMBOL")))
                  args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  `(begin
     ,@(map (lambda (streamed?)
              (define plus (if streamed? "*" ""))
              (define prefix-plus (if streamed? "stream-" ""))
              (let ((for-each+ (pad prefix-plus "for-each"))
                    (map+ (pad prefix-plus "map"))
                    (algorithm+
                      (pad GTYPE "-depth-first-search" plus))
                    (vertex-eq? (pad GTYPE "-vertex-eq?"))
                    (target (pad GTYPE "-target"))
                    (num-vertices (pad GTYPE "-num-vertices"))
                    (vertices+ (pad GTYPE "-vertices" plus))
                    (out-edges+ (pad GTYPE "-out-edges" plus)))
                `(define ,algorithm+
                   (lambda (g dfs-visitor color-map starting-vertex)
                     (let* ((dfs-visitor
                              (if dfs-visitor dfs-visitor (null-dfs-visitor)))
                            (color-map
                              (or color-map
                                  (prop-external-hash
                                    (lambda (v1 v2) (,vertex-eq? g v1 v2))
                                    (,num-vertices g))))
                            (color (car color-map))
                            (set-color! (cdr color-map))
                            (init (dfs-visitor-init dfs-visitor))
                            (start (dfs-visitor-start dfs-visitor))
                            (discover (dfs-visitor-discover dfs-visitor))
                            (examine (dfs-visitor-examine dfs-visitor))
                            (tree-edge (dfs-visitor-tree-edge dfs-visitor))
                            (back-edge (dfs-visitor-back-edge dfs-visitor))
                            (forward-or-cross-edge
                              (dfs-visitor-forward-or-cross-edge dfs-visitor))
                            (finish (dfs-visitor-finish dfs-visitor)))
                       (define (depth-first-visit u)
                         (set-color! g u 'GRAY)
                         (when discover (discover g u))
                         (,for-each+
                          (lambda (u->v)
                            (call/cc
                              (lambda (escape)
                                (let ((v (,target g u->v)))
                                  (when examine
                                        (unless (examine g v) (escape #t)))
                                  (case (color g v)
                                    ((WHITE)
                                     (when tree-edge (tree-edge g u->v))
                                     (depth-first-visit v))
                                    ((GRAY)
                                     (when back-edge (back-edge g u->v)))
                                    ((BLACK)
                                     (when forward-or-cross-edge
                                           (forward-or-cross-edge g u->v)))
                                    (else
                                     (error "Invalid color" (color g v))))))))
                          (,out-edges+ g u))
                         (set-color! g u 'BLACK)
                         (when finish (finish g u))
                         #f)
                       (cond ((and (pair? starting-vertex)
                                   (eq? 'depth-first-visit
                                        (car starting-vertex)))
                              (depth-first-visit (cdr starting-vertex)))
                             (else
                              (,for-each+
                               (lambda (u)
                                 (set-color! g u 'WHITE)
                                 (when init (init g u)))
                               (,vertices+ g))
                              (when starting-vertex
                                    (depth-first-visit starting-vertex))
                              (,for-each+
                               (lambda (u)
                                 (when (eq? (color g u) 'WHITE)
                                       (depth-first-visit u)))
                               (,vertices+ g))
                              #f)))))))
            (if streamed? (list #f #t) (list #f)))))
(define rgraph-doc-dfv #t)
(define-macro
  (import-depth-first-visit
    GTYPE
    streamed?
    vertex-set?
    edge-set?
    directed?
    bidirectional?)
  `(begin
     ,@(map (lambda (streamed?)
              (define plus (if streamed? "*" ""))
              (define prefix-plus (if streamed? "stream-" ""))
              (let ((algorithm+
                      (pad GTYPE "-depth-first-visit" plus))
                    (depth-first-search+
                      (pad GTYPE "-depth-first-search" plus)))
                `(define ,algorithm
                   (lambda (g dfs-visitor color-map u)
                     (,depth-first-search+
                      g
                      dfs-visitor
                      color-map
                      (cons 'depth-first-visit u))))))
            (if streamed? (list #f #t) (list #f)))))
(define rgraph-doc-topsort #t)
(define rgraph-doc-topsort #t)
(define rgraph-doc-topsort* #t)
(define-macro
  (import-topological-sort
    GTYPE
    streamed?
    vertex-set?
    edge-set?
    directed?
    bidirectional?)
  (define (pad . args)
    (string->symbol
      (apply string-append
             (map (lambda (a)
                    (cond ((string? a) a)
                          ((symbol? a) (symbol->string a))
                          (else "UNKNOWN_PAD_SYMBOL")))
                  args))))
  `(begin
     ,@(map (lambda (streamed?)
              (define plus (if streamed? "*" ""))
              (define prefix-plus (if streamed? "stream-" ""))
              (define (when-s . in-args)
                (if streamed? in-args '()))
              (define (unless-s . in-args)
                (if streamed? '() in-args))
              (let ((algorithm+ (pad GTYPE "-topological-sort" plus))
                    (depth-first-search+
                      (pad GTYPE "-depth-first-search" plus)))
                `(define ,algorithm+
                   (lambda (g)
                     ,@(unless-s
                         `(define first #f)
                         `(define last #f)
                         `(define (add-tail! u)
                            (cond (last
                                   (set-cdr! last (cons u '()))
                                   (set! last (cdr last)))
                                  (else
                                   (set! first (cons u '()))
                                   (set! last first)))))
                     (define visitor-LCS #f)
                     (define covisitor-LCS
                       (lambda (u)
                         (let loop ()
                           ,@(unless-s `(add-tail! u))
                           (set! u (covisitor-resume visitor-LCS #f))
                           (loop))))
                     (define covisitor-resume
                       (lambda (dest val)
                         (call/cc
                           (lambda (k) (set! covisitor-LCS k) (dest val)))))
                     (define (topo-sort-visitor)
                       (define visitor (null-dfs-visitor))
                       (define visitor-resume
                         (lambda (dest val)
                           (call/cc
                             (lambda (k) (set! visitor-LCS k) (dest val)))))
                       (set-dfs-visitor-back-edge!
                         visitor
                         (lambda (g uv)
                           (error "Not a directed, acyclic graph")))
                       (set-dfs-visitor-finish!
                         visitor
                         (lambda (g u) (visitor-resume covisitor-LCS u)))
                       visitor)
                     ,@(when-s
                         `(set! visitor-LCS
                            (lambda (val)
                              (,depth-first-search+
                               g
                               (topo-sort-visitor)
                               #f
                               #f)
                              #f))
                         `(call/cc
                            (lambda (escape)
                              (let iterate ((start #t))
                                (stream-delay
                                  (let ((result
                                          (covisitor-resume visitor-LCS #f)))
                                    (if result
                                      (stream-cons result (iterate #f))
                                      (escape stream-null))))))))
                     ,@(unless-s
                         `(,depth-first-search+
                           g
                           (topo-sort-visitor)
                           #f
                           #f)
                         `first)))))
            (if streamed? (list #f #t) (list #f)))))
(define rgraph-doc-part-fidmat #t)
(define fidmat-check #t)
(define fidmat-debug #t)
(define-record partition-fm cost balance vertex)
(define-macro
  (import-partition-fidmat
    GTYPE
    streamed?
    vertex-set?
    edge-set?
    directed?
    bidirectional?)
  (define (pad . args)
    (string->symbol
      (apply string-append
             (map (lambda (a)
                    (cond ((string? a) a)
                          ((symbol? a) (symbol->string a))
                          (else "UNKNOWN_PAD_SYMBOL")))
                  args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (define check
    (pad GTYPE "-partition-fidmat-check"))
  (define debug
    (pad GTYPE "-partition-fidmat-debug"))
  `(begin
     (define ,check #f)
     (define ,debug #f)
     ,@(map (lambda (streamed?)
              (define plus (if streamed? "*" ""))
              (define prefix-plus (if streamed? "stream-" ""))
              (define for-each+ (pad prefix-plus "for-each"))
              (define map+ (pad prefix-plus "map"))
              (define null?+ (pad prefix-plus "null?"))
              (define car+ (pad prefix-plus "car"))
              (define cdr+ (pad prefix-plus "cdr"))
              (define algorithm+
                (pad GTYPE "-partition-fidmat" plus))
              (define vertex-eq? (pad GTYPE "-vertex-eq?"))
              (define add-vertex! (pad GTYPE "-add-vertex!"))
              (define add-edge! (pad GTYPE "-add-edge!"))
              (define remove-edge! (pad GTYPE "-remove-edge!"))
              (define clear! (pad GTYPE "-clear!"))
              (define vertex (pad GTYPE "-vertex"))
              (define source (pad GTYPE "-source"))
              (define target (pad GTYPE "-target"))
              (define num-vertices (pad GTYPE "-num-vertices"))
              (define vertices (pad GTYPE "-vertices"))
              (define vertices+ (pad GTYPE "-vertices" plus))
              (define out-edges+ (pad GTYPE "-out-edges" plus))
              (define neighbours+
                (pad GTYPE "-neighbours" plus))
              (define out-degree (pad GTYPE "-out-degree"))
              `(define ,algorithm+
                 (lambda (g
                          p-map
                          gain
                          d-map
                          working-g
                          working-d-map
                          cost
                          balance
                          weight
                          criterion
                          split-level)
                   (let* ((L (,num-vertices g))
                          (L1 (quotient
                                (* (car weight) L)
                                (+ (car weight) (cdr weight))))
                          (DEGREE 0)
                          (p (car p-map))
                          (set-p! (cdr p-map))
                          (d (car d-map))
                          (set-d! (cdr d-map))
                          (working-d (car working-d-map))
                          (set-working-d! (cdr working-d-map)))
                     (define (vertex-at gain)
                       (if ,vertex-set?
                         gain
                         (,vertex working-g (+ gain DEGREE))))
                     (,for-each+
                      (lambda (u)
                        (set-p! g u #t)
                        (let ((d (,out-degree g u)))
                          (when (> d DEGREE) (set! DEGREE d))))
                      (,vertices+ g))
                     (set! DEGREE (* 2 DEGREE))
                     (let loop1 ((n#t L) (n#f 0))
                       (when (call/cc
                               (lambda (escape)
                                 (,for-each+
                                  (lambda (u)
                                    (let ((part (p g u)))
                                      (when (and part
                                                 (< (random n#t) (- n#t L1)))
                                            (set! n#f (add1 n#f))
                                            (if (> n#f L1) (escape #f))
                                            (set-p! g u #f))))
                                  (,vertices+ g))
                                 #t))
                             (loop1 (- L n#f) n#f)))
                     (let loop1 ((initial-cost (cost)))
                       (let ((initial-p
                               (map (lambda (x) (p g x)) (,vertices g)))
                             (current-cost #f)
                             (n#f #f)
                             (n#t #f)
                             (costs #f)
                             (lop #f))
                         (set! n#f (rgraph-count not initial-p))
                         (set! n#t (- L n#f))
                         (set! current-cost initial-cost)
                         (when ,debug
                               (print "Start with all cells free")
                               (print " initial-cost: " initial-cost))
                         (,clear! working-g)
                         (do ((i (- DEGREE) (add1 i)))
                             ((> i DEGREE))
                           (,add-vertex! working-g i))
                         (when ,debug
                               (print "Add all cells to gain bucket"))
                         (,for-each+
                          (lambda (u)
                            (let ((w-v (,add-vertex! working-g u))
                                  (gain (gain g u)))
                              (when ,check
                                    (when (> (abs gain) DEGREE)
                                          (error "Gain is outside of [-DEGREE,+DEGREE]"
                                                 DEGREE
                                                 gain)))
                              (set-working-d! g w-v u)
                              (set-d!
                                g
                                u
                                (,add-edge! working-g (vertex-at gain) w-v))))
                          (,vertices+ g))
                         (when ,debug
                               (print "Repeat until no cells free"))
                         (set! costs
                           (let loop2 ((cells-free L))
                             (cond ((= cells-free 0) '())
                                   (else
                                    (let ((largest #f) (largest-gain 0))
                                      (when ,debug
                                            (print "Move cell with largest gain"))
                                      (set! largest-gain
                                        (call/cc
                                          (lambda (escape)
                                            (do ((i DEGREE (sub1 i)))
                                                ((< i (- DEGREE)))
                                              (let* ((w-gv (vertex-at i))
                                                     (w-out (,out-edges+
                                                             working-g
                                                             w-gv)))
                                                (unless
                                                  (,null?+ w-out)
                                                  (let ((w-first
                                                          (,car+ w-out)))
                                                    (set! largest
                                                      (working-d
                                                        g
                                                        (,target g w-first)))
                                                    (,remove-edge!
                                                     working-g
                                                     w-first)
                                                    (escape i)))))
                                            (error "No cells to move, yet FM algorithm running")
                                            0)))
                                      (set! current-cost
                                        (- current-cost largest-gain))
                                      (cond ((p g largest)
                                             (set! n#f (add1 n#f))
                                             (set! n#t (sub1 n#t)))
                                            (else
                                             (set! n#t (add1 n#t))
                                             (set! n#f (sub1 n#f))))
                                      (set-p! g largest (not (p g largest)))
                                      (when ,debug
                                            (print "Update cost of neighbours"))
                                      (,for-each+
                                       (lambda (nb)
                                         (when ,debug
                                               (print " neighbour: " (car nb)))
                                         (let* ((u (car nb)) (w-gvu (d g u)))
                                           (when w-gvu
                                                 (,remove-edge!
                                                  working-g
                                                  w-gvu)
                                                 (set-d!
                                                   g
                                                   u
                                                   (,add-edge!
                                                    working-g
                                                    (vertex-at (gain g u))
                                                    (,target
                                                     working-g
                                                     w-gvu))))))
                                       (,neighbours+ g largest))
                                      (set-d! g largest #f)
                                      (when ,debug (print "Note current cost"))
                                      (and ,check
                                           (not (= (cost) current-cost))
                                           (error "Bug found where (cost) does not equal current-cost"
                                                  (cost)
                                                  current-cost))
                                      (cons (make-partition-fm
                                              current-cost
                                              (balance weight n#f n#t)
                                              largest)
                                            (loop2 (- cells-free 1))))))))
                         (when ,debug (print "Pick least cost point"))
                         (for-each
                           (lambda (fmv)
                             (and (< (partition-fm-cost fmv) initial-cost)
                                  (or (not lop)
                                      (< (partition-fm-cost fmv)
                                         (partition-fm-cost lop)))
                                  (<= (partition-fm-balance fmv) criterion)
                                  (set! lop fmv)))
                           costs)
                         (when ,debug
                               (print "  local optimal point cost: "
                                      (if lop (partition-fm-cost lop) "none")))
                         (let reset ((vertices (,vertices+ g))
                                     (initial initial-p))
                           (cond ((not (,null?+ vertices))
                                  (set-p! g (,car+ vertices) (car initial))
                                  (reset (,cdr+ vertices) (cdr initial)))))
                         (and lop
                              (let apply-moves ((costs costs))
                                (let ((u (partition-fm-vertex (car costs)))
                                      (cost (partition-fm-cost (car costs))))
                                  (cond ((null? costs))
                                        (else
                                         (set-p! g u (not (p g u)))
                                         (or (eq? lop (car costs))
                                             (apply-moves (cdr costs))))))))
                         (unless
                           (zero? initial-cost)
                           (let ((c (cost)) (l split-level))
                             (cond ((zero? l))
                                   ((= l 1)
                                    (when (>= (quotient initial-cost c) 2)
                                          (loop1 c)))
                                   (else
                                    (unless
                                      (= initial-cost c)
                                      (loop1 c))))))))))))
            (if streamed? (list #f #t) (list #f)))))
(define rgraph-doc-partition-fidmat-check #t)
(define rgraph-doc-partition-fidmat-debug #t)
