-------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
-- Auto generated by RAPID
-- By: Martin C. Carlisle and W. Blair Watkinson II

with Subwindow_Actions;
with Subwindow_Actions;
with Subwindow_Actions;
with mcc.text_entry_types;
with mcc.text_entry_types;

with mcc.Gui.Fonts;

package body textentry_dialog_window is

   procedure Generate_Window is
   begin

      if mcc.Gui.Container.Window.Is_Open
           (mcc.Gui.Container.Window.Window (textentry_dialog_window))
      then
         raise Already_Open;
      end if;

      mcc.Gui.Container.Window.Create
        (Obj    => textentry_dialog_window,
         X      => 0,
         Y      => 0,
         Width  => 372,
         Height => 249);

      mcc.Gui.Container.Window.Set_Title
        (Obj   => textentry_dialog_window,
         Title => "Text Entry Properties");

      mcc.Gui.Widget.Label.Create
        (Obj     => label1,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 5,
         Width   => 110,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Widget name");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry1,
         Parent => textentry_dialog_window,
         X      => 80,
         Y      => 5,
         Width  => 269,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => label2,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 35,
         Width   => 110,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "X");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry2,
         Parent => textentry_dialog_window,
         X      => 80,
         Y      => 35,
         Width  => 100,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => label3,
         Parent  => textentry_dialog_window,
         X       => 198,
         Y       => 35,
         Width   => 45,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Y");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry3,
         Parent => textentry_dialog_window,
         X      => 250,
         Y      => 35,
         Width  => 100,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => label4,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 65,
         Width   => 70,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Width");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry4,
         Parent => textentry_dialog_window,
         X      => 80,
         Y      => 65,
         Width  => 100,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => label5,
         Parent  => textentry_dialog_window,
         X       => 198,
         Y       => 65,
         Width   => 52,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Height");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry5,
         Parent => textentry_dialog_window,
         X      => 250,
         Y      => 65,
         Width  => 100,
         Height => 20);
      mcc.Gui.Widget.Button.Text.Create
        (Obj    => applyButton,
         Parent => textentry_dialog_window,
         X      => 77,
         Y      => 215,
         Width  => 60,
         Height => 20,
         Text   => "Apply");
      mcc.Gui.Widget.Button.Set_Push_Callback
        (Obj      => applyButton'Access,
         Callback => Subwindow_Actions.Apply_Properties_Dialog'Access);
      mcc.Gui.Widget.Button.Text.Create
        (Obj    => okbutton,
         Parent => textentry_dialog_window,
         X      => 147,
         Y      => 215,
         Width  => 60,
         Height => 20,
         Text   => "OK");
      mcc.Gui.Widget.Button.Set_Push_Callback
        (Obj      => okbutton'Access,
         Callback => Subwindow_Actions.Done_Properties_Dialog'Access);
      mcc.Gui.Widget.Button.Text.Create
        (Obj    => cancelButton,
         Parent => textentry_dialog_window,
         X      => 217,
         Y      => 215,
         Width  => 60,
         Height => 20,
         Text   => "Cancel");
      mcc.Gui.Widget.Button.Set_Push_Callback
        (Obj      => cancelButton'Access,
         Callback => Subwindow_Actions.Cancel_Properties_Dialog'Access);
      mcc.Gui.Widget.Label.Create
        (Obj     => item_label,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 125,
         Width   => 70,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Data Item");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry6,
         Parent => textentry_dialog_window,
         X      => 80,
         Y      => 125,
         Width  => 269,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => autofill,
         Parent  => textentry_dialog_window,
         X       => 5,
         Y       => 98,
         Width   => 345,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Use fully qualified names or leave blank");
      mcc.Gui.Widget.Label.Create
        (Obj     => typelabel,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 185,
         Width   => 70,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Data type");
      mcc.Gui.Widget.Text_Entry.Create
        (Obj    => entry7,
         Parent => textentry_dialog_window,
         X      => 80,
         Y      => 185,
         Width  => 269,
         Height => 20);
      mcc.Gui.Widget.Label.Create
        (Obj     => baselabel,
         Parent  => textentry_dialog_window,
         X       => 0,
         Y       => 155,
         Width   => 70,
         Height  => 20,
         Justify => mcc.Gui.Widget.Label.Left,
         Text    => "Base type");
      mcc.Gui.Widget.Dropdown.Create
        (Obj         => base_dropdown,
         Parent      => textentry_dialog_window,
         X           => 74,
         Y           => 154,
         Width       => 179,
         Height      => 25,
         Number_Rows => 7);
      for E in mcc.text_entry_types.Base_Type loop
         mcc.Gui.Widget.Dropdown.Add_Entry
           (Obj      => base_dropdown,
            Location => mcc.text_entry_types.Base_Type'Pos (E),
            Text     => mcc.text_entry_types.Base_Type'Image (E));
      end loop;

   end Generate_Window;

   procedure Fill_Window is
   begin
      null; -- in case there aren't any widgets to fill
      mcc.Gui.Widget.Dropdown.Select_Item
        (Obj    => base_dropdown,
         Number =>
           mcc.text_entry_types.Base_Type'Pos
              (mcc.text_entry_types.Default_Base_Type) +
           1);

   end Fill_Window;

   procedure Generate_and_Fill_Window is
   begin
      Generate_Window;
      Fill_Window;
   end Generate_and_Fill_Window;

   procedure Read_Window
     (Success         : out Boolean;
      Highlight_Error : in Boolean := True;
      Beep_On_Error   : in Boolean := True)
   is
   begin
      Success := True;
      declare
         Position : Integer :=
            mcc.Gui.Widget.Dropdown.Get_Selected (base_dropdown) - 1;
      begin
         mcc.text_entry_types.Default_Base_Type :=
            mcc.text_entry_types.Base_Type'Val (Position);
      end;
   exception
      when others =>
         Success := False;
         if Beep_On_Error then
            mcc.Gui.Bell;
         end if;
   end Read_Window;

   procedure Close_Window is
   begin
      mcc.Gui.Destroy (mcc.Gui.Object (textentry_dialog_window));
   end Close_Window;

end textentry_dialog_window;
