------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
------------------------------------------------------------------------------
-- modified by C2C W. Blair Watkinson II on 16 Feb 99
-- added when for "Scale"
-- added "with" for Scale
with gui.Widget.Static;
with gui.Widget.Button;
with gui.Widget.Check_Button;
with gui.Widget.Radio_Button;
with gui.Widget.Picture;
with gui.Widget.Listbox;
with gui.Widget.Text;
with gui.Widget.Progress;
with gui.Widget.Scale;
with gui.Widget.Dropdown;
with gui.Widget.Textbox;
with gui.Widget.Frame;

package body Gui_Enum is

   function Img (Item : Keyword) return String is
   begin
      return Keyword'Image (Item);
   end Img;

   ---------------------
   -- Allocate_Widget --
   ---------------------

   function Allocate_Widget
     (Widget_Type : in Widget_Keyword)
      return        gui.Widget.Widget_Access
   is
   begin
      case Widget_Type is
      when Label =>
         return new gui.Widget.Static.Label;
      when TextEntry =>
         return new gui.Widget.Text.Text_Entry;
      when PictureButton =>
         return new gui.Widget.Button.Picture_Button;
      when TextButton =>
         return new gui.Widget.Button.Text_Button;
      when CheckButton =>
         return new gui.Widget.Check_Button.Check_Button;
      when RadioButton =>
         return new gui.Widget.Radio_Button.Radio_Button;
      when Picture =>
         return new gui.Widget.Picture.Picture;
      when Listbox =>
         return new gui.Widget.Listbox.Listbox;
      when Scale =>
         return new gui.Widget.Scale.Scale;
      when Progress =>
         return new gui.Widget.Progress.Progress;
      when Dropdown =>
         return new gui.Widget.Dropdown.Dropdown;
      when Textbox =>
         return new gui.Widget.Textbox.Textbox;
      when Frame =>
         return new gui.Widget.Frame.Frame;
      end case;
   end Allocate_Widget;

end Gui_Enum;
