---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-PICTURE.ADS
--  Description : GUI Widget Picture (from GIF)
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.Gui.Widget.Text_Entry;
with mcc.Gui.Container;
with mcc.Gui.Image;

package gui.Widget.Picture is

   type Picture is new GUI_Widget with record
      Picture       : String_Pointer := null;
      Image         : mcc.Gui.Image.External_Image;
      Picture_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into Picture,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Picture);

   -- Writes information to file from Picture
   procedure Write_Widget (Widget : in Picture);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Picture);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Picture);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Picture;
      Container : in out mcc.Gui.Container.Container'Class);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Picture;
      Window_Name : in String);

   procedure Set_Properties (Widget : in out Picture);

   procedure Apply_Properties (Widget : in out Picture);
   procedure Check_Properties (Widget : in out Picture; Ok : out Boolean);

end Gui.Widget.Picture;
