/*
 * Decompiled with CFR 0.152.
 */
package org.qsos.transformation;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.qsos.data.IElement;
import org.qsos.data.ISheet;
import org.qsos.transformation.IXMLizer;

public class XMLizer
implements IXMLizer {
    public String transformToXml(ISheet sheet) {
        IElement target = sheet.getRoot();
        if (target != null) {
            Document doc = new Document();
            doc.setRootElement(this.transformAnIElement(target));
            return this.docToString(doc);
        }
        return "";
    }

    public void transformToXml(ISheet target, String path) {
        String xml = this.transformToXml(target);
        this.createFile(xml, path);
    }

    public String docToString(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(doc, (OutputStream)out);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return ((Object)out).toString();
    }

    public Element transformAnIElement(IElement item) {
        Element elchild;
        Element node = new Element(item.getMeta());
        if (item.getName() != null) {
            node.setAttribute("name", item.getName());
        }
        if (item.getTitle() != null) {
            node.setAttribute("title", item.getTitle());
        }
        node.setText(item.getText());
        if (item.getDesc() != null && item.getDesc() != "") {
            elchild = new Element("desc");
            elchild.setText(item.getDesc());
            node.addContent((Content)elchild);
        }
        if (item.getDesc0() != "") {
            elchild = new Element("desc0");
            elchild.setText(item.getDesc0());
            node.addContent((Content)elchild);
        }
        if (item.getDesc1() != "") {
            elchild = new Element("desc1");
            elchild.setText(item.getDesc1());
            node.addContent((Content)elchild);
        }
        if (item.getDesc2() != "") {
            elchild = new Element("desc2");
            elchild.setText(item.getDesc2());
            node.addContent((Content)elchild);
        }
        if (item.getComment() != "") {
            elchild = new Element("comment");
            elchild.setText(item.getComment());
            node.addContent((Content)elchild);
        }
        if (item.getScore() != "") {
            elchild = new Element("score");
            elchild.setText(item.getScore());
            node.addContent((Content)elchild);
        }
        if (item.getElements() != null) {
            for (IElement child : item.getElements()) {
                node.addContent((Content)this.transformAnIElement(child));
            }
        }
        return node;
    }

    private void createFile(String lineIN, String fileOUT) {
        try {
            FileOutputStream fout = new FileOutputStream(fileOUT);
            new PrintStream(fout).println(lineIN);
            fout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

