/** The swig interface file of a demostration package, to show PyCClass in
    action.

    Copyright (C) 2006 ParIT Worker Co-operative <http://parit.ca>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
    MA  02110-1301  USA

    Authors: Mark Jenkins <mark@parit.ca>
 */

%module package_name_c_interface
%{
#include <point.h>


/** The implimentation of the functions being interfaced is included here,
    which is not what you would normally see. Ussually the implentation
    of the functions defined in this interface file is in a library, which
    get's linked against your extension module.
 */
Point * point_new()
{
  Point * p = malloc(sizeof(Point));
  p->y = p->x = 0;
}

void point_set_x(Point * p, int x)
{
  p->x = x;
}

int point_get_x(Point *p)
{
  return p->x;
}

void point_set_y(Point * p, int y)
{
  p->y = y;
}

int point_get_y(Point *p)
{
  return p->y;
}

void point_move_up_right(Point *p)
{
  p->y++;
  p->x++;
}

%}


/** This is the key part, use c header files to define the interface.
    This won't allways work, sometime you'll deal with C headers that
    break the swig in some way, and have to either fix the headers or
    only define the parts of the interface you're interested in.
 **/
%include <point.h>
