#

"""Checking some properties of the Klein bottle"""


clear()
from pyformex.examples.KleinBottle import KleinBottle

M = KleinBottle()
M.attrib(color=1, bkcolor=3)
draw(M)

print("======= Unfused bottle ========")
print(M)

print("======== Fused bottle ========")
M1 = M.fuse().compact()
print(M1)

print("========= TriSurface from unfused bottle ======")
T = M.toSurface()
T.check()
print(T.stats())

print("========= TriSurface from fused bottle ======")
T1 = M1.toSurface()
T1.check()
print(T1.stats())

# End
