#
##
##  SPDX-FileCopyrightText: © 2007-2022 Benedict Verhegghe <bverheg@gmail.com>
##  SPDX-License-Identifier: GPL-3.0-or-later
##
##  This file is part of pyFormex 3.1  (Sat May 21 14:49:50 CEST 2022)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: https://pyformex.org
##  Project page: https://savannah.nongnu.org/projects/pyformex/
##  Development: https://gitlab.com/bverheg/pyformex
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""pyFormex specific exceptions

"""
from inspect import cleandoc as dedent

class FatalError(Exception):
    """Raised on fatal or grave errors"""
    def __init__(self, msg):
        s = '\n' + '#' * 72
        s = '\n##  '.join([s] + dedent(msg).split('\n')) + s
        Exception.__init__(self, s)


class RequirementsError(FatalError):
    """Raised on missing or invalid requirements"""
    pass

class UninstallError(FatalError):
    """Raised on invalid remove request"""
    pass

class InvalidElementType(Exception):
    """Raised for invalid element types."""
    pass

class ValidationError(Exception):
    """Raised in inputt fields that do not have an acceptable value."""
    pass

# End
