from pyformex import Path

from pyformex.simple import sphere
from pyformex.filewrite import writeSTL
from pyformex.timer import Timer

mesh = sphere(50)

print(f"Current dir is {Path.cwd()}")

t = Timer()
writeSTL('test_bin.stl', mesh.coords[mesh.elems], binary=True)
print(f"Time: {t.seconds()} seconds")

t = Timer()
writeSTL('test_asc.stl', mesh.coords[mesh.elems], binary=False)
print(f"Time: {t.seconds()} seconds")

# End
