#

"""Test the fonts on the system for use in text drawing.

The script will loop over all detected monotype fonts and
display the full texture image of that font.

The save option should probably be refined (overwrite existing?)
and put into the dialog.

"""


from pyformex.gui.draw import *
from pyformex.opengl.actors import *
from pyformex.opengl.textext import *

do_save = ack("Save the generated texturefonts to pyformex/fonts? Only do so if you know what you're doing!")


def run():
    clear()
    lights(False)
    interactive = True
    for f in utils.listMonoFonts():
        run1(f, save=do_save)
        if interactive:
            ans = ask("Quit, Continue (silent) with all fonts, or show Next font?", ["Quit", "Continue", "Next"])
            if ans == "Quit":
                break
            elif ans == "Continue":
                interactive = False
        else:
            sleep(1)


def run1(f, save=False):
    clear()
    print(f)
    font = FontTexture(f, 24, save=save)
    nrows, ncols = font.layout
    x, y = 20, pf.canvas.getSize()[1] - 20
    drawText(f, (x, y), font=font, size=24)
    c = arange(32, 128).reshape(nrows, ncols)
    a = [''.join([chr(c) for c in range(32+i*ncols, 32+(i+1)*ncols)]) for i in range(nrows)]
    #print(a)
    for ai in a:
        y -= 32
        drawText(ai, (x, y), font=font, size=24)
    for size in (12, 18, 24, 32, 40, 48):
        y -= size+8
        drawText("This is a sample at size %s" % size, (x, y), font=font, size=size)


# You can also run on a single font:
#run1('/usr/share/fonts/truetype/dejavu/DejaVuSansMono.ttf',save=True)
#run1('/usr/share/fonts/truetype/dejavu/DejaVuSansMono-Oblique.ttf',save=True)

run()
