# The contents of this file may be used and copied without restriction
# Copyright (c) Daniel Arbuckle, 2002

import os

# if os.environ['PY_DBC'] is nonexistant or empty, no contract 
# checking will be performed. The usual way to set this would be
# from the command shell as an environment variable.
# if contract checking is not enabled, it imposes NO overhead
# during the execution of your program
os.environ['PY_DBC'] = 'true' 
import dbc 

__metaclass__ = dbc.DBC
                            
class Foo:
    # You can also turn on DBC for a specific class by specifying the __metaclass__ attribute:
    # __metaclass__ = dbc.DBC
    
    # Postcondition on a special name
    def __init____post(self, ret):
	assert hasattr(self, 'a')
	
    def __init__(self):
	self.a = 1
    
    # Class invariant, checked each time a member is called or an attribute accessed
    def __invar(self): 
	assert self.a
    
    # Precondition for function foo, checked just before foo
    # Preconditions are passed the same arguments as the called function (including varargs and keyword args)
    def foo__pre(self, b): 
	# If a condition fails, it should raise an exception of some sort. assert() is a good way to do that
	assert not isinstance(b, str) 
	
    def foo(self, b):
	self.a = b
    
    # Postcondition for foo, checked just after foo
    # Postconditions are passed the return value of the call
    def foo__post(self, ret): 
	assert self.a < 5

f = Foo()             # calls __init__, then calls __invar
f.foo(2)              # calls foo__pre, foo, foo__post and __invar
# f.foo('bar')        # would trigger the assert in foo__pre
# f.foo(10)           # would trigger the assert in foo__post
# f.foo(0)            # would trigger the assert in __invar

f.a = 3               # assigns the value, then checks __invar
f.a = 7               # __invar doesn't check the cap on a. be careful to put your obligations in the right place
# f.a = 0             # would trigger the assert in __invar
