/* Copyright (C) 2012 Rudra Banerjee*/

/*
This file is part of ptbl.

ptbl is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ptbl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/


#include "config.h"
#include <stdio.h>
#include <stdlib.h>

#include <glib/gi18n.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <gtk/gtk.h>
#include <string.h>

GtkWidget *window;
 void helpabout_activated (GtkMenuItem *helpabout, GtkWidget *dialog)
{
  const gchar *auth[]={ "Rudra Banerjee <bnrj.rudra@yahoo.com>", NULL };
  const gchar trans[]={"Kathakali Banerjee <bnrj.kathakali@hotmail.co.uk>"};
  const gchar *copyright = _("Copyright \xc2\xa9 2012-2013 Rudra Banerjee");

  gchar *hstr=g_strdup_printf("%s/ptbl.png", PIXMAP);
  GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file(hstr, NULL);
  const gchar *comments = _("Periodic Table Viewer");
//  GtkWidget *dialog;
  gtk_show_about_dialog (GTK_IS_WINDOW (dialog) ? GTK_WINDOW (dialog) : NULL,
  			 "name", _("ptbl"),
  			 "version", VERSION,
			 "comments", comments,
  			 "copyright", copyright,
  			 "authors", auth,
  			 "translator-credits", trans,
  			 "logo", pixbuf,
			 "website", PACKAGE_URL,
			 "screen", gtk_widget_get_screen (dialog),
  			 NULL);
}
void helpfhelp(GtkWidget *widget, gpointer data)

{
  	gchar *uri, *str;
	GError *Err=NULL;

	uri=g_strdup("help:ptbl");
	gtk_show_uri(NULL, uri, gtk_get_current_event_time(), &Err);
	g_free(uri);
	if (Err)
	{
//	  caution("File does not exist");
	}
}


