/* Copyright (C) 2012 Rudra Banerjee*/

/*
    This file is part of ptbl.

    ptbl is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ptbl is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ptbl.  If not, see <http://www.gnu.org/licenses/>.

*/

#include <gtk/gtk.h>

void callback_Os(GtkWidget *button, gpointer user_data)
{
  GtkWidget **child_window76 = (GtkWidget**)user_data;  
  static GtkWidget *window = NULL;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *frame;
  GtkWidget *label;


if (*child_window76) {
      gtk_window_present(GTK_WINDOW(*child_window76));
      return;
  }

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Os");
  vbox = gtk_vbox_new (FALSE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), hbox);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);


  frame = gtk_frame_new ("Properties");
  label = gtk_label_new ("Name\nSymbol\nAtomic Number\n"                         "Atomic Weight\nElectron configuration\n"                          "Phase\nMelting point\nBoiling point\n"                          "Electronegativity\nElectronAffinity \n"                          "Valence \nAtomic radius \n"                         "Crystal structure\nLattice Constant\n"                         "Space Group");
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);

  frame = gtk_frame_new ("Values");
  label = gtk_label_new (NULL);
  char *str="Osmium  \nOs\n"                          "76  \n190.23\n[Xe]4f<sup>14</sup>5d<sup>6</sup>6s<sup>2</sup>\n"                          "Solid  \n3033 °C \n5012 °C\n"                          "2.2 \n106.1 kJ/mol\n"                          "3    \n185 pm \n"                          "Simple Hexagonal   \n273.44 pm\n"                          "P6[3]/mmc [194]";
  gtk_label_set_markup(GTK_LABEL(label), str);
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_container_add (GTK_CONTAINER (frame), label);
  gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);

  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  gtk_widget_show_all (window);
  gtk_window_present(GTK_WINDOW(window));
  *child_window76 = window;
  g_object_add_weak_pointer(G_OBJECT(window), (gpointer*)child_window76);


}

