<?php
/*
    Copyright (C) 2005, 2006  Stephan A. Rickauer

    This file is part of phpMyMembers.

    phpMyMembers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    phpMyMembers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with phpMyMembers; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

include('include/dbconnect.php');
require('include/functions.php');

// Only people of the phpAuthent group 'edit' may submit the form
// We can get the user with 'getUserId()'
require_once(PHPMYMEMBERS_DIR . '/include/phpauthent/phpauthent_core.php');
$userlist = array('');
$grouplist = array('edit');

$date 	= date('Y-m-d');
$action	= $_REQUEST['action'];
$me	    = $_SERVER['PHP_SELF'];

$Mitglied_ID            = $_POST['Mitglied_ID'];
$Nachname               = $_POST['Nachname'];
$Vorname                = $_POST['Vorname'];
$Titel                  = $_POST['Titel'];
$Mitgliednummer         = $_POST['Mitgliednummer'];
$Geburtsdatum           = make_mysql_date("$_POST[Geburtsdatum]");
$Beruf                  = $_POST['Beruf'];
$Eintritt               = make_mysql_date("$_POST[Eintritt]");
$Austritt               = make_mysql_date("$_POST[Austritt]");
$Mitgliedschaft_ID      = $_POST['Mitgliedschaft_ID'];
$Zivilstand_ID          = $_POST['Zivilstand_ID'];
$Geschlecht_ID          = $_POST['Geschlecht_ID'];
$GL                     = $_POST['GL'];

$Adress_ID              = $_POST['Adress_ID'];
$Adressfeld1            = $_POST['Adressfeld1'];
$Adressfeld2            = $_POST['Adressfeld2'];
$Kanton                 = $_POST['Kanton'];
$Postleitzahl           = $_POST['Postleitzahl'];
$Stadt                  = $_POST['Stadt'];
$Land                   = $_POST['Land'];
$Telephon               = $_POST['Telephon'];
$Telefax                = $_POST['Telefax'];
$Mobil                  = $_POST['Mobil'];
$EMail                  = $_POST['EMail'];

switch($action) {
case 'edit':

	$Mitglied_upd_sql 	= sprintf("
				UPDATE `Mitglied` SET
					`Nachname`          =%s,
					`Vorname`           =%s,
					`Titel`             =%s,
					`Mitgliednummer`    =%s,
					`Geburtsdatum`      =%s,
					`Beruf`             =%s,
					`Eintritt`          =%s,
					`Austritt`          =%s,
					`GL`                =%s,
					`Mitgliedschaft_ID`	=%s,
					`Zivilstand_ID`		=%s,
					`Geschlecht_ID`		=%s,
					`Update`            =%s,
					`Update_ID`         =%s
				WHERE `Mitglied_ID`=%s",
				quote_smart($Nachname),
				quote_smart($Vorname),
				quote_smart($Titel),
				quote_smart($Mitgliednummer),
				quote_smart($Geburtsdatum),
				quote_smart($Beruf),
				quote_smart($Eintritt),
				quote_smart($Austritt),
				quote_smart($GL),
				quote_smart($Mitgliedschaft_ID),
				quote_smart($Zivilstand_ID),
				quote_smart($Geschlecht_ID),
				quote_smart($date),
				quote_smart(getUserID()),
				quote_smart($Mitglied_ID)
				);

	$Adress_table  		= "Adresse" . "$Adress_ID";

	// Check whether the address to be updated already exists,
	// if not, we need to 'insert' instead of 'update'. If no
	// field of the address POSTs is set, we delete the address
	// if not the main one.
	// insert: 0 // update: 1 // delete: 2

	$check_for_address_sql 	= sprintf("
					SELECT COUNT(`Mitglied_ID`) FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s", quote_smart($Mitglied_ID)
				);

	$result = mysql_query($check_for_address_sql)
		or die('Could not check adress table: ' . mysql_error());

        while ($row = mysql_fetch_row($result)) {
                $value = $row[0];
        }

	// Address already existent, 'update' or 'delete' should be ok
	switch($value) {
	case '1':
		if (
		   !empty($Adressfeld1) or
		   !empty($Adressfeld2) or
		   !empty($Kanton) or
		   !empty($Postleitzahl) or
		   !empty($Stadt) or
		   !empty($Land) or
		   !empty($Telephon) or
		   !empty($Telefax) or
		   !empty($Mobil) or
		   !empty($EMail)
		   ) {
			$Adress_upd_sql	= sprintf("
				UPDATE `$Adress_table` SET
					`Adressfeld1`	=%s,
					`Adressfeld2`	=%s,
					`Kanton`	=%s,
					`Postleitzahl`	=%s,
					`Stadt`		=%s,
					`Land`		=%s,
					`Telephon`	=%s,
					`Telefax`	=%s,
					`Mobil`		=%s,
					`EMail`		=%s
				WHERE `Mitglied_ID`	=%s",
					quote_smart($Adressfeld1),
					quote_smart($Adressfeld2),
					quote_smart($Kanton),
					quote_smart($Postleitzahl),
					quote_smart($Stadt),
					quote_smart($Land),
					quote_smart($Telephon),
					quote_smart($Telefax),
					quote_smart($Mobil),
					quote_smart($EMail),
					quote_smart($Mitglied_ID)
				);

		// If all address fields are empty, we delete the entire record
		// instead of updating with empty fields  - if not main address.
		} else {
		   	if ("$Adress_ID" != '1') {
				$Adress_upd_sql = sprintf("
					DELETE FROM `$Adress_table`
					WHERE `Mitglied_ID`=%s
					LIMIT 1",
					quote_smart($Mitglied_ID));
			}
		}
		break;

	// Address NOT existent yet, 'insert' required
	case '0':
        	$Adress_upd_sql		= sprintf("
				INSERT INTO `$Adress_table` (
					`Mitglied_ID`,
                                        `Adressfeld1`,
                                        `Adressfeld2`,
                                        `Kanton`,
                                        `Postleitzahl`,
                                        `Stadt`,
                                        `Land`,
                                        `Telephon`,
                                        `Telefax`,
                                        `Mobil`,
                                        `EMail`)
				VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
                                        quote_smart($Mitglied_ID),
                                        quote_smart($Adressfeld1),
                                        quote_smart($Adressfeld2),
                                        quote_smart($Kanton),
                                        quote_smart($Postleitzahl),
                                        quote_smart($Stadt),
                                        quote_smart($Land),
                                        quote_smart($Telephon),
                                        quote_smart($Telefax),
                                        quote_smart($Mobil),
                                        quote_smart($EMail)
                               	);
				break;
	}

	//print_r($Mitglied_upd_sql);
	//print_r($Adress_upd_sql);
	
	mysql_query($Mitglied_upd_sql,$db) or die('Could not update database, member table: ' . mysql_error());
	mysql_query($Adress_upd_sql,$db)   or die('Could not update database, adress table: ' . mysql_error());
	mysql_close();

	// Redirect to some page and exit
	header('Location: http://' . $_SERVER['HTTP_HOST'] . '/phpMyMembers/detail.php?Mitglied_ID=' .
				     $Mitglied_ID . '&address=' . $Adress_ID . '&status=ok');
	exit;
	break;


case 'new':

	$Mitglied_insert_sql 	= sprintf("INSERT INTO `Mitglied` (
							`Mitglied_ID`,
							`Mitgliednummer`,
							`Nachname`,
							`Vorname`,
							`Geburtsdatum`,
							`Geschlecht_ID`,
							`Zivilstand_ID`,
							`Eintritt`,
							`Austritt`,
							`Mitgliedschaft_ID`,
							`Update`,
							`Update_ID`,
							`Beruf`,
							`Titel`,
							`GL`)
			 		VALUES ( '', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($Mitgliednummer),
					quote_smart($Nachname),
					quote_smart($Vorname),
					quote_smart($Geburtsdatum),
					quote_smart($Geschlecht_ID),
					quote_smart($Zivilstand_ID),
					quote_smart($Eintritt),
					quote_smart($Austritt),
					quote_smart($Mitgliedschaft_ID),
					quote_smart($date),
					quote_smart(getUserId()),
					quote_smart($Beruf),
					quote_smart($Titel),
					quote_smart($GL)
					);

	mysql_query($Mitglied_insert_sql,$db) or die('Could not insert database, member table: ' . mysql_error());

	// mysql_insert_id() gives us the previously assigned auto-increment
	// value which we need for the insert of the address.
	$Mitglied_ID		= mysql_insert_id();

	$Adress_table          	= 'Adresse' . "$Adress_ID";
	$Adress_insert_sql	= sprintf("INSERT INTO `$Adress_table` (
							`Mitglied_ID`,
							`Adressfeld1`,
							`Adressfeld2`,
							`Kanton`,
							`Postleitzahl`,
							`Stadt`,
							`Land`,
							`Telephon`,
							`Telefax`,
							`Mobil`,
							`EMail`)
					VALUES ( %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
					quote_smart($Mitglied_ID),
					quote_smart($Adressfeld1),
					quote_smart($Adressfeld2),
					quote_smart($Kanton),
					quote_smart($Postleitzahl),
					quote_smart($Stadt),
					quote_smart($Land),
					quote_smart($Telephon),
					quote_smart($Telefax),
					quote_smart($Mobil),
					quote_smart($EMail)
					);

	mysql_query($Adress_insert_sql,$db) or die('Could not insert database, address table: ' . mysql_error());
    mysql_close();

	// Redirect and exit
	header('Location: http://' . $_SERVER['HTTP_HOST'] . '/phpMyMembers/detail.php?Mitglied_ID=' .
				     $Mitglied_ID . '&address=' . $Adress_ID . '&status=ok');
	exit;
    break;
}

?>
