<?
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Author : Jean-Christophe Cardot
   Copyright (c) 2000-2002 Jean-Christophe Cardot <taz98@altern.org>
 */

define ('LF', chr(10));
define ('CRLF', chr(13).chr(10));

// envoi du cookie pour le split (si le cookie n'existe pas dj)
if ($splitvalue && ($splitvalue!=$HTTP_COOKIE_VARS["csplitvalue"])): // dure : un an
  setcookie("csplitvalue", $splitvalue, time()+31536000, "/explore2.php3");
elseif ($csplitvalue):
  $splitvalue=$csplitvalue;
elseif ($HTTP_COOKIE_VARS["csplitvalue"]):
  $splitvalue=$HTTP_COOKIE_VARS["csplitvalue"];
endif;

// nettoyage du chemin du fichier  diter
include "$explore_dir/include/canonize.inc";
$file2edit = canonize_path($file2edit);

?>

<html>
<head>
   <meta name="Author" content="Jean-Christophe Cardot">
   <meta name="GENERATOR" content="MS Notepad">
   <meta name="Description" content="Edition en ligne d'un fichier">
   <meta name="created" content="20000229;00000000">
   <meta name="changedby" content="JCC">
   <meta name="changed" content="20001106;00000000">
   <title>Edition en ligne - <? echo $file2edit; ?></title>
</head>

<body>
<h1>Edition<? if ($file2edit): echo " du fichier <tt>$file2edit</tt>"; else: echo " d'un fichier"; endif;?></h1>

<?
clearstatcache(); /* sinon le rsultat de filesize est cach */

/////////////// fonctions ////////////////

// renvoie toutes les lignes du fichier tant que la taille totale
// est infrieure  $size Koctets :
function getnextpart($filecontent, $size) {
  global $afilecontent, $pfilecontent;
  $size *= 1024;
  $ret = "";
  if (!isset($afilecontent)): // i.e. 1ere fois
    $filecontent = ereg_replace(CRLF, LF, $filecontent);
    $afilecontent = preg_split("/\n/", $filecontent);
    $pfilecontent = 0;
  endif;
  while ($pfilecontent < count($afilecontent)):
    $line = $afilecontent[$pfilecontent++];
    if (strlen($ret)+strlen($line) <= $size):
      $ret .= $line."\n";
    else:
      $pfilecontent--;
      break; // $ret est assez gros !
    endif;
  endwhile;
  $ret = preg_replace("/\n$/", "", $ret); // on vire le \n final
  return $ret;
}

// pour que le comportement soit le mme quelquesoit l'option
// magic_quotes_gpc (Get/Post/Cookies) de php (php ajoute un backslash
// devant les guillemets ' et " et les \ si cette option est  1)
/*function myAddslashes ($string) {
  if (get_magic_quotes_gpc()==1):
    return $string;
  else:
    return AddSlashes($string);
  endif;
}*/
function myStripslashes ($string) {
  if (get_magic_quotes_gpc()==1):
    return Stripslashes($string);
  else:
    return $string;
  endif;
}

/////////////// actions ////////////////

// bouton [Fin dition]
if ($fin_edition): // on enregistre avant de fermer
  $enregistrer = 1;
endif;

// Lock : c/o et/ou vrification
if ($allowCVS):
  list($ckoutuser, $ckoutdate) = is_checkedout($file2edit);
  if ($ckoutuser == ""):
    do_checkout($file2edit, $HTTP_COOKIE_VARS[$cookieuser]);
    list($ckoutuser, $ckoutdate) = is_checkedout($file2edit);
    echo "<br><font color='#FF0000'>Le fichier est maintenant en checkout (<b>$ckoutuser</b>, $ckoutdate)</font>\n";
  elseif ($ckoutuser == $HTTP_COOKIE_VARS[$cookieuser]):
    echo "<br><font color='#FF0000'>Edition d'un fichier vous appartenant (<b>$ckoutuser</b>, $ckoutdate)</font>\n";
  else:
    echo "<br><font color='#FF0000'>Attention, fichier en lecture seule (checkout <b>$ckoutuser</b>, $ckoutdate)</font>\n";
    $readonly = 1;
  endif;
endif;

// bouton [Enregistrer]
if ($enregistrer && $file2edit):
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], "EDIT $file2edit (save)");
  if (file_exists($file2edit)):
    copy ($file2edit, "$file2edit.bak"); // backup
  endif;
  $tout_le_texte = implode(CRLF, $texte);
  if ($noCRLF): // on remplace CRLF par LF si fichier "unix"
    $tout_le_texte = ereg_replace(CRLF, LF, $tout_le_texte);
  endif;
  $fp = fopen($file2edit, "w");
  fwrite($fp, myStripslashes($tout_le_texte)); // myStripslashes supprime les \
  fclose($fp);                                 // ventuellement ajouts par php
  // on affiche le rsultat
  echo "<br><font color='#FF0000'>Fichier <tt>$file2edit</tt> enregistr&eacute;</font>\n";
elseif ($file2edit):
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], "EDIT $file2edit");
else:
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], "EDIT");
endif;

// action lock : c/i si [Fin dition]
if ($allowCVS): /* actions CVS */
  if ($fin_edition):
    echo "<br><font color='#FF0000'>Fin d'dition...</font>\n";
    do_checkin($file2edit);
    echo "<br><font color='#FF0000'>Vous pouvez fermer la fen&ecirc;tre.</font>\n";
  endif;
endif;

// affichage du type de fichier (DOS/Unix), sa taille, la date et l'heure courante
echo "<br><em>";
if ($file2edit && file_exists($file2edit)):
  echo "(";
  $isUnixFile = 1;
  $fp = fopen($file2edit, "r");
  clearstatcache();
  $filecontent = fread($fp, filesize($file2edit));
  fclose($fp);
  if (ereg(CRLF, $filecontent)):
    echo "DOS";
    $isUnixFile = 0;
  else:
    echo "Unix";
  endif;
  clearstatcache();
  echo " / ".(0+filesize($file2edit))." octets) - ";
endif;
echo "Le ".Date("d/m/Y",time())."  ".Date("H:i:s",time()).".</em>\n";

// affichage du formulaire
echo "<FORM ACTION='$PHP_SELF' METHOD='POST'><INPUT TYPE='hidden' NAME='edit' VALUE='1'>\n";
echo "<TABLE>\n <tr>\n";
if (!$fin_edition):
  echo "  <td align='left'>";
  echo "Fichier <INPUT TYPE='text' name='file2edit' value='$file2edit'>\n";
  echo "<INPUT NAME='edit' TYPE='submit' VALUE='Editer'>\n";
  if (!$readonly):
    echo "<INPUT NAME='enregistrer' TYPE='submit' VALUE='Enregistrer'></td>\n";
  endif;
endif;
echo "  <td align='right'>";
if ($allowCVS):
  if (!$fin_edition):
    echo "<INPUT TYPE='submit' NAME='fin_edition' VALUE='Fin &eacute;dition'>\n";
  endif;
endif;
echo "<INPUT TYPE='button' NAME='fermer' onclick='window.close();' VALUE='Fermer'></td>\n </tr>\n";

if (!$fin_edition):
  echo " <tr>\n  <td colspan='2'>\n";
  echo "<em>Pour &quot;enregistrer sous&quot;, changez simplement le nom du fichier et cliquez sur [Enregistrer].</em>\n";

  // dfinition du <textarea>
  $filecontent = htmlspecialchars($filecontent); // pour affichage correct ds le textarea
  if ($file2edit && file_exists($file2edit) && (filesize($file2edit)>0)):
    if (isset($splitvalue) && ($splitvalue<>0)): // on splite
      while ($t = getnextpart($filecontent, $splitvalue)):
        echo "<TEXTAREA NAME='texte[]' ROWS='21' COLS='75'>$t</TEXTAREA>\n";
      endwhile;
    else: // on ne splite pas
      echo "<TEXTAREA NAME='texte[]' ROWS='21' COLS='75'>$filecontent</TEXTAREA>\n";
    endif;
  else: // pas de fichier ou fichier vide :
    echo "<TEXTAREA NAME='texte[]' ROWS='21' COLS='75'>";
    echo "</TEXTAREA>\n";
  endif;

  echo "<br>Fichier Unix : <INPUT TYPE='checkbox' NAME='noCRLF'";
  if ($isUnixFile): echo " checked"; endif;
  echo "> <em>(i.e. LF et non CR/LF en fin de ligne).\n";
  echo "Pour faire un DOS2UNIX : d&eacute;cochez cette case et enregistrez le fichier.</em>\n";
  echo "<br>Split  <INPUT TYPE='text' NAME='splitvalue' VALUE='$splitvalue' SIZE='3'> Koctets \n";
  echo "<em>Le Split permet de sparer la zone de saisie en plusieurs zones, afin de contourner un bug (?) sous windows qui empche la saisie si la zone contient trop de texte (xx Ko ?)</em>\n";
  echo "  </td>\n </tr>\n";
endif;

echo "</TABLE>\n";
echo "</FORM>\n";
?>

<hr>

<div align=right>
 &copy; 2000 Jean-Christophe &quot;Jic&eacute;&quot; Cardot <em>&lt;taz98@altern.org&gt;</em>
 <br><em>PHP was here :)</em>
</div>
</body>
</html>