<?
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Author : Jean-Christophe Cardot
   Copyright (c) 2000-2002 Jean-Christophe Cardot <taz98@altern.org>
 */

// nettoie un chemin : suppression des doubles /, de ./ en tte,
// de /./ au milieu, de xxx/.., de /  la fin etc.
function _canonize_path($p) {
  $path = $p;
  /*  xxx/../ ->  */
  $path = preg_replace("|[^/^\.]+/\.\./|", "", $path);
  /*  xxx/..$ ->  */
  $path = preg_replace("|[^/^\.]+/\.\.$|", "", $path);
  /*  ./xxxxx -> xxxxx */
  $path = preg_replace("|^\./|", "", $path);
  /*  xxxxx/. -> xxxxx */
  $path = preg_replace("|/\.$|", "", $path);
  /* /./ -> / */
  $path = preg_replace("|/\./|", "/", $path);
  /*  [/]+ -> /  */
  $path = preg_replace("|[/]+|", "/", $path);
  /* /  la fin */
  $path = preg_replace("|/$|", "", $path);

  if (!$path): $path='.'; endif;

  return $path;
}
function canonize_path($path) {
  while ($path != ($p=_canonize_path($path))):
    $path = $p;
  endwhile;
  return $path;
}

?>