<?
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Author : Jean-Christophe Cardot
   CopyRight (c) 2000-2002 Jean-Christophe Cardot <taz98@altern.org>
 */

// TODO
// * remplacer .cvs par .explore et mettre a ds une variable dfinie dans explore_vars.inc
// * sparer les fonctions entre diffrents fichiers et plus utiliser include

// mise de $PHP_SELF  la forme canonique /path/page.php3
// En effet, free.fr renvoie serveur.free.fr/path/page.php3, et
// les installs normales renvoient /path/page.php3...
//$server = "talk.free.fr";
//$prefix2trim = "\\/$server";
//$PHP_SELF = preg_replace("/^$prefix2trim/", "", $PHP_SELF);

/********************************************************/
/* rpertoire o se situe les fichiers de l'explorateur */
/********************************************************/
$explore_dir = "explore2";

//include "$explore_dir/include/log.inc"; /* dfinit la fonction writelog() */
function writelog($f,$s,$t) {
}
include "$explore_dir/include/explore_vars.inc"; /* variables communes */
include "$explore_dir/include/filetype.inc"; /* icones suivant le type de fichier */

if ($logout):
  writelog($logfile, $HTTP_COOKIE_VARS["username"], "LOGOUT");
  /* on "vire" les cookies */
  setcookie($cookieuser, "none", time()+12, "/");
  setcookie($cookieclef, "none", time()+12, "/");
//OLD  header("Location: login.php3?$argv[0]"); /* allez vous loguer ! */
endif;
include "$explore_dir/include/nocache.inc"; /* on ne cache pas cette page */

/***************************************************************
 * authentification
 ***************************************************************/
if (!($edit && $enregistrer) && !$fin_edition): /* pas d'authentification
  si on enregistre un fichier sinon on risque de le perdre */
  include "$explore_dir/include/verifylogin.inc";
endif;

/***************************************************************
 * download
 ***************************************************************/
if ($download):
  include "$explore_dir/include/download.inc";
  exit;
endif;

/***************************************************************
 * initialisation du systme de verrous sur les fichiers
 ***************************************************************/
include "$explore_dir/include/initcvs.inc";

/***************************************************************
 * edit
 ***************************************************************/
if ($edit):
  include "$explore_dir/include/edit.inc";
  exit;
endif;

/***************************************************************
/* explore
 ***************************************************************/

// dfinition des fonctions
include "$explore_dir/include/functions.inc";
include "$explore_dir/include/canonize.inc";

// nettoyage du rpertoire en cours
$rep2browse = canonize_path($rep2browse);

?>

<html>
<head>
   <meta name="Author" content="Jean-Christophe Cardot">
   <meta name="GENERATOR" content="autogenerated :-)">
   <meta name="Description" content="Gestionnaire de fichiers">
   <meta name="created" content="20000229;00000000">
   <meta name="changedby" content="JCC">
   <meta name="changed" content="20001123;00000000">
   <title>Gestionnaire de fichiers - <?echo $rep2browse?></title>
</head>
<body bgcolor="#FFFFFF">

<table width="100%">
 <tr>
  <td><font size="+2"><strong>Gestionnaire de fichiers (<?echo $HTTP_COOKIE_VARS[$cookieuser]?>)</strong></font></td>
  <td align=right><em>Le <?echo Date("d/m/Y  H:i:s",time())?>.</em></td>
 </tr>
</table>

<?
clearstatcache(); /* sinon le rsultat de filesize est cach */

/* --------------- dfinition des constantes ---------------- */

$outputbegin = "<table border=\"1\"><tr><td bgcolor=\"#C0C0C0\"><b><u>R&eacute;sultat</u> :</b>\n";
$outputend = "\n</td></tr></table>\n";
$maxuploadsize = 2097152; /* 2 Mo */


/* --------------- initialisation des variables ------------- */

$keepselected = 0; /*  priori, on ne laisse pas cochs les fichiers slectionns */


/* ---------------- excution des actions ---------------- */

/* ouverture du formulaire */
echo "<form action='$PHP_SELF?rep2browse=".rawurlencode("$rep2browse")."' enctype='multipart/form-data' method='POST'>\n";

/* Remove */
if ($remove || $force_recursive_delete):
  include "$explore_dir/include/dorm.inc";
endif;

/* Copy */
if ($copy):
  include "$explore_dir/include/docp.inc";
endif;

/* Move */
if ($move):
  include "$explore_dir/include/domv.inc";
endif;

/* Link */
if ($link):
  include "$explore_dir/include/doln.inc";
endif;

/* Chmod */
if ($chmod && (count($selected)>0) && $destination):
  $logstr = "CHMOD";
  echo $outputbegin;
  if (!(preg_match("/^0?[0-7]{3}$/", "$destination"))):
    echo "<br>Valeur de mode <tt>$destination</tt> incorrecte (3 chiffres octaux)";
  else:
    $destination = preg_replace("/^0?([0-7]{3})$/", "\\1", $destination);
    for(reset($selected); $dentry = $selected[key($selected)]; next($selected)):
      if (chmod($dentry, octdec("$destination"))):
        $logstr .= " (".basename($dentry).", 0$destination)";
        echo "<br>Le mode de <tt>".basename($dentry)."</tt> a &eacute;t&eacute; chang&eacute; en <tt>0$destination</tt>\n";
      else:
        echo "<br>Impossible de changer le mode de <tt>".basename($dentry)."</tt> en <tt>0$destination</tt>\n";
      endif;
    endfor;
  endif;
  echo $outputend;
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], $logstr);
endif;

/* Mkdir */
if ($mkdir):
  include "$explore_dir/include/domkdir.inc";
endif;

/* Touch */
if ($touch):
  include "$explore_dir/include/dotouch.inc";
endif;

/* Upload */
function do_upload() {
  global $rep2browse, $userfile, $userfile_name, $userfile_size, $userfile_type, $maxuploadsize;
  $ret=0;
  echo "<br>Importation en cours... &quot;<tt>$userfile</tt>&quot;\n";
  echo "<br>userfile=$userfile, ";
  echo "userfile_name=$userfile_name, ";
  echo "userfile_size=$userfile_size, ";
  echo "userfile_type=$userfile_type\n";
  echo "<br>";
  if ($userfile_size>$maxuploadsize):
    echo "Impossible d'importer ce fichier : limite de 2 Mo d&eacute;pass&eacute;e";
  else:
    if (is_file("$rep2browse/$userfile_name")):
      rename("$rep2browse/$userfile_name", "$rep2browse/$userfile_name.".Date("Ymd-His",time()).".".$HTTP_COOKIE_VARS[$cookieuser]);
    endif;
    if (copy($userfile, "$rep2browse/$userfile_name")):
      unlink($userfile);
      echo "Le fichier <tt>$userfile_name</tt> a &eacute;t&eacute; import&eacute;";
      $ret=1;
    else:
      echo "Impossible d'importer le fichier <tt>$userfile_name</tt>";
    endif;
  endif;
  return $ret;
}

if ((!$checkin) && $userfile && ($userfile!="none")):
  $logstr = "UPLOAD $userfile, $userfile_name, $userfile_size, $userfile_type";
  echo $outputbegin;
  do_upload();
  echo $outputend;
  writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], $logstr);
endif;

/* actions du CVS */
if ($allowCVS):
  include "$explore_dir/include/docvs.inc";
endif;

/* on referme ventuellement un ou des rpertoires */
if (isset($collapse)):
  while (list($k,$v)=each($collapse)):
    if (isset($expand[$k])):
      unset($expand[$k]);
    endif;
  endwhile;
endif;

/*----------------------------------------------------------------------------------*/
/* OK, on a fait toutes les actions possibles : on affiche maintenant le rpertoire */
/*----------------------------------------------------------------------------------*/

writelog($logfile, $HTTP_COOKIE_VARS[$cookieuser], "LS $rep2browse");

echo "<table width='100%'>\n";
echo " <tr>\n";
echo "  <td><img src='$explore_dir/pics/dir.png'><font size='+1'><strong> Parcours du rpertoire '<tt>$rep2browse</tt>'</strong></font></td>\n";
echo "  <td align='right'>";
//echo "<input type='submit' name='refreshCookies' value='Refresh'>\n";
echo "<input type='submit' name='toggleCVS";
if ($allowCVS): echo "0' value='D&eacute;sa"; else: echo "1' value='A"; endif;
echo "ctiver CVS'>\n";
echo "<input type='submit' name='logout' value='Logout'></td>\n";
echo " </tr>\n";
echo "</table>\n";

echo "<table border='0' cellpadding='0' cellspacing='0' width='0'>\n";
//echo "<COLGROUP span='99' width='22'>\n";
list ($totalsize, $nbdossiers, $nbfiles) = printDir($rep2browse, "", 1, 1);
echo "</table>";

/* on mmorise les rpertoires ouverts */
if (isset($expand)):
  while (list($k,$v)=each($expand)):
    echo "<input type='hidden' name='expand[$k]' value='$v'>";
  endwhile;
endif;

echo "<table border='0' cellpadding='0' cellspacing='0'>\n";
echo " <tr>\n <td></td>\n <td>$nbdossiers dossiers et $nbfiles fichier";
if ($nbfiles>1): echo "s"; endif;
echo " ($totalsize octets)</td>\n </tr>\n";

if ($allowCVS):
  echo " <tr>\n";
  echo "  <td></td>\n";
  echo "  <td><br><input type='submit' name='checkout' value='Checkout'>\n";
  echo "      &nbsp;&nbsp;&nbsp;&nbsp;<input name='userfile' type='file' value='$userfile' size='8'>\n";
  echo "      <input type='hidden' name='MAX_FILE_SIZE' value='$maxuploadsize'>\n";
  echo "      <input type='submit' name='checkin' value='Checkin'>&nbsp;&nbsp;&nbsp;&nbsp;\n";
  echo "      |&nbsp;&nbsp;&nbsp;&nbsp;<input type='submit' name='checkoutlist' value='Liste des checkout'>\n";
  echo "  </td>\n";
  echo " </tr>\n";
endif;

echo " <tr>\n";
echo "  <td><input type='submit' name='remove' value='rm ' style='font-family:Courier'>\n";
echo "      <br><input type='submit' name='copy' value='cp:' style='font-family:Courier'>\n";
echo "      <br><input type='submit' name='move' value='mv:' style='font-family:Courier'>\n";
echo "      <br><input type='submit' name='link' value='ln:' style='font-family:Courier'>\n";
echo "      <br><input type='submit' name='chmod' value='chmod:' style='font-family:Courier'>\n";
echo "  </td>\n";
echo "  <td><input type='text' name='destination' value='$destination'></td>\n";
echo " </tr>\n";
echo "</table>\n";
echo "<hr>\n<input type='text' name='newdirname' value='$newdirname'> ";
echo "<tt>(</tt><input type='text' name='mode' value='0755' size='4'><tt>)</tt> ";
echo "<input type='submit' name='mkdir' value='mkdir' style='font-family:Courier'>\n";
echo "<br><input type='text' name='touchfile' value='$touchfile'> ";
echo "<input type='submit' name='touch' value='touch' style='font-family:Courier'>";
echo "<input type='hidden' name='allowCVS' value='$allowCVS'>\n";
echo "</form>\n<hr>\n";

/* formulaire pour l'importation d'un fichier */
echo "<form action='$PHP_SELF?rep2browse=$rep2browse' enctype='multipart/form-data' method='POST'>\n";
echo "<input name='rep2browse' type='hidden' value='$rep2browse'>\n";
echo "Importer ce fichier : <input name='userfile' type='file' value='$userfile'>\n";
echo "<input type='hidden' name='MAX_FILE_SIZE' value='$maxuploadsize'>\n";
echo "<br><input type='submit' value='Upload'>";
echo "<input type='hidden' name='allowCVS' value='$allowCVS'>\n";
echo "</form>\n";

?>

<hr>
<table border='0' width='100%'>
 <tr>
  <td>
   <a href='<?echo $explore_dir;?>/filetype.php3' target='_blank'>Associations/Types</a>
  </td>
  <td align='right'>
   &copy; 2000 Jean-Christophe &quot;Jic&eacute;&quot; Cardot <em>&lt;taz98@altern.org&gt;</em>
   <br><em>PHP was here :)</em>
  </td>
 </tr>
</table>

</body>
</html>
