<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

?>

<div class="content">

<?php
require_once ("include/checklevel.php");
?>

	<h2><?php echo TXT_USERS_UTILISATEURS; ?></h2>
	
	<p>
		<a href="add_user.php"><?php echo TXT_USERS_AJOUT_NOUVEL_UTILISATEUR; ?></a><br />
	</p>
	
	<table border="0" width="100%" align="center" cellpadding="3" cellspacing="0">
		<tr>
			<th><?php echo TXT_USERS_NOM; ?></th>
			<th><?php echo TXT_USERS_PRENOM; ?></th>
			<th><?php echo TXT_USERS_LOGIN; ?></th>
			<th><?php echo TXT_USERS_NIVEAU; ?></th>
			<th><?php echo TXT_USERS_ACTIF; ?></th>
			<th><?php echo TXT_USERS_DERNIERE_CONNEXION; ?></th>
			<th class="cellright"><?php echo TXT_USERS_ACTIONS; ?></th>
		</tr>
		
<?php
$count = 0;
$req = Requete ("SELECT * FROM users ORDER BY user_nom;",$conn);

while ($rs = ObjetSuivant($req))
{
	$count += 1;
	if ($count % 2 > 0)
	{
		$class = "data1";
	}
	else
	{
		$class = "data2";
	}
	echo "<tr class=\"".$class."\">\n";
	echo "<td>".$rs->user_nom."</td>\n";
	echo "<td>".$rs->user_prenom."</td>\n";
	echo "<td>".$rs->user_login."</td>\n";
	switch ($rs->user_level)
	{
		case 0:
			echo "<td>".TXT_USERS_ADMIN."</td>\n";
			break;
		case 1:
			echo "<td>".TXT_USERS_NORMAL."</td>\n";
			break;
	}
	if ($rs->user_isactive)
	{
		echo "<td><a href=\"user_active.php?id=".$rs->user_id."\">".TXT_USERS_OUI."</a></td>\n";
	}
	else
	{
		echo "<td><a href=\"user_active.php?id=".$rs->user_id."\">".TXT_USERS_NON."</a></td>\n";
	}
	if (is_null($rs->user_last_connect))
	{
		echo "<td>".TXT_USERS_JAMAIS."</td>\n";
	}
	else
	{
		echo "<td>".FormateDate($rs->user_last_connect)."</td>\n";
	}
	echo "<td class=\"cellright\">";
	echo "<a href=\"mod_user.php?id=".$rs->user_id."\"><img src=\"images/b_edit.gif\" border=\"0\" alt=\"".TXT_USERS_MODIFIER."\" title=\"".TXT_USERS_MODIFIER."\"></a>&nbsp;";
	echo "<a href=\"delete.php?mode=user&id=".$rs->user_id."\"><img src=\"images/b_drop.gif\" border=\"0\" alt=\"".TXT_USERS_SUPPRIMER."\" title=\"".TXT_USERS_SUPPRIMER."\"></a>";
	echo "</td>\n";
	echo "</tr>\n";
}

?>

	</table>
	
	<br />

</div>

<?php
require_once ('include/footer.php');
?>