<?php

// Copyright (C) 2008 Self-Reliance asbl

// This file is part of PhpDaily.

// PhpDaily is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// PhpDaily is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with PhpDaily. If not, see http://www.gnu.org/licenses/ 

require_once ('include/header.php');
require_once ('include/menu.php');
require_once ("include/connect.php");
require_once ("include/connexion.php");
require_once ("include/query.php");
require_once ("include/date_functions.php");
require_once ("include/text_functions.php");

$conn = Connexion (NOM, PASSE, BASE, SERVEUR);

$user_id = $_POST['user_id'];
$aff_proj = $_POST['projet'];
if ($aff_proj == 0)
{
	$projet_order_by = "projets.proj_num";
}
else
{
	$projet_order_by = "projets.proj_titre_abr";
}
$annee = $_POST['annee'];
if (isset($_POST['domaines']))
{
	$dom = TRUE;
	$domaine_select = "domaines,";
	$domaine_where = "AND prestations.pre_fk_domaine = domaines.dom_id";
	$domaine_order_by = "dom_id,";
}
else
{
	$dom = FALSE;
	$domaine_select = "";
	$domaine_where = "";
	$domaine_order_by = "";
}
$hrs_day = $_POST['hrs_day'];

if ($user_id > 0)
{
	$req = Requete ("SELECT * FROM users WHERE user_id = $user_id",$conn);
	while ($rs = ObjetSuivant($req))
	{
		$nom = $rs->user_prenom." ".$rs->user_nom;
	}
	$user_clause = "AND prestations.pre_fk_user = $user_id";
}
else
{
	$nom = "Tous";
	$user_clause = "";
}

?>

<div class="content">

	<h2><?php echo TXT_STAT_PREST_PROJET_MOIS_PRESTA_PAR_MOIS; ?><?php echo TXT_PROJET_PROJET; ?><br /><?php echo TXT_STAT_PREST_PROJET_MOIS_POUR; ?><?php echo $nom; ?><br /><?php echo TXT_STAT_PREST_PROJET_MOIS_EN; ?><?php echo $annee; ?></h2>
	
<?php

$sql = "SELECT * FROM prestations, $domaine_select projets WHERE prestations.pre_fk_projet = projets.proj_id $domaine_where AND YEAR(prestations.pre_date) = $annee $user_clause ORDER BY $projet_order_by, $domaine_order_by prestations.pre_date;";
$req = Requete ($sql,$conn);

$ligne = "";

if (NombreLignes($req) > 0)
{
	echo "<table class=\"stat_table\" border=\"0\" align=\"center\" cellpadding=\"3\" cellspacing=\"0\">\n";
	echo "<tr><th class=\"stat_first\">".TXT_PROJET_PROJET."</th>\n";
	$ligne = html_entity_decode(TXT_PROJET_PROJET);
	if ($dom)
	{
		echo "<th class=\"stat_top\">".TXT_STAT_PREST_PROJET_MOIS_DOM."</th>\n";
		$ligne .= ",".html_entity_decode(TXT_STAT_PREST_PROJET_MOIS_DOM);
	}
	if ($annee == date('Y'))
	{
		$mois_actu = date('n');
	}
	else
	{
		$mois_actu = 12;
	}
	$total_mois = array();
	for ($i=1; $i<=$mois_actu; $i++)
	{
		echo "<th class=\"stat_top\">".NomDuMoisCourt($i)."</th>\n";
		$ligne .= ",".html_entity_decode(NomDuMoisCourt($i));
		$total_mois[$i] = 0;
	}
	echo "<th class=\"stat_top\">".TXT_STAT_PREST_PROJET_MOIS_TOTAL."</th>\n";
	$ligne .= ",".html_entity_decode(TXT_STAT_PREST_PROJET_MOIS_TOTAL);
	echo "</tr>\n";
	
	$tab[] = $ligne;

	$projet = 0;
	$domaine = 0;
	$mois = 1;
	$heures = 0;
	$total_projet = 0;
	$total = 0;
	$first = TRUE;
	echo "<tr>\n";
	$ligne = "";

	while ($rs = ObjetSuivant($req))
	{
		if ($dom)
		{
			if ($projet != $rs->proj_id || $domaine != $rs->dom_id)
			{
				if ($first)
				{
					$first = FALSE;
				}
				else
				{
					echo "<td class=\"stat\">".heures($heures)."</td>\n";
					$ligne .= ",".heures($heures);
					$total_projet += $heures;
					$total_mois[$mois] += $heures;
					while ($mois < $mois_actu)
					{
						echo "<td class=\"stat\">-</td>\n";
						$ligne .= ",-";
						$mois += 1;
					}
					echo "<td class=\"total_col\">".heures($total_projet)."</td>\n";
					$ligne .= ",".heures($total_projet);
					echo "</tr>\n";
					$tab[] = $ligne;
					$mois = 1;
					$total_projet = 0;
				}
				echo "<tr>\n";
				$ligne = "";
				if ($projet != $rs->proj_id)
				{
					if ($aff_proj == 0)
					{
						echo "<td class=\"stat_titre\">".$rs->proj_num."</td>\n";
						$ligne = $rs->proj_num;
					}
					else
					{
						echo "<td class=\"stat_titre\">".$rs->proj_titre_abr."</td>\n";
						$ligne = SansQuotes(html_entity_decode($rs->proj_titre_abr));
					}
				}
				else
				{
					echo "<td class=\"stat_titre\">&nbsp;</td>\n";
					$ligne = " ";
				}
				echo "<td class=\"stat_titre\">".$rs->dom_id."</td>\n";
				$ligne .= ",".$rs->dom_id;
				while ($mois != Mois($rs->pre_date))
				{
					echo "<td class=\"stat\">-</td>\n";
					$ligne .= ",-";
					$mois += 1;
				}
				$projet = $rs->proj_id;
				$domaine = $rs->dom_id;
				$heures = $rs->pre_heures;
			}
			elseif ($mois != Mois($rs->pre_date))
			{
				echo "<td class=\"stat\">".heures($heures)."</td>\n";
				$ligne .= ",".heures($heures);
				$total_projet += $heures;
				$total_mois[$mois] += $heures;
				$mois += 1;
				while ($mois != Mois($rs->pre_date))
				{
					echo "<td class=\"stat\">-</td>\n";
					$ligne .= ",-";
					$mois += 1;
				}
				$heures = $rs->pre_heures;
			}
			else
			{
				$heures += $rs->pre_heures;
			}
		}
		else
		{
			if ($projet != $rs->proj_id)
			{
				if ($first)
				{
					$first = FALSE;
				}
				else
				{
					echo "<td class=\"stat\">".heures($heures)."</td>\n";
					$ligne .= ",".heures($heures);
					$total_projet += $heures;
					$total_mois[$mois] += $heures;
					while ($mois < $mois_actu)
					{
						echo "<td class=\"stat\">-</td>\n";
						$ligne .= ",-";
						$mois += 1;
					}
					echo "<td class=\"total_col\">".heures($total_projet)."</td>\n";
					$ligne .= ",".heures($total_projet);
					echo "</tr>\n";
					$tab[] = $ligne;
					$mois = 1;
					$total_projet = 0;
				}
				echo "<tr>\n";
				$ligne = "";
				if ($aff_proj == 0)
				{
					echo "<td class=\"stat_titre\">".$rs->proj_num."</td>\n";
					$ligne = $rs->proj_num;
				}
				else
				{
					echo "<td class=\"stat_titre\">".$rs->proj_titre_abr."</td>\n";
					$ligne = SansQuotes(html_entity_decode($rs->proj_titre_abr));
				}
				while ($mois != Mois($rs->pre_date))
				{
					echo "<td class=\"stat\">-</td>\n";
					$ligne .= ",-";
					$mois += 1;
				}
				$projet = $rs->proj_id;
				$heures = $rs->pre_heures;
			}
			elseif ($mois != Mois($rs->pre_date))
			{
				echo "<td class=\"stat\">".heures($heures)."</td>\n";
				$ligne .= ",".heures($heures);
				$total_projet += $heures;
				$total_mois[$mois] += $heures;
				$mois += 1;
				while ($mois != Mois($rs->pre_date))
				{
					echo "<td class=\"stat\">-</td>\n";
					$ligne .= ",-";
					$mois += 1;
				}
				$heures = $rs->pre_heures;
			}
			else
			{
				$heures += $rs->pre_heures;
			}
		}
	}
	echo "<td class=\"stat\">".heures($heures)."</td>\n";
	$ligne .= ",".heures($heures);
	$total_projet += $heures;
	$total_mois[$mois] += $heures;
	while ($mois < $mois_actu)
	{
		echo "<td class=\"stat\">-</td>\n";
		$ligne .= ",-";
		$mois += 1;
	}
	echo "<td class=\"total_col\">".heures($total_projet)."</td>\n";
	$ligne .= ",".heures($total_projet);
	echo "</tr>\n";
	$tab[] = $ligne;
	echo "<tr>\n";
	$ligne = "";
	echo "<td class=\"stat_titre\"";
	if ($dom)
	{
		echo " colspan=\"2\"";
	}
	echo ">".TXT_STAT_PREST_PROJET_MOIS_TOTAL_HEURES."</td>\n";
	$ligne = html_entity_decode(TXT_STAT_PREST_PROJET_MOIS_TOTAL_HEURES);
	if ($dom)
	{
		$ligne .= ", ";
	}
	for ($i=1; $i<=$mois_actu; $i++)
	{
		echo "<td class=\"total_row\">".heures($total_mois[$i])."</td>\n";
		$ligne .= ",".heures($total_mois[$i]);
		$total += $total_mois[$i];
	}
	echo "<td class=\"total_gen\">".heures($total)."</td>\n";
	$ligne .= ",".heures($total);
	echo "</tr>\n";
	$tab[] = $ligne;
	echo "<tr>\n";
	$ligne = "";
	echo "<td class=\"stat_titre\"";
	if ($dom)
	{
		echo " colspan=\"2\"";
	}
	echo ">".TXT_STAT_PREST_PROJET_MOIS_TOTAL_JOURS."</td>\n";
	$ligne = html_entity_decode(TXT_STAT_PREST_PROJET_MOIS_TOTAL_JOURS);
	if ($dom)
	{
		$ligne .= ", ";
	}
	for ($i=1; $i<=$mois_actu; $i++)
	{
		echo "<td class=\"total_row\">".number_format((heures($total_mois[$i])/$hrs_day),1)."</td>\n";
		$ligne .= ",".number_format((heures($total_mois[$i])/$hrs_day),1);
	}
	echo "<td class=\"total_gen\">".number_format((heures($total)/$hrs_day),1)."</td>\n";
	$ligne .= ",".number_format((heures($total)/$hrs_day),1);
	echo "</tr>\n";
	$tab[] = $ligne;
	echo "</table>\n";
	
	echo "<br />";
	
	echo "<h2>\n";
	echo "<form name=\"export_stats\" action=\"process_export.php\" method=\"post\">\n";
	echo "<input type=\"hidden\" name=\"exptype\" value=\"4\">\n";
	echo "<input type=\"hidden\" name=\"tabstats\" value='".serialize($tab)."'>\n";
	echo "<input type=\"submit\" class=\"bouton\" value=\"Exporter\">\n";
	echo "</form>\n";
	echo "</h2>\n";
}
else
{
	echo "<p>".TXT_STAT_PREST_PROJET_MOIS_PAS_DONNEES."</p>\n";
}
?>

</div>

<?php
require_once ('include/footer.php');
?>